/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.repl;

import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ReplClassLoader
extends ClassLoader {
    private Map<JvmClassName, byte[]> classes;

    public ReplClassLoader(@NotNull ClassLoader parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/cli/jvm/repl/ReplClassLoader", "<init>"));
        }
        super(parent);
        this.classes = Maps.newLinkedHashMap();
    }

    public ReplClassLoader() {
        this.classes = Maps.newLinkedHashMap();
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.classes.get(JvmClassName.byFqNameWithoutInnerClasses(name));
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return super.findClass(name);
    }

    public void addClass(@NotNull JvmClassName className, @NotNull byte[] bytes) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/cli/jvm/repl/ReplClassLoader", "addClass"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/jet/cli/jvm/repl/ReplClassLoader", "addClass"));
        }
        byte[] oldBytes = this.classes.put(className, bytes);
        if (oldBytes != null) {
            throw new IllegalStateException("Rewrite at key " + className);
        }
    }

    public void dumpClasses(@NotNull PrintWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/jet/cli/jvm/repl/ReplClassLoader", "dumpClasses"));
        }
        for (byte[] classBytes : this.classes.values()) {
            new ClassReader(classBytes).accept(new TraceClassVisitor(writer), 0);
        }
    }
}

