/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.openapi.util.Pair;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializerExtension;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedPropertyDescriptor;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.kotlin.SignatureDeserializer;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JavaSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;

    public JavaSerializerExtension(@NotNull JvmSerializationBindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/jet/codegen/JavaSerializerExtension", "<init>"));
        }
        this.bindings = bindings;
    }

    @Override
    public void serializeCallable(@NotNull CallableMemberDescriptor callable2, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeCallable"));
        }
        this.saveSignature(callable2, proto, nameTable);
        this.saveImplClassName(callable2, proto, nameTable);
    }

    @Override
    public void serializeValueParameter(@NotNull ValueParameterDescriptor descriptor, @NotNull ProtoBuf.Callable.ValueParameter.Builder proto, @NotNull NameTable nameTable) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeValueParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeValueParameter"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "serializeValueParameter"));
        }
        Integer index = this.bindings.get(JvmSerializationBindings.INDEX_FOR_VALUE_PARAMETER, descriptor);
        if (index != null) {
            proto.setExtension(JavaProtoBuf.index, index);
        }
    }

    private void saveSignature(@NotNull CallableMemberDescriptor callable2, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveSignature"));
        }
        SignatureSerializer signatureSerializer = new SignatureSerializer(nameTable);
        if (callable2 instanceof FunctionDescriptor) {
            JavaProtoBuf.JavaMethodSignature signature;
            if (callable2 instanceof DeserializedSimpleFunctionDescriptor) {
                DeserializedSimpleFunctionDescriptor deserialized = (DeserializedSimpleFunctionDescriptor)callable2;
                signature = signatureSerializer.copyMethodSignature(deserialized.getProto().getExtension(JavaProtoBuf.methodSignature), deserialized.getNameResolver());
            } else {
                Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, (FunctionDescriptor)callable2);
                JavaProtoBuf.JavaMethodSignature javaMethodSignature = signature = method != null ? signatureSerializer.methodSignature(method) : null;
            }
            if (signature != null) {
                proto.setExtension(JavaProtoBuf.methodSignature, signature);
            }
        } else if (callable2 instanceof PropertyDescriptor) {
            JavaProtoBuf.JavaPropertySignature signature;
            Method syntheticMethod;
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            PropertyDescriptor property2 = (PropertyDescriptor)callable2;
            PropertyGetterDescriptor getter = property2.getGetter();
            PropertySetterDescriptor setter = property2.getSetter();
            Method getterMethod = getter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter);
            Method setterMethod = setter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter);
            Pair<Type, String> field = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, property2);
            if (field != null) {
                fieldType = (Type)field.first;
                fieldName = (String)field.second;
                isStaticInOuter = this.bindings.get(JvmSerializationBindings.STATIC_FIELD_IN_OUTER_CLASS, property2);
                syntheticMethod = null;
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
                syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, property2);
            }
            if (callable2 instanceof DeserializedPropertyDescriptor) {
                DeserializedPropertyDescriptor deserializedCallable = (DeserializedPropertyDescriptor)callable2;
                signature = signatureSerializer.copyPropertySignature(deserializedCallable.getProto().getExtension(JavaProtoBuf.propertySignature), deserializedCallable.getNameResolver());
            } else {
                signature = signatureSerializer.propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethod, getterMethod, setterMethod);
            }
            proto.setExtension(JavaProtoBuf.propertySignature, signature);
        }
    }

    private void saveImplClassName(@NotNull CallableMemberDescriptor callable2, @NotNull ProtoBuf.Callable.Builder proto, @NotNull NameTable nameTable) {
        if (callable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveImplClassName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveImplClassName"));
        }
        if (nameTable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension", "saveImplClassName"));
        }
        String name = this.bindings.get(JvmSerializationBindings.IMPL_CLASS_NAME_FOR_CALLABLE, callable2);
        if (name != null) {
            proto.setExtension(JavaProtoBuf.implClassName, nameTable.getSimpleNameIndex(Name.identifier(name)));
        }
    }

    @NotNull
    private static Method getAsmMethod(@NotNull String nameAndDesc) {
        if (nameAndDesc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAndDesc", "org/jetbrains/jet/codegen/JavaSerializerExtension", "getAsmMethod"));
        }
        int indexOf = nameAndDesc.indexOf(40);
        Method method = new Method(nameAndDesc.substring(0, indexOf), nameAndDesc.substring(indexOf));
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension", "getAsmMethod"));
        }
        return method;
    }

    private static class SignatureSerializer {
        private final NameTable nameTable;

        public SignatureSerializer(@NotNull NameTable nameTable) {
            if (nameTable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameTable", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "<init>"));
            }
            this.nameTable = nameTable;
        }

        @NotNull
        public JavaProtoBuf.JavaMethodSignature copyMethodSignature(@NotNull JavaProtoBuf.JavaMethodSignature signature, @NotNull NameResolver nameResolver) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "copyMethodSignature"));
            }
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "copyMethodSignature"));
            }
            String method = new SignatureDeserializer(nameResolver).methodSignatureString(signature);
            JavaProtoBuf.JavaMethodSignature javaMethodSignature = this.methodSignature(JavaSerializerExtension.getAsmMethod(method));
            if (javaMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "copyMethodSignature"));
            }
            return javaMethodSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaMethodSignature methodSignature(@NotNull Method method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            JavaProtoBuf.JavaMethodSignature.Builder signature = JavaProtoBuf.JavaMethodSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(method.getName())));
            signature.setReturnType(this.type(method.getReturnType()));
            for (Type type : method.getArgumentTypes()) {
                signature.addParameterType(this.type(type));
            }
            JavaProtoBuf.JavaMethodSignature javaMethodSignature = signature.build();
            if (javaMethodSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            return javaMethodSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaPropertySignature copyPropertySignature(@NotNull JavaProtoBuf.JavaPropertySignature signature, @NotNull NameResolver nameResolver) {
            boolean isStaticInOuter;
            String fieldName;
            Type fieldType;
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "copyPropertySignature"));
            }
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "copyPropertySignature"));
            }
            SignatureDeserializer signatureDeserializer = new SignatureDeserializer(nameResolver);
            if (signature.hasField()) {
                JavaProtoBuf.JavaFieldSignature field = signature.getField();
                fieldType = Type.getType(signatureDeserializer.typeDescriptor(field.getType()));
                fieldName = nameResolver.getName(field.getName()).asString();
                isStaticInOuter = field.getIsStaticInOuter();
            } else {
                fieldType = null;
                fieldName = null;
                isStaticInOuter = false;
            }
            Method syntheticMethod = signature.hasSyntheticMethod() ? JavaSerializerExtension.getAsmMethod(signatureDeserializer.methodSignatureString(signature.getSyntheticMethod())) : null;
            Method getter = signature.hasGetter() ? JavaSerializerExtension.getAsmMethod(signatureDeserializer.methodSignatureString(signature.getGetter())) : null;
            Method setter = signature.hasSetter() ? JavaSerializerExtension.getAsmMethod(signatureDeserializer.methodSignatureString(signature.getSetter())) : null;
            JavaProtoBuf.JavaPropertySignature javaPropertySignature = this.propertySignature(fieldType, fieldName, isStaticInOuter, syntheticMethod, getter, setter);
            if (javaPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "copyPropertySignature"));
            }
            return javaPropertySignature;
        }

        @NotNull
        public JavaProtoBuf.JavaPropertySignature propertySignature(@Nullable Type fieldType, @Nullable String fieldName, boolean isStaticInOuter, @Nullable Method syntheticMethod, @Nullable Method getter, @Nullable Method setter) {
            JavaProtoBuf.JavaPropertySignature.Builder signature = JavaProtoBuf.JavaPropertySignature.newBuilder();
            if (fieldType != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldType;
                signature.setField(this.fieldSignature(fieldType, fieldName, isStaticInOuter));
            }
            if (syntheticMethod != null) {
                signature.setSyntheticMethod(this.methodSignature(syntheticMethod));
            }
            if (getter != null) {
                signature.setGetter(this.methodSignature(getter));
            }
            if (setter != null) {
                signature.setSetter(this.methodSignature(setter));
            }
            JavaProtoBuf.JavaPropertySignature javaPropertySignature = signature.build();
            if (javaPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            return javaPropertySignature;
        }

        @NotNull
        public JavaProtoBuf.JavaFieldSignature fieldSignature(@NotNull Type type, @NotNull String name, boolean isStaticInOuter) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            JavaProtoBuf.JavaFieldSignature.Builder signature = JavaProtoBuf.JavaFieldSignature.newBuilder();
            signature.setName(this.nameTable.getSimpleNameIndex(Name.guess(name)));
            signature.setType(this.type(type));
            if (isStaticInOuter) {
                signature.setIsStaticInOuter(true);
            }
            JavaProtoBuf.JavaFieldSignature javaFieldSignature = signature.build();
            if (javaFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            return javaFieldSignature;
        }

        @NotNull
        public JavaProtoBuf.JavaType type(@NotNull Type givenType) {
            if (givenType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "givenType", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "type"));
            }
            JavaProtoBuf.JavaType.Builder builder = JavaProtoBuf.JavaType.newBuilder();
            int arrayDimension = 0;
            Type type = givenType;
            while (type.getSort() == 9) {
                ++arrayDimension;
                type = type.getElementType();
            }
            if (arrayDimension != 0) {
                builder.setArrayDimension(arrayDimension);
            }
            if (type.getSort() == 10) {
                FqName fqName = SignatureSerializer.internalNameToFqName(type.getInternalName());
                builder.setClassFqName(this.nameTable.getFqNameIndex(fqName));
            } else {
                builder.setPrimitiveType(JavaProtoBuf.JavaType.PrimitiveType.valueOf(type.getSort()));
            }
            JavaProtoBuf.JavaType javaType = builder.build();
            if (javaType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "type"));
            }
            return javaType;
        }

        @NotNull
        private static FqName internalNameToFqName(@NotNull String internalName) {
            if (internalName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            FqName fqName = FqName.fromSegments(Arrays.asList(internalName.split("/")));
            if (fqName == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JavaSerializerExtension$SignatureSerializer", "internalNameToFqName"));
            }
            return fqName;
        }
    }
}

