/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.intellij.util.containers.Stack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.ImplementationBodyCodegen;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.OwnerKind;
import org.jetbrains.jet.codegen.binding.CalculatedClosure;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.MethodContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.config.IncrementalCompilation;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isInterface(DeclarationDescriptor descriptor) {
        if (descriptor instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor).getKind();
            return kind == ClassKind.TRAIT || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isInterface(JetType type) {
        return JvmCodegenUtil.isInterface(type.getConstructor().getDeclarationDescriptor());
    }

    public static SimpleFunctionDescriptor createInvoke(FunctionDescriptor fd) {
        int arity = fd.getValueParameters().size();
        SimpleFunctionDescriptorImpl invokeDescriptor = SimpleFunctionDescriptorImpl.create(fd.getExpectedThisObject() != null ? KotlinBuiltIns.getInstance().getExtensionFunction(arity) : KotlinBuiltIns.getInstance().getFunction(arity), Annotations.EMPTY, Name.identifier("invoke"), CallableMemberDescriptor.Kind.DECLARATION);
        invokeDescriptor.initialize(DescriptorUtils.getReceiverParameterType(fd.getReceiverParameter()), fd.getExpectedThisObject(), Collections.emptyList(), (List)fd.getValueParameters(), fd.getReturnType(), Modality.FINAL, Visibilities.PUBLIC);
        return invokeDescriptor;
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isConst"));
        }
        return closure.getCaptureThis() == null && closure.getCaptureReceiverType() == null && closure.getCaptureVariables().isEmpty();
    }

    public static <T> T peekFromStack(Stack<T> stack) {
        return stack.empty() ? null : (T)stack.peek();
    }

    public static JetType getSuperClass(ClassDescriptor classDescriptor) {
        List<ClassDescriptor> superclassDescriptors = DescriptorUtils.getSuperclassDescriptors(classDescriptor);
        for (ClassDescriptor descriptor : superclassDescriptors) {
            if (descriptor.getKind() == ClassKind.TRAIT) continue;
            return descriptor.getDefaultType();
        }
        return KotlinBuiltIns.getInstance().getAnyType();
    }

    @Nullable
    public static FunctionDescriptor getDeclaredFunctionByRawSignature(@NotNull ClassDescriptor owner, @NotNull Name name, @NotNull ClassifierDescriptor returnedClassifier, ClassifierDescriptor ... valueParameterClassifiers) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (returnedClassifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnedClassifier", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        if (valueParameterClassifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterClassifiers", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getDeclaredFunctionByRawSignature"));
        }
        Collection<FunctionDescriptor> functions2 = owner.getDefaultType().getMemberScope().getFunctions(name);
        for (FunctionDescriptor function : functions2) {
            if (CallResolverUtil.isOrOverridesSynthesized(function) || !function.getTypeParameters().isEmpty() || !JvmCodegenUtil.valueParameterClassesMatch(function.getValueParameters(), Arrays.asList(valueParameterClassifiers)) || !JvmCodegenUtil.rawTypeMatches(function.getReturnType(), returnedClassifier)) continue;
            return function;
        }
        return null;
    }

    private static boolean valueParameterClassesMatch(@NotNull List<ValueParameterDescriptor> parameters, @NotNull List<ClassifierDescriptor> classifiers) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/jet/codegen/JvmCodegenUtil", "valueParameterClassesMatch"));
        }
        if (classifiers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifiers", "org/jetbrains/jet/codegen/JvmCodegenUtil", "valueParameterClassesMatch"));
        }
        if (parameters.size() != classifiers.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            ValueParameterDescriptor parameterDescriptor = parameters.get(i);
            ClassifierDescriptor classDescriptor = classifiers.get(i);
            if (JvmCodegenUtil.rawTypeMatches(parameterDescriptor.getType(), classDescriptor)) continue;
            return false;
        }
        return true;
    }

    private static boolean rawTypeMatches(JetType type, ClassifierDescriptor classifier2) {
        return type.getConstructor().getDeclarationDescriptor().getOriginal() == classifier2.getOriginal();
    }

    public static boolean isCallInsideSameClassAsDeclared(CallableMemberDescriptor declarationDescriptor, CodegenContext context) {
        boolean isFakeOverride = declarationDescriptor.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = declarationDescriptor.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = declarationDescriptor.getContainingDeclaration();
        containingDeclaration = containingDeclaration.getOriginal();
        return !isFakeOverride && !isDelegate && (context.hasThisDescriptor() && containingDeclaration == context.getThisDescriptor() || context.getParentContext() instanceof PackageContext && JvmCodegenUtil.isSamePackageInSameModule(context.getParentContext().getContextDescriptor(), containingDeclaration)) && context.getContextKind() != OwnerKind.TRAIT_IMPL;
    }

    private static boolean isSamePackageInSameModule(@NotNull DeclarationDescriptor owner1, @NotNull DeclarationDescriptor owner2) {
        if (owner1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner1", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (owner2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner2", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isSamePackageInSameModule"));
        }
        if (owner1 instanceof PackageFragmentDescriptor && owner2 instanceof PackageFragmentDescriptor) {
            PackageFragmentDescriptor fragment1 = (PackageFragmentDescriptor)owner1;
            PackageFragmentDescriptor fragment2 = (PackageFragmentDescriptor)owner2;
            if (!IncrementalCompilation.ENABLED) {
                return fragment1 == fragment2;
            }
            return fragment1.getFqName().equals(fragment2.getFqName()) && DescriptorUtils.areInSameModule(fragment1, fragment2);
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(CallableMemberDescriptor declarationDescriptor, CodegenContext context) {
        if (context == CodegenContext.STATIC) {
            return true;
        }
        Object contextDescriptor = context.getContextDescriptor();
        return DescriptorUtils.areInSameModule(declarationDescriptor, contextDescriptor);
    }

    public static boolean hasAbstractMembers(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "hasAbstractMembers"));
        }
        return KotlinPackage.any(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors(), new Function1<DeclarationDescriptor, Boolean>(){

            @Override
            public Boolean invoke(DeclarationDescriptor descriptor) {
                return descriptor instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor).getModality() == Modality.ABSTRACT;
            }
        });
    }

    public static boolean isNullableType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isNullableType"));
        }
        if (type.isNullable()) {
            return true;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return TypeUtils.hasNullableSuperType(type);
        }
        return false;
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor propertyDescriptor, boolean forGetter, boolean isInsideClass, boolean isDelegated, MethodContext context) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "couldUseDirectAccessToProperty"));
        }
        if (context.isInlineFunction()) {
            return false;
        }
        PropertyAccessorDescriptor accessorDescriptor = forGetter ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
        boolean isExtensionProperty = propertyDescriptor.getReceiverParameter() != null;
        boolean specialTypeProperty = isDelegated || isExtensionProperty || DescriptorUtils.isClassObject(propertyDescriptor.getContainingDeclaration()) || JetTypeMapper.isAccessor(propertyDescriptor);
        return isInsideClass && !specialTypeProperty && (accessorDescriptor == null || accessorDescriptor.isDefault() && (!JvmCodegenUtil.isExternallyAccessible(propertyDescriptor) || accessorDescriptor.getModality() == Modality.FINAL));
    }

    private static boolean isExternallyAccessible(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "isExternallyAccessible"));
        }
        return propertyDescriptor.getVisibility() != Visibilities.PRIVATE || DescriptorUtils.isClassObject(propertyDescriptor.getContainingDeclaration()) || DescriptorUtils.isTopLevelDeclaration(propertyDescriptor);
    }

    @NotNull
    public static ImplementationBodyCodegen getParentBodyCodegen(@Nullable MemberCodegen<?> classBodyCodegen) {
        assert (classBodyCodegen != null && classBodyCodegen.getParentCodegen() instanceof ImplementationBodyCodegen) : "Class object should have appropriate parent BodyCodegen";
        ImplementationBodyCodegen implementationBodyCodegen = (ImplementationBodyCodegen)classBodyCodegen.getParentCodegen();
        if (implementationBodyCodegen == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getParentBodyCodegen"));
        }
        return implementationBodyCodegen;
    }

    @Nullable
    public static ClassDescriptor getExpectedThisObjectForConstructorCall(@NotNull ConstructorDescriptor descriptor, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/JvmCodegenUtil", "getExpectedThisObjectForConstructorCall"));
        }
        if (closure != null) {
            return closure.getCaptureThis();
        }
        ReceiverParameterDescriptor expectedThisObject = descriptor.getExpectedThisObject();
        if (expectedThisObject != null && !(expectedThisClass = (ClassDescriptor)expectedThisObject.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }
}

