/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.inline.MaxCalcNode;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.JetTypeMapper;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.DeserializedSimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.PackagePartClassUtils;
import org.jetbrains.jet.lang.resolve.kotlin.VirtualFileFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class InlineCodegenUtil {
    public static final int API = 327680;
    public static final String INVOKE = "invoke";
    public static final boolean DEFAULT_INLINE_FLAG = true;
    public static final String CAPTURED_FIELD_PREFIX = "$";
    public static final String THIS$0 = "this$0";
    public static final String RECEIVER$0 = "receiver$0";

    @Nullable
    public static MethodNode getMethodNode(InputStream classData, final String methodName, final String methodDescriptor) throws ClassNotFoundException, IOException {
        ClassReader cr = new ClassReader(classData);
        final MethodNode[] methodNode = new MethodNode[1];
        cr.accept(new ClassVisitor(327680){

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (methodName.equals(name) && methodDescriptor.equals(desc)) {
                    methodNode[0] = new MethodNode(access, name, desc, signature, exceptions);
                    return methodNode[0];
                }
                return null;
            }
        }, 6);
        return methodNode[0];
    }

    @NotNull
    public static VirtualFile getVirtualFileForCallable(@NotNull DeserializedSimpleFunctionDescriptor deserializedDescriptor, @NotNull GenerationState state) {
        VirtualFile file;
        if (deserializedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getVirtualFileForCallable"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getVirtualFileForCallable"));
        }
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            ProtoBuf.Callable proto = deserializedDescriptor.getProto();
            if (!proto.hasExtension(JavaProtoBuf.implClassName)) {
                throw new IllegalStateException("Function in namespace should have implClassName property in proto: " + deserializedDescriptor);
            }
            Name name = deserializedDescriptor.getNameResolver().getName(proto.getExtension(JavaProtoBuf.implClassName));
            FqName packagePartFqName = PackageClassUtils.getPackageClassFqName(((PackageFragmentDescriptor)parentDeclaration).getFqName()).parent().child(name);
            file = InlineCodegenUtil.findVirtualFileWithHeader(state.getProject(), packagePartFqName);
        } else {
            file = InlineCodegenUtil.findVirtualFileContainingDescriptor(state.getProject(), deserializedDescriptor);
        }
        if (file == null) {
            throw new IllegalStateException("Couldn't find declaration file for " + deserializedDescriptor.getName());
        }
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getVirtualFileForCallable"));
        }
        return virtualFile;
    }

    @Nullable
    public static VirtualFile findVirtualFileWithHeader(@NotNull Project project, @NotNull FqName containerFqName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "findVirtualFileWithHeader"));
        }
        if (containerFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerFqName", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "findVirtualFileWithHeader"));
        }
        VirtualFileFinder fileFinder = ServiceManager.getService(project, VirtualFileFinder.class);
        return fileFinder.findVirtualFileWithHeader(containerFqName);
    }

    @Nullable
    public static VirtualFile findVirtualFile(@NotNull Project project, @NotNull String internalName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "findVirtualFile"));
        }
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "findVirtualFile"));
        }
        VirtualFileFinder fileFinder = ServiceManager.getService(project, VirtualFileFinder.class);
        return fileFinder.findVirtualFile(internalName);
    }

    @Nullable
    public static FqName getContainerFqName(@NotNull DeclarationDescriptor referencedDescriptor) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getContainerFqName"));
        }
        ClassOrPackageFragmentDescriptor containerDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, ClassOrPackageFragmentDescriptor.class, false);
        if (containerDescriptor instanceof PackageFragmentDescriptor) {
            return PackageClassUtils.getPackageClassFqName(DescriptorUtils.getFqName(containerDescriptor).toSafe());
        }
        if (containerDescriptor instanceof ClassDescriptor) {
            FqName fqName = DeserializedResolverUtils.kotlinFqNameToJavaFqName(DescriptorUtils.getFqName(containerDescriptor));
            if (DescriptorUtils.isTrait(containerDescriptor)) {
                return fqName.parent().child(Name.identifier(fqName.shortName() + "$$TImpl"));
            }
            return fqName;
        }
        return null;
    }

    public static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull JetTypeMapper typeMapper) {
        if (codegenContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        return InlineCodegenUtil.getInlineName(codegenContext, codegenContext.getContextDescriptor(), typeMapper);
    }

    private static String getInlineName(@NotNull CodegenContext codegenContext, @NotNull DeclarationDescriptor currentDescriptor, @NotNull JetTypeMapper typeMapper) {
        ClassDescriptor descriptor;
        if (codegenContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codegenContext", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (currentDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (typeMapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeMapper", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getInlineName"));
        }
        if (currentDescriptor instanceof PackageFragmentDescriptor) {
            Type packagePartType;
            PsiFile file = InlineCodegenUtil.getContainingFile(codegenContext, typeMapper);
            if (file == null) {
                assert (codegenContext instanceof PackageContext) : "Expected package context but " + codegenContext;
                packagePartType = ((PackageContext)codegenContext).getPackagePartType();
            } else {
                packagePartType = PackagePartClassUtils.getPackagePartType((JetFile)file);
            }
            if (packagePartType == null) {
                Object contextDescriptor = codegenContext.getContextDescriptor();
                throw new RuntimeException("Couldn't find declaration for " + contextDescriptor.getContainingDeclaration().getName() + "." + contextDescriptor.getName());
            }
            return packagePartType.getInternalName();
        }
        if (currentDescriptor instanceof ClassifierDescriptor) {
            Type type = typeMapper.mapType((ClassifierDescriptor)currentDescriptor);
            return type.getInternalName();
        }
        if (currentDescriptor instanceof FunctionDescriptor && (descriptor = typeMapper.getBindingContext().get(CodegenBinding.CLASS_FOR_FUNCTION, (FunctionDescriptor)currentDescriptor)) != null) {
            Type type = typeMapper.mapType(descriptor);
            return type.getInternalName();
        }
        String suffix = currentDescriptor.getName().isSpecial() ? "" : currentDescriptor.getName().asString();
        return InlineCodegenUtil.getInlineName(codegenContext, currentDescriptor.getContainingDeclaration(), typeMapper) + CAPTURED_FIELD_PREFIX + suffix;
    }

    @Nullable
    private static VirtualFile findVirtualFileContainingDescriptor(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "findVirtualFileContainingDescriptor"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "findVirtualFileContainingDescriptor"));
        }
        FqName containerFqName = InlineCodegenUtil.getContainerFqName(referencedDescriptor);
        if (containerFqName == null) {
            return null;
        }
        return InlineCodegenUtil.findVirtualFileWithHeader(project, containerFqName);
    }

    public static boolean isInvokeOnLambda(String owner, String name) {
        if (!INVOKE.equals(name)) {
            return false;
        }
        for (String prefix : Arrays.asList("kotlin/Function", "kotlin/ExtensionFunction")) {
            String suffix;
            if (!owner.startsWith(prefix) || !InlineCodegenUtil.isInteger(suffix = owner.substring(prefix.length()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isLambdaConstructorCall(@NotNull String internalName, @NotNull String methodName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "isLambdaConstructorCall"));
        }
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "isLambdaConstructorCall"));
        }
        return "<init>".equals(methodName) && InlineCodegenUtil.isLambdaClass(internalName);
    }

    public static boolean isLambdaClass(String internalName) {
        String shortName = InlineCodegenUtil.getLastNamePart(internalName);
        int index = shortName.lastIndexOf(CAPTURED_FIELD_PREFIX);
        if (index < 0) {
            return false;
        }
        String suffix = shortName.substring(index + 1);
        return InlineCodegenUtil.isInteger(suffix);
    }

    @NotNull
    private static String getLastNamePart(@NotNull String internalName) {
        if (internalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalName", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getLastNamePart"));
        }
        int index = internalName.lastIndexOf("/");
        String string = index < 0 ? internalName : internalName.substring(index + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "getLastNamePart"));
        }
        return string;
    }

    @Nullable
    public static PsiFile getContainingFile(CodegenContext codegenContext, JetTypeMapper typeMapper) {
        Object contextDescriptor = codegenContext.getContextDescriptor();
        PsiElement psiElement = BindingContextUtils.descriptorToDeclaration(typeMapper.getBindingContext(), contextDescriptor);
        if (psiElement != null) {
            return psiElement.getContainingFile();
        }
        return null;
    }

    @NotNull
    public static MaxCalcNode wrapWithMaxLocalCalc(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "wrapWithMaxLocalCalc"));
        }
        MaxCalcNode maxCalcNode = new MaxCalcNode(methodNode);
        if (maxCalcNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "wrapWithMaxLocalCalc"));
        }
        return maxCalcNode;
    }

    private static boolean isInteger(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "isInteger"));
        }
        if (string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCapturedFieldName(@NotNull String fieldName) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/jet/codegen/inline/InlineCodegenUtil", "isCapturedFieldName"));
        }
        return fieldName.startsWith(CAPTURED_FIELD_PREFIX) || THIS$0.equals(fieldName) || RECEIVER$0.equals(fieldName);
    }
}

