/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallResolverExtension;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.jet.lang.resolve.calls.model.DataFlowInfoForArgumentsImpl;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;

public abstract class CallResolutionContext<Context extends CallResolutionContext<Context>>
extends ResolutionContext<Context> {
    public final Call call;
    public final CheckValueArgumentsMode checkArguments;
    @NotNull
    public final MutableDataFlowInfoForArguments dataFlowInfoForArguments;

    protected CallResolutionContext(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull DataFlowInfo dataFlowInfo, @NotNull ContextDependency contextDependency, @NotNull CheckValueArgumentsMode checkArguments, @NotNull ResolutionResultsCache resolutionResultsCache, @Nullable MutableDataFlowInfoForArguments dataFlowInfoForArguments, @NotNull CallResolverExtension callResolverExtension, boolean isAnnotationContext, boolean collectAllCandidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (contextDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextDependency", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (resolutionResultsCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolutionResultsCache", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        if (callResolverExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolverExtension", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "<init>"));
        }
        super(trace, scope, expectedType, dataFlowInfo, contextDependency, resolutionResultsCache, callResolverExtension, isAnnotationContext, collectAllCandidates);
        this.call = call;
        this.checkArguments = checkArguments;
        this.dataFlowInfoForArguments = dataFlowInfoForArguments != null ? dataFlowInfoForArguments : (checkArguments == CheckValueArgumentsMode.ENABLED ? new DataFlowInfoForArgumentsImpl(call) : MutableDataFlowInfoForArguments.WITHOUT_ARGUMENTS_CHECK);
    }

    @NotNull
    public BasicCallResolutionContext toBasic() {
        BasicCallResolutionContext basicCallResolutionContext = BasicCallResolutionContext.create(this, this.call, this.checkArguments);
        if (basicCallResolutionContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/context/CallResolutionContext", "toBasic"));
        }
        return basicCallResolutionContext;
    }
}

