/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.results;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadingConflictResolver;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;

public class ResolutionResultsHandler {
    public static ResolutionResultsHandler INSTANCE = new ResolutionResultsHandler();

    private ResolutionResultsHandler() {
    }

    @NotNull
    public <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(@NotNull BindingTrace trace, @NotNull TracingStrategy tracing, @NotNull Collection<MutableResolvedCall<D>> candidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (tracing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracing", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        LinkedHashSet<MutableResolvedCall<D>> successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<MutableResolvedCall<D>> failedCandidates = Sets.newLinkedHashSet();
        LinkedHashSet<MutableResolvedCall<D>> incompleteCandidates = Sets.newLinkedHashSet();
        LinkedHashSet candidatesWithWrongReceiver = Sets.newLinkedHashSet();
        for (MutableResolvedCall<D> candidateCall : candidates) {
            ResolutionStatus status = candidateCall.getStatus();
            assert (status != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            if (status.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            if (status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                incompleteCandidates.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_TYPE_ERROR) {
                candidatesWithWrongReceiver.add(candidateCall);
                continue;
            }
            if (candidateCall.getStatus() == ResolutionStatus.RECEIVER_PRESENCE_ERROR) continue;
            failedCandidates.add(candidateCall);
        }
        if (!successfulCandidates.isEmpty() || !incompleteCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeSuccessfulResult(trace, tracing, successfulCandidates, incompleteCandidates);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!failedCandidates.isEmpty()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = this.computeFailedResult(trace, tracing, failedCandidates);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        if (!candidatesWithWrongReceiver.isEmpty()) {
            tracing.unresolvedReferenceWrongReceiver(trace, candidatesWithWrongReceiver);
            OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.candidatesWithWrongReceiver(candidatesWithWrongReceiver);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
            }
            return overloadResolutionResultsImpl;
        }
        tracing.unresolvedReference(trace);
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.nameNotFound();
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeResultAndReportErrors"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeSuccessfulResult(BindingTrace trace, TracingStrategy tracing, Set<MutableResolvedCall<D>> successfulCandidates, Set<MutableResolvedCall<D>> incompleteCandidates) {
        LinkedHashSet<MutableResolvedCall<D>> successfulAndIncomplete = Sets.newLinkedHashSet();
        successfulAndIncomplete.addAll(successfulCandidates);
        successfulAndIncomplete.addAll(incompleteCandidates);
        OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulAndIncomplete, true);
        if (results.isSingleResult()) {
            ResolvedCall resultingCall = results.getResultingCall();
            resultingCall.getTrace().moveAllMyDataTo(trace);
            if (resultingCall.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
                OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(resultingCall);
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
        }
        if (results.isAmbiguity()) {
            tracing.recordAmbiguity(trace, results.getResultingCalls());
            if (ResolutionResultsHandler.allIncomplete(results.getResultingCalls())) {
                tracing.cannotCompleteResolve(trace, results.getResultingCalls());
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.incompleteTypeInference(results.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
                }
                return overloadResolutionResultsImpl;
            }
            if (ResolutionResultsHandler.allClean(results.getResultingCalls())) {
                tracing.ambiguity(trace, results.getResultingCalls());
            }
        }
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results;
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeSuccessfulResult"));
        }
        return overloadResolutionResultsImpl;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeFailedResult(BindingTrace trace, TracingStrategy tracing, Set<MutableResolvedCall<D>> failedCandidates) {
        if (failedCandidates.size() != 1) {
            for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
                LinkedHashSet<MutableResolvedCall<D>> thisLevel = Sets.newLinkedHashSet();
                for (MutableResolvedCall<D> candidate : failedCandidates) {
                    if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                    thisLevel.add(candidate);
                }
                if (thisLevel.isEmpty()) continue;
                OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false);
                if (results.isSingleResult()) {
                    results.getResultingCall().getTrace().moveAllMyDataTo(trace);
                    OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.singleFailedCandidate(results.getResultingCall());
                    if (overloadResolutionResultsImpl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                    }
                    return overloadResolutionResultsImpl;
                }
                tracing.noneApplicable(trace, results.getResultingCalls());
                tracing.recordAmbiguity(trace, results.getResultingCalls());
                OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.manyFailedCandidates(results.getResultingCalls());
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                }
                return overloadResolutionResultsImpl;
            }
            assert (false) : "Should not be reachable, cause every status must belong to some level";
            Set noOverrides = OverrideResolver.filterOutOverridden(failedCandidates, ResolvedCallImpl.MAP_TO_CANDIDATE);
            if (noOverrides.size() != 1) {
                tracing.noneApplicable(trace, noOverrides);
                tracing.recordAmbiguity(trace, noOverrides);
                OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.manyFailedCandidates(noOverrides);
                if (overloadResolutionResultsImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
                }
                return overloadResolutionResultsImpl;
            }
            failedCandidates = noOverrides;
        }
        MutableResolvedCall<D> failed = failedCandidates.iterator().next();
        failed.getTrace().moveAllMyDataTo(trace);
        OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.singleFailedCandidate(failed);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "computeFailedResult"));
        }
        return overloadResolutionResultsImpl;
    }

    private static <D extends CallableDescriptor> boolean allClean(@NotNull Collection<MutableResolvedCall<D>> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "allClean"));
        }
        for (MutableResolvedCall<D> result2 : results) {
            if (!result2.isDirty()) continue;
            return false;
        }
        return true;
    }

    private static <D extends CallableDescriptor> boolean allIncomplete(@NotNull Collection<MutableResolvedCall<D>> results) {
        if (results == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "results", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "allIncomplete"));
        }
        for (MutableResolvedCall<D> result2 : results) {
            if (result2.getStatus() == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(@NotNull Set<MutableResolvedCall<D>> candidates, boolean discriminateGenerics) {
        MutableResolvedCall<D> maximallySpecificGenericsDiscriminated;
        MutableResolvedCall<D> maximallySpecific;
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        if (candidates.size() == 1) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(candidates.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        Set<MutableResolvedCall<D>> cleanCandidates = Sets.newLinkedHashSet(candidates);
        Iterator iterator2 = cleanCandidates.iterator();
        while (iterator2.hasNext()) {
            MutableResolvedCall candidate = (MutableResolvedCall)iterator2.next();
            if (!candidate.isDirty()) continue;
            iterator2.remove();
        }
        if (cleanCandidates.isEmpty()) {
            cleanCandidates = candidates;
        }
        if ((maximallySpecific = OverloadingConflictResolver.INSTANCE.findMaximallySpecific(cleanCandidates, false)) != null) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(maximallySpecific);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        if (discriminateGenerics && (maximallySpecificGenericsDiscriminated = OverloadingConflictResolver.INSTANCE.findMaximallySpecific(cleanCandidates, true)) != null) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(maximallySpecificGenericsDiscriminated);
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        Set noOverrides = OverrideResolver.filterOutOverridden(candidates, ResolvedCallImpl.MAP_TO_RESULT);
        if (noOverrides.size() == 1) {
            OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = OverloadResolutionResultsImpl.success(noOverrides.iterator().next());
            if (overloadResolutionResultsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
            }
            return overloadResolutionResultsImpl;
        }
        OverloadResolutionResultsImpl overloadResolutionResultsImpl = OverloadResolutionResultsImpl.ambiguity(noOverrides);
        if (overloadResolutionResultsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/results/ResolutionResultsHandler", "chooseAndReportMaximallySpecific"));
        }
        return overloadResolutionResultsImpl;
    }
}

