/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.kotlin.header.KotlinClassHeader;
import org.jetbrains.jet.lang.resolve.kotlin.header.ReadKotlinClassHeaderAnnotationVisitor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.utils.UtilsPackage;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class VirtualFileKotlinClass
implements KotlinJvmBinaryClass {
    private static final Logger LOG = Logger.getInstance(VirtualFileKotlinClass.class);
    private final VirtualFile file;
    private final JvmClassName className;
    private final KotlinClassHeader classHeader;

    private VirtualFileKotlinClass(@NotNull VirtualFile file, @NotNull JvmClassName className, @NotNull KotlinClassHeader classHeader) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "<init>"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "<init>"));
        }
        if (classHeader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classHeader", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "<init>"));
        }
        this.file = file;
        this.className = className;
        this.classHeader = classHeader;
    }

    @Nullable
    public static Pair<JvmClassName, KotlinClassHeader> readClassNameAndHeader(@NotNull byte[] fileContents) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "readClassNameAndHeader"));
        }
        final ReadKotlinClassHeaderAnnotationVisitor readHeaderVisitor = new ReadKotlinClassHeaderAnnotationVisitor();
        final Ref classNameRef = Ref.create();
        new ClassReader(fileContents).accept(new ClassVisitor(327680){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                classNameRef.set(JvmClassName.byInternalName(name));
            }

            @Override
            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                return VirtualFileKotlinClass.convertAnnotationVisitor(readHeaderVisitor, desc);
            }

            @Override
            public void visitEnd() {
                readHeaderVisitor.visitEnd();
            }
        }, 7);
        JvmClassName className = (JvmClassName)classNameRef.get();
        if (className == null) {
            return null;
        }
        KotlinClassHeader header = readHeaderVisitor.createHeader();
        if (header == null) {
            return null;
        }
        return Pair.create(className, header);
    }

    @Nullable
    static VirtualFileKotlinClass create(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "create"));
        }
        assert (file.getFileType() == JavaClassFileType.INSTANCE) : "Trying to read binary data from a non-class file " + file;
        try {
            byte[] fileContents = file.contentsToByteArray();
            Pair<JvmClassName, KotlinClassHeader> nameAndHeader = VirtualFileKotlinClass.readClassNameAndHeader(fileContents);
            if (nameAndHeader == null) {
                return null;
            }
            return new VirtualFileKotlinClass(file, (JvmClassName)nameAndHeader.first, (KotlinClassHeader)nameAndHeader.second);
        }
        catch (Throwable e) {
            LOG.warn(VirtualFileKotlinClass.renderFileReadingErrorMessage(file));
            return null;
        }
    }

    @Nullable
    public static KotlinClassHeader readClassHeader(@NotNull byte[] fileContents) {
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "readClassHeader"));
        }
        Pair<JvmClassName, KotlinClassHeader> pair = VirtualFileKotlinClass.readClassNameAndHeader(fileContents);
        return pair == null ? null : (KotlinClassHeader)pair.second;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public JvmClassName getClassName() {
        JvmClassName jvmClassName = this.className;
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "getClassName"));
        }
        return jvmClassName;
    }

    @Override
    @NotNull
    public KotlinClassHeader getClassHeader() {
        KotlinClassHeader kotlinClassHeader = this.classHeader;
        if (kotlinClassHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "getClassHeader"));
        }
        return kotlinClassHeader;
    }

    @Override
    public void loadClassAnnotations(final @NotNull KotlinJvmBinaryClass.AnnotationVisitor annotationVisitor) {
        if (annotationVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationVisitor", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "loadClassAnnotations"));
        }
        try {
            new ClassReader(this.file.contentsToByteArray()).accept(new ClassVisitor(327680){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    return VirtualFileKotlinClass.convertAnnotationVisitor(annotationVisitor, desc);
                }

                @Override
                public void visitEnd() {
                    annotationVisitor.visitEnd();
                }
            }, 7);
        }
        catch (Throwable e) {
            LOG.error(VirtualFileKotlinClass.renderFileReadingErrorMessage(this.file), e);
            throw UtilsPackage.rethrow(e);
        }
    }

    @Nullable
    private static AnnotationVisitor convertAnnotationVisitor(@NotNull KotlinJvmBinaryClass.AnnotationVisitor visitor, @NotNull String desc) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "convertAnnotationVisitor"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "convertAnnotationVisitor"));
        }
        KotlinJvmBinaryClass.AnnotationArgumentVisitor v = visitor.visitAnnotation(VirtualFileKotlinClass.classNameFromAsmDesc(desc));
        return v == null ? null : VirtualFileKotlinClass.convertAnnotationVisitor(v);
    }

    @NotNull
    private static AnnotationVisitor convertAnnotationVisitor(final @NotNull KotlinJvmBinaryClass.AnnotationArgumentVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "convertAnnotationVisitor"));
        }
        AnnotationVisitor annotationVisitor = new AnnotationVisitor(327680){

            @Override
            public void visit(String name, Object value) {
                v.visit(name == null ? null : Name.identifier(name), value);
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitArray(Name.guess(name));
                return av == null ? null : VirtualFileKotlinClass.convertAnnotationVisitor(av);
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                v.visitEnum(Name.identifier(name), VirtualFileKotlinClass.classNameFromAsmDesc(desc), Name.identifier(value));
            }

            @Override
            public void visitEnd() {
                v.visitEnd();
            }
        };
        if (annotationVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "convertAnnotationVisitor"));
        }
        return annotationVisitor;
    }

    @Override
    public void visitMembers(final @NotNull KotlinJvmBinaryClass.MemberVisitor memberVisitor) {
        if (memberVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberVisitor", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "visitMembers"));
        }
        try {
            new ClassReader(this.file.contentsToByteArray()).accept(new ClassVisitor(327680){

                @Override
                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    final KotlinJvmBinaryClass.AnnotationVisitor v = memberVisitor.visitField(Name.guess(name), desc, value);
                    if (v == null) {
                        return null;
                    }
                    return new FieldVisitor(327680){

                        @Override
                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            return VirtualFileKotlinClass.convertAnnotationVisitor(v, desc);
                        }

                        @Override
                        public void visitEnd() {
                            v.visitEnd();
                        }
                    };
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    final KotlinJvmBinaryClass.MethodAnnotationVisitor v = memberVisitor.visitMethod(Name.guess(name), desc);
                    if (v == null) {
                        return null;
                    }
                    return new MethodVisitor(327680){

                        @Override
                        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                            return VirtualFileKotlinClass.convertAnnotationVisitor(v, desc);
                        }

                        @Override
                        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                            KotlinJvmBinaryClass.AnnotationArgumentVisitor av = v.visitParameterAnnotation(parameter, VirtualFileKotlinClass.classNameFromAsmDesc(desc));
                            return av == null ? null : VirtualFileKotlinClass.convertAnnotationVisitor(av);
                        }

                        @Override
                        public void visitEnd() {
                            v.visitEnd();
                        }
                    };
                }
            }, 7);
        }
        catch (Throwable e) {
            LOG.error(VirtualFileKotlinClass.renderFileReadingErrorMessage(this.file), e);
            throw UtilsPackage.rethrow(e);
        }
    }

    @NotNull
    private static JvmClassName classNameFromAsmDesc(@NotNull String desc) {
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "classNameFromAsmDesc"));
        }
        assert (desc.startsWith("L") && desc.endsWith(";")) : "Not a JVM descriptor: " + desc;
        JvmClassName jvmClassName = JvmClassName.byInternalName(desc.substring(1, desc.length() - 1));
        if (jvmClassName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "classNameFromAsmDesc"));
        }
        return jvmClassName;
    }

    @NotNull
    private static String renderFileReadingErrorMessage(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "renderFileReadingErrorMessage"));
        }
        String string = "Could not read file: " + file.getPath() + "; " + "size in bytes: " + file.getLength() + "; " + "file type: " + file.getFileType().getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/VirtualFileKotlinClass", "renderFileReadingErrorMessage"));
        }
        return string;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof VirtualFileKotlinClass && ((VirtualFileKotlinClass)obj).file.equals(this.file);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.file.toString();
    }
}

