/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceType;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaUtil {
    public static ThreadLocal<Map<PsiElement, PsiType>> ourFunctionTypes = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance("#" + LambdaUtil.class.getName());
    @NonNls
    public static final String JAVA_LANG_FUNCTIONAL_INTERFACE = "java.lang.FunctionalInterface";

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiLambdaExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiLambdaExpression || element instanceof PsiMethodReferenceExpression) {
            PsiType samType = element instanceof PsiLambdaExpression ? ((PsiLambdaExpression)element).getFunctionalInterfaceType() : ((PsiMethodReferenceExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClassType.ClassResolveResult result2) {
        MethodSignature methodSignature;
        PsiClass psiClass = result2.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            return LambdaUtil.getMethod(psiClass, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        if (resolveResult == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/LambdaUtil", "getSubstitutor"));
        }
        PsiClass derivedClass = resolveResult.getElement();
        LOG.assertTrue(derivedClass != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            PsiType substitute = superClassSubstitutor.substitute(param);
            if (substitute == null) continue;
            initialSubst = initialSubst.put(param, initialSubst.substitute(substitute));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass aClass;
        if (type instanceof PsiIntersectionType) {
            for (PsiType type1 : ((PsiIntersectionType)type).getConjuncts()) {
                if (!LambdaUtil.isFunctionalType(type1)) continue;
                return true;
            }
        }
        if ((aClass = (resolveResult = PsiUtil.resolveGenericsClassInType(GenericsUtil.eliminateWildcards(type))).getElement()) != null) {
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            List<MethodSignature> signatures = LambdaUtil.findFunctionCandidates(aClass);
            return signatures != null && signatures.size() == 1;
        }
        return false;
    }

    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        return context instanceof PsiTypeCastExpression || context instanceof PsiAssignmentExpression || context instanceof PsiVariable || context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiExpressionList || context instanceof PsiParenthesizedExpression || context instanceof PsiArrayInitializerExpression || context instanceof PsiConditionalExpression && PsiTreeUtil.getParentOfType(context, PsiTypeCastExpression.class) == null;
    }

    public static boolean isLambdaFullyInferred(PsiLambdaExpression expression, PsiType functionalInterfaceType) {
        boolean hasParams;
        boolean bl = hasParams = expression.getParameterList().getParametersCount() > 0;
        if (hasParams || LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType) != PsiType.VOID) {
            return !LambdaUtil.dependsOnTypeParams(functionalInterfaceType, functionalInterfaceType, expression, new PsiTypeParameter[0]);
        }
        return true;
    }

    @Nullable
    static MethodSignature getFunction(PsiClass psiClass) {
        if (psiClass == null) {
            return null;
        }
        List<MethodSignature> functions2 = LambdaUtil.findFunctionCandidates(psiClass);
        if (functions2 != null && functions2.size() == 1) {
            return functions2.get(0);
        }
        return null;
    }

    private static boolean overridesPublicObjectMethod(PsiMethod psiMethod) {
        boolean overrideObject = false;
        for (PsiMethod superMethod : psiMethod.findDeepestSuperMethods()) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (containingClass == null || !"java.lang.Object".equals(containingClass.getQualifiedName()) || !superMethod.hasModifierProperty("public")) continue;
            overrideObject = true;
            break;
        }
        return overrideObject;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @Nullable
    private static List<MethodSignature> hasSubsignature(List<MethodSignature> signatures) {
        for (MethodSignature signature : signatures) {
            boolean subsignature = true;
            for (MethodSignature methodSignature : signatures) {
                if (signature.equals(methodSignature) || MethodSignatureUtil.isSubsignature(signature, methodSignature)) continue;
                subsignature = false;
                break;
            }
            if (!subsignature) continue;
            return Collections.singletonList(signature);
        }
        return signatures;
    }

    @Nullable
    public static List<MethodSignature> findFunctionCandidates(PsiClass psiClass) {
        if (psiClass instanceof PsiAnonymousClass) {
            psiClass = PsiUtil.resolveClassInType(((PsiAnonymousClass)psiClass).getBaseClassType());
        }
        if (psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType()) {
            ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
            Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
            for (HierarchicalMethodSignature signature : visibleSignatures) {
                PsiMethod psiMethod = signature.getMethod();
                if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static") || LambdaUtil.overridesPublicObjectMethod(psiMethod)) continue;
                methods.add(signature);
            }
            return LambdaUtil.hasSubsignature(methods);
        }
        return null;
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression, element, false)) continue;
            return i;
        }
        return -1;
    }

    public static boolean dependsOnTypeParams(PsiType type, PsiType functionalInterfaceType, PsiElement lambdaExpression, PsiTypeParameter ... param2Check) {
        return LambdaUtil.depends(type, new TypeParamsChecker(lambdaExpression, PsiUtil.resolveClassInType(functionalInterfaceType)), param2Check);
    }

    public static boolean depends(PsiType type, TypeParamsChecker visitor, PsiTypeParameter ... param2Check) {
        if (!visitor.startedInference()) {
            return false;
        }
        Boolean accept = type.accept(visitor);
        if (param2Check.length > 0) {
            return visitor.used(param2Check);
        }
        return accept != null && accept != false;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute) {
        PsiElement parent = expression.getParent();
        PsiElement element = expression;
        while (!(!(parent instanceof PsiParenthesizedExpression) && !(parent instanceof PsiConditionalExpression) || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getThenExpression() != element && ((PsiConditionalExpression)parent).getElseExpression() != element)) {
            element = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            if (parent instanceof PsiTypeCastExpression) {
                PsiType castType = ((PsiTypeCastExpression)parent).getType();
                if (castType instanceof PsiIntersectionType) {
                    for (PsiType conjunctType : ((PsiIntersectionType)castType).getConjuncts()) {
                        if (LambdaUtil.getFunctionalInterfaceMethod(conjunctType) == null) continue;
                        return conjunctType;
                    }
                }
                return castType;
            }
            if (parent instanceof PsiVariable) {
                return ((PsiVariable)parent).getType();
            }
            if (parent instanceof PsiAssignmentExpression && expression instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
                return lExpression.getType();
            }
            if (parent instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression);
                if (lambdaIdx > -1) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiParameter[] parameters;
                        int finalLambdaIdx;
                        JavaResolveResult resolveResult;
                        PsiElement resolve2;
                        PsiCall contextCall = (PsiCall)gParent;
                        MethodCandidateInfo.CurrentCandidateProperties properties = MethodCandidateInfo.getCurrentMethod(contextCall.getArgumentList());
                        if (properties != null && properties.isApplicabilityCheck()) {
                            PsiParameter[] parameters2 = properties.getMethod().getParameterList().getParameters();
                            int finalLambdaIdx2 = LambdaUtil.adjustLambdaIdx(lambdaIdx, properties.getMethod(), parameters2);
                            if (finalLambdaIdx2 < parameters2.length) {
                                return properties.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx2]));
                            }
                        }
                        if ((resolve2 = (resolveResult = contextCall.resolveMethodGenerics()).getElement()) instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve2, parameters = ((PsiMethod)resolve2).getParameterList().getParameters())) < parameters.length) {
                            PsiType type;
                            if (!tryToSubstitute) {
                                return LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]);
                            }
                            Map<PsiElement, PsiType> map = ourFunctionTypes.get();
                            if (map != null && (type = map.get(expression)) != null) {
                                return type;
                            }
                            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, true, new Computable<PsiType>(){

                                @Override
                                public PsiType compute() {
                                    return resolveResult.getSubstitutor().substitute(LambdaUtil.getNormalizedType(parameters[finalLambdaIdx]));
                                }
                            });
                        }
                        return null;
                    }
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiLambdaExpression gParent = PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class);
                if (gParent != null) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda(gParent);
                }
                PsiMethod method = PsiTreeUtil.getParentOfType(parent, PsiMethod.class);
                if (method != null) {
                    return method.getReturnType();
                }
            } else if (parent instanceof PsiLambdaExpression) {
                return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent);
            }
        }
        return null;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        if (parentLambda == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/LambdaUtil", "getFunctionalInterfaceTypeByContainingLambda"));
        }
        PsiType parentInterfaceType = parentLambda.getFunctionalInterfaceType();
        return parentInterfaceType != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve2, PsiParameter[] parameters) {
        int finalLambdaIdx = resolve2.isVarArgs() && lambdaIdx >= parameters.length ? parameters.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type = parameter.getType();
        if (type instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type).getComponentType();
        }
        return type;
    }

    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static List<PsiReturnStatement> getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        final ArrayList<PsiReturnStatement> result2 = new ArrayList<PsiReturnStatement>();
        if (body != null) {
            body.accept(new JavaRecursiveElementVisitor(){

                @Override
                public void visitReturnStatement(PsiReturnStatement statement) {
                    result2.add(statement);
                }

                @Override
                public void visitClass(PsiClass aClass) {
                }

                @Override
                public void visitLambdaExpression(PsiLambdaExpression expression) {
                }
            });
        }
        return result2;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result2 = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result2.add(returnValue);
        }
        return result2;
    }

    @Nullable
    public static String checkFunctionalInterface(@NotNull PsiAnnotation annotation, @NotNull LanguageLevel languageLevel) {
        PsiElement parent;
        PsiAnnotationOwner owner;
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/LambdaUtil", "checkFunctionalInterface"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/LambdaUtil", "checkFunctionalInterface"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8) && Comparing.strEqual(annotation.getQualifiedName(), JAVA_LANG_FUNCTIONAL_INTERFACE) && (owner = annotation.getOwner()) instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiClass) {
            return LambdaHighlightingUtil.checkInterfaceFunctional((PsiClass)parent, ((PsiClass)parent).getName() + " is not a functional interface");
        }
        return null;
    }

    public static boolean isValidQualifier4InterfaceStaticMethodCall(@NotNull PsiMethod method, @NotNull PsiReferenceExpression methodReferenceExpression, @Nullable PsiElement scope, @NotNull LanguageLevel languageLevel) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (methodReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/LambdaUtil", "isValidQualifier4InterfaceStaticMethodCall"));
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
                return qualifierExpression == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor(containingClass, methodReferenceExpression, true)) || qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() == containingClass;
            }
        }
        return true;
    }

    public static class TypeParamsChecker
    extends PsiTypeVisitor<Boolean> {
        private PsiMethod myMethod;
        private final PsiClass myClass;
        public final Set<PsiTypeParameter> myUsedTypeParams = new HashSet<PsiTypeParameter>();

        public TypeParamsChecker(PsiElement expression, PsiClass aClass) {
            PsiElement gParent;
            PsiElement parent;
            this.myClass = aClass;
            PsiElement psiElement = parent = expression != null ? expression.getParent() : null;
            while (parent instanceof PsiParenthesizedExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiCall) {
                MethodCandidateInfo.CurrentCandidateProperties pair = MethodCandidateInfo.getCurrentMethod(parent);
                PsiMethod psiMethod = this.myMethod = pair != null ? pair.getMethod() : null;
                if (this.myMethod == null) {
                    this.myMethod = ((PsiCall)gParent).resolveMethod();
                }
                if (this.myMethod != null && PsiTreeUtil.isAncestor(this.myMethod, expression, false)) {
                    this.myMethod = null;
                }
            }
        }

        public boolean startedInference() {
            return this.myMethod != null;
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiTypeParameter typeParameter;
            boolean used = false;
            for (PsiType paramType : classType.getParameters()) {
                Boolean paramAccepted = paramType.accept(this);
                used |= paramAccepted != null && paramAccepted != false;
            }
            PsiClass resolve2 = classType.resolve();
            if (resolve2 instanceof PsiTypeParameter && this.check(typeParameter = (PsiTypeParameter)resolve2)) {
                this.myUsedTypeParams.add(typeParameter);
                return true;
            }
            return used;
        }

        @Override
        @Nullable
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                return bound.accept(this);
            }
            return false;
        }

        @Override
        @Nullable
        public Boolean visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
            return this.visitWildcardType(capturedWildcardType.getWildcard());
        }

        @Override
        @Nullable
        public Boolean visitLambdaExpressionType(PsiLambdaExpressionType lambdaExpressionType) {
            return true;
        }

        @Override
        @Nullable
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }

        private boolean check(PsiTypeParameter check) {
            PsiTypeParameterListOwner owner = check.getOwner();
            if (owner == this.myMethod) {
                return true;
            }
            return owner == this.myClass;
        }

        public boolean used(PsiTypeParameter ... parameters) {
            for (PsiTypeParameter parameter : parameters) {
                if (!this.myUsedTypeParams.contains(parameter)) continue;
                return true;
            }
            return false;
        }
    }
}

