/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;

public class DefaultStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.DefaultStubBuilder");

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTree"));
        }
        return this.buildStubTreeFor(file, this.createStubForFile(file));
    }

    protected StubElement createStubForFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/DefaultStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> stub = new PsiFileStubImpl<PsiFile>(file);
        return stub;
    }

    private StubElement buildStubTreeFor(@NotNull PsiElement root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<PsiElement> parentElements = new Stack<PsiElement>();
        parentElements.push(root);
        parentStubs.push(parentStub);
        while (!parentElements.isEmpty()) {
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            PsiElement elt = (PsiElement)parentElements.pop();
            if (elt instanceof StubBasedPsiElement) {
                IStubElementType type = ((StubBasedPsiElement)elt).getElementType();
                if (type.shouldCreateStub(elt.getNode())) {
                    Object s = type.createStub(elt, stub);
                    stub = s;
                }
            } else {
                IElementType type;
                ASTNode node = elt.getNode();
                IElementType iElementType = type = node == null ? null : node.getElementType();
                if (type instanceof IStubElementType && ((IStubElementType)type).shouldCreateStub(node)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + elt);
                }
            }
            for (PsiElement child = elt.getLastChild(); child != null; child = child.getPrevSibling()) {
                if (this.skipChildProcessingWhenBuildingStubs(elt, child)) continue;
                parentStubs.push(stub);
                parentElements.push(child);
            }
        }
        return parentStub;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull PsiElement parent, @NotNull PsiElement element) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected StubElement buildStubTreeFor(@NotNull ASTNode root, @NotNull StubElement parentStub) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        if (parentStub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/DefaultStubBuilder", "buildStubTreeFor"));
        }
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        Stack<ASTNode> parentNodes = new Stack<ASTNode>();
        parentNodes.push(root);
        parentStubs.push(parentStub);
        while (!parentStubs.isEmpty()) {
            IStubElementType type;
            StubElement<Object> stub = (StubElement)parentStubs.pop();
            ASTNode node = (ASTNode)parentNodes.pop();
            IElementType nodeType = node.getElementType();
            if (nodeType instanceof IStubElementType && (type = (IStubElementType)nodeType).shouldCreateStub(node)) {
                Object s;
                PsiElement element = node.getPsi();
                if (!(element instanceof StubBasedPsiElement)) {
                    LOG.error("Non-StubBasedPsiElement requests stub creation. Stub type: " + type + ", PSI: " + element);
                }
                LOG.assertTrue((stub = (s = type.createStub(element, stub))) != null, element);
            }
            for (ASTNode childNode = node.getLastChildNode(); childNode != null; childNode = childNode.getTreePrev()) {
                if (this.skipChildProcessingWhenBuildingStubs(node, childNode)) continue;
                parentNodes.push(childNode);
                parentStubs.push(stub);
            }
        }
        return parentStub;
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/DefaultStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

