/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import org.jdom.Element;
import org.jdom.Text;

class TagBinding
implements Binding {
    private final Accessor accessor;
    private final Tag myTagAnnotation;
    private final String myTagName;
    private final Binding binding;

    public TagBinding(Accessor accessor, Tag tagAnnotation) {
        this.accessor = accessor;
        this.myTagAnnotation = tagAnnotation;
        this.myTagName = tagAnnotation.value();
        this.binding = XmlSerializerImpl.getBinding(accessor);
    }

    @Override
    public Object deserialize(Object o, Object ... nodes) {
        Object[] children;
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        assert (nodes.length > 0);
        if (nodes.length == 1) {
            children = JDOMUtil.getContent((Element)nodes[0]);
        } else {
            String name = ((Element)nodes[0]).getName();
            ArrayList childrenList = new ArrayList();
            for (Object node : nodes) {
                assert (((Element)node).getName().equals(name));
                ContainerUtil.addAll(childrenList, JDOMUtil.getContent((Element)node));
            }
            children = ArrayUtil.toObjectArray(childrenList);
        }
        if (children.length == 0) {
            children = new Object[]{new Text(this.myTagAnnotation.textIfEmpty())};
        }
        Object v = this.binding.deserialize(this.accessor.read(o), children);
        Object value = XmlSerializerImpl.convert(v, this.accessor.getValueClass());
        this.accessor.write(o, value);
        return o;
    }

    @Override
    public boolean isBoundTo(Object node) {
        return node instanceof Element && ((Element)node).getName().equals(this.myTagName);
    }

    @Override
    public Class getBoundNodeType() {
        throw new UnsupportedOperationException("Method getBoundNodeType is not supported in " + this.getClass());
    }

    @Override
    public void init() {
    }
}

