/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.modules;

import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.SmartList;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageCollectorUtil;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.modules.DelegatedSaxHandler;
import org.jetbrains.jet.cli.common.modules.ModuleDescription;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleXmlParser {
    public static final String MODULES = "modules";
    public static final String MODULE = "module";
    public static final String NAME = "name";
    public static final String OUTPUT_DIR = "outputDir";
    public static final String SOURCES = "sources";
    public static final String PATH = "path";
    public static final String CLASSPATH = "classpath";
    public static final String EXTERNAL_ANNOTATIONS = "externalAnnotations";
    private final MessageCollector messageCollector;
    private final List<ModuleDescription> result;
    private DefaultHandler currentState;
    private final DefaultHandler initial;
    private final DefaultHandler insideModules;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ModuleDescription> parse(@NotNull String xmlFile, @NotNull MessageCollector messageCollector) {
        List<ModuleDescription> list;
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "parse"));
        }
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "parse"));
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(xmlFile);
            list = new ModuleXmlParser(messageCollector).parse(new BufferedInputStream(stream));
        }
        catch (FileNotFoundException e) {
            List<ModuleDescription> list2;
            try {
                MessageCollectorUtil.reportException(messageCollector, e);
                list2 = Collections.emptyList();
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(stream);
                throw throwable;
            }
            StreamUtil.closeStream(stream);
            List<ModuleDescription> list3 = list2;
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "parse"));
            }
            return list3;
        }
        StreamUtil.closeStream(stream);
        List<ModuleDescription> list4 = list;
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "parse"));
        }
        return list4;
    }

    private ModuleXmlParser(@NotNull MessageCollector messageCollector) {
        if (messageCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageCollector", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "<init>"));
        }
        this.result = new SmartList<ModuleDescription>();
        this.initial = new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                    throw ModuleXmlParser.createError(qName);
                }
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        };
        this.insideModules = new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (!ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                    throw ModuleXmlParser.createError(qName);
                }
                ModuleXmlParser.this.setCurrentState(new InsideModule(ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.NAME, qName), ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.OUTPUT_DIR, qName)));
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName) || ModuleXmlParser.MODULES.equalsIgnoreCase(qName)) {
                    ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
                }
            }
        };
        this.messageCollector = messageCollector;
    }

    private void setCurrentState(@NotNull DefaultHandler currentState) {
        if (currentState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentState", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "setCurrentState"));
        }
        this.currentState = currentState;
    }

    private List<ModuleDescription> parse(@NotNull InputStream xml) {
        if (xml == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xml", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "parse"));
        }
        try {
            this.setCurrentState(this.initial);
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.parse(xml, (DefaultHandler)new DelegatedSaxHandler(){

                @Override
                @NotNull
                protected DefaultHandler getDelegate() {
                    DefaultHandler defaultHandler = ModuleXmlParser.this.currentState;
                    if (defaultHandler == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser$1", "getDelegate"));
                    }
                    return defaultHandler;
                }
            });
            return this.result;
        }
        catch (ParserConfigurationException e) {
            MessageCollectorUtil.reportException(this.messageCollector, e);
        }
        catch (SAXException e) {
            this.messageCollector.report(CompilerMessageSeverity.ERROR, MessageRenderer.PLAIN.renderException(e), CompilerMessageLocation.NO_LOCATION);
        }
        catch (IOException e) {
            MessageCollectorUtil.reportException(this.messageCollector, e);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static String getAttribute(Attributes attributes, String qName, String tag) throws SAXException {
        String name = attributes.getValue(qName);
        if (name == null) {
            throw new SAXException("No '" + qName + "' attribute for " + tag);
        }
        String string = name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/cli/common/modules/ModuleXmlParser", "getAttribute"));
        }
        return string;
    }

    private static SAXException createError(String qName) throws SAXException {
        return new SAXException("Unexpected tag: " + qName);
    }

    private class InsideModule
    extends DefaultHandler {
        private final ModuleDescription.Impl moduleDescription = new ModuleDescription.Impl();

        private InsideModule(String name, String outputDir) {
            this.moduleDescription.setName(name);
            this.moduleDescription.setOutputDir(outputDir);
            ModuleXmlParser.this.result.add(this.moduleDescription);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (ModuleXmlParser.SOURCES.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleDescription.addSourcePath(path);
            } else if (ModuleXmlParser.CLASSPATH.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleDescription.addClassPath(path);
            } else if (ModuleXmlParser.EXTERNAL_ANNOTATIONS.equalsIgnoreCase(qName)) {
                String path = ModuleXmlParser.getAttribute(attributes, ModuleXmlParser.PATH, qName);
                this.moduleDescription.addAnnotationPath(path);
            } else {
                throw ModuleXmlParser.createError(qName);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (ModuleXmlParser.MODULE.equalsIgnoreCase(qName)) {
                ModuleXmlParser.this.setCurrentState(ModuleXmlParser.this.insideModules);
            }
        }
    }
}

