/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.parsing.JetParser;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFileStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetFileStubBuilder;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetFileStubImpl;
import org.jetbrains.jet.plugin.JetLanguage;

public class JetFileElementType
extends IStubFileElementType<PsiJetFileStub> {
    public static final int STUB_VERSION = 26;

    public JetFileElementType() {
        super("jet.FILE", JetLanguage.INSTANCE);
    }

    protected JetFileElementType(@NonNls String debugName) {
        super(debugName, JetLanguage.INSTANCE);
    }

    @Override
    public StubBuilder getBuilder() {
        return new JetFileStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 26;
    }

    @Override
    @NotNull
    public String getExternalId() {
        if ("jet.FILE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "getExternalId"));
        }
        return "jet.FILE";
    }

    @Override
    public void serialize(@NotNull PsiJetFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "serialize"));
        }
        dataStream.writeName(stub.getPackageName());
        dataStream.writeBoolean(stub.isScript());
    }

    @Override
    @NotNull
    public PsiJetFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "deserialize"));
        }
        StringRef packName = dataStream.readName();
        boolean isScript = dataStream.readBoolean();
        PsiJetFileStubImpl psiJetFileStubImpl = new PsiJetFileStubImpl(null, packName, isScript);
        if (psiJetFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "deserialize"));
        }
        return psiJetFileStubImpl;
    }

    @Override
    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "doParseContents"));
        }
        Project project = psi.getProject();
        Language languageForParser = this.getLanguageForParser(psi);
        PsiBuilder builder = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, languageForParser, chameleon.getChars());
        JetParser parser = (JetParser)((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(languageForParser)).createParser(project);
        return parser.parse(this, builder, psi.getContainingFile()).getFirstChildNode();
    }

    @Override
    public void indexStub(@NotNull PsiJetFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetFileElementType", "indexStub"));
        }
        StubIndexServiceFactory.getInstance().indexFile(stub, sink);
    }
}

