/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.elements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.stubs.PsiJetPropertyStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementType;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lang.psi.stubs.elements.StubIndexServiceFactory;
import org.jetbrains.jet.lang.psi.stubs.impl.PsiJetPropertyStubImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JetPropertyElementType
extends JetStubElementType<PsiJetPropertyStub, JetProperty> {
    public JetPropertyElementType(@NotNull @NonNls String debugName) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "<init>"));
        }
        super(debugName);
    }

    @Override
    public JetProperty createPsiFromAst(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "createPsiFromAst"));
        }
        return new JetProperty(node);
    }

    @Override
    public JetProperty createPsi(@NotNull PsiJetPropertyStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "createPsi"));
        }
        return new JetProperty(stub, (IStubElementType)JetStubElementTypes.PROPERTY);
    }

    @Override
    public boolean shouldCreateStub(ASTNode node) {
        PsiElement psi;
        if (super.shouldCreateStub(node) && (psi = node.getPsi()) instanceof JetProperty) {
            JetProperty property2 = (JetProperty)psi;
            return property2.getName() != null;
        }
        return false;
    }

    @Override
    public PsiJetPropertyStub createStub(@NotNull JetProperty psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "createStub"));
        }
        JetTypeReference typeRef = psi.getTypeRef();
        JetExpression expression = psi.getInitializer();
        assert (!psi.isLocal()) : String.format("Should not store local property: %s, parent %s", psi.getText(), psi.getParent() != null ? psi.getParent().getText() : "<no parent>");
        return new PsiJetPropertyStubImpl((IStubElementType)JetStubElementTypes.PROPERTY, parentStub, psi.getName(), psi.isVar(), psi.isTopLevel(), JetPsiUtil.getFQName(psi), typeRef != null ? typeRef.getText() : null, expression != null ? expression.getText() : null);
    }

    @Override
    public void serialize(@NotNull PsiJetPropertyStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "serialize"));
        }
        dataStream.writeName(stub.getName());
        dataStream.writeBoolean(stub.isVar());
        dataStream.writeBoolean(stub.isTopLevel());
        FqName topFQName = stub.getTopFQName();
        dataStream.writeName(topFQName != null ? topFQName.toString() : null);
        dataStream.writeName(stub.getTypeText());
        dataStream.writeName(stub.getInferenceBodyText());
    }

    @Override
    @NotNull
    public PsiJetPropertyStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "deserialize"));
        }
        StringRef name = dataStream.readName();
        boolean isVar = dataStream.readBoolean();
        boolean isTopLevel = dataStream.readBoolean();
        StringRef topFQNameStr = dataStream.readName();
        FqName fqName = topFQNameStr != null ? new FqName(topFQNameStr.toString()) : null;
        StringRef typeText = dataStream.readName();
        StringRef inferenceBodyText = dataStream.readName();
        PsiJetPropertyStubImpl psiJetPropertyStubImpl = new PsiJetPropertyStubImpl((IStubElementType)JetStubElementTypes.PROPERTY, parentStub, name, isVar, isTopLevel, fqName, typeText, inferenceBodyText);
        if (psiJetPropertyStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "deserialize"));
        }
        return psiJetPropertyStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiJetPropertyStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/jet/lang/psi/stubs/elements/JetPropertyElementType", "indexStub"));
        }
        StubIndexServiceFactory.getInstance().indexProperty(stub, sink);
    }
}

