/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Function1;
import kotlin.KotlinPackage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.context.GlobalContextImpl;
import org.jetbrains.jet.di.InjectorForLazyResolve;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerBasic;
import org.jetbrains.jet.lang.PlatformToKotlinClassMap;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DependencyKind;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.impl.MutablePackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilder;
import org.jetbrains.jet.lang.descriptors.impl.PackageLikeBuilderDummy;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPackageDirective;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BodyResolver;
import org.jetbrains.jet.lang.resolve.DeclarationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.JetModuleUtil;
import org.jetbrains.jet.lang.resolve.MutablePackageFragmentProvider;
import org.jetbrains.jet.lang.resolve.OverloadResolver;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.ScriptHeaderResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TypeHierarchyResolver;
import org.jetbrains.jet.lang.resolve.lazy.ForceResolveUtil;
import org.jetbrains.jet.lang.resolve.lazy.LazyImportScope;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.storage.LockBasedStorageManager;

public class TopDownAnalyzer {
    public static boolean LAZY = "true".equals(System.getProperty("lazy.tda"));
    @NotNull
    private BindingTrace trace;
    @NotNull
    private DeclarationResolver declarationResolver;
    @NotNull
    private TypeHierarchyResolver typeHierarchyResolver;
    @NotNull
    private OverrideResolver overrideResolver;
    @NotNull
    private OverloadResolver overloadResolver;
    @NotNull
    private ModuleDescriptor moduleDescriptor;
    @NotNull
    private MutablePackageFragmentProvider packageFragmentProvider;
    @NotNull
    private BodyResolver bodyResolver;
    @NotNull
    private ScriptHeaderResolver scriptHeaderResolver;

    public void setTrace(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setTrace"));
        }
        this.trace = trace;
    }

    public void setDeclarationResolver(@NotNull DeclarationResolver declarationResolver) {
        if (declarationResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setDeclarationResolver"));
        }
        this.declarationResolver = declarationResolver;
    }

    public void setTypeHierarchyResolver(@NotNull TypeHierarchyResolver typeHierarchyResolver) {
        if (typeHierarchyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeHierarchyResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setTypeHierarchyResolver"));
        }
        this.typeHierarchyResolver = typeHierarchyResolver;
    }

    public void setOverrideResolver(@NotNull OverrideResolver overrideResolver) {
        if (overrideResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overrideResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setOverrideResolver"));
        }
        this.overrideResolver = overrideResolver;
    }

    public void setOverloadResolver(@NotNull OverloadResolver overloadResolver) {
        if (overloadResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "overloadResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setOverloadResolver"));
        }
        this.overloadResolver = overloadResolver;
    }

    public void setModuleDescriptor(@NotNull ModuleDescriptor moduleDescriptor) {
        if (moduleDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setModuleDescriptor"));
        }
        this.moduleDescriptor = moduleDescriptor;
    }

    public void setPackageFragmentProvider(@NotNull MutablePackageFragmentProvider packageFragmentProvider) {
        if (packageFragmentProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFragmentProvider", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setPackageFragmentProvider"));
        }
        this.packageFragmentProvider = packageFragmentProvider;
    }

    public void setBodyResolver(@NotNull BodyResolver bodyResolver) {
        if (bodyResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bodyResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setBodyResolver"));
        }
        this.bodyResolver = bodyResolver;
    }

    public void setScriptHeaderResolver(@NotNull ScriptHeaderResolver scriptHeaderResolver) {
        if (scriptHeaderResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptHeaderResolver", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "setScriptHeaderResolver"));
        }
        this.scriptHeaderResolver = scriptHeaderResolver;
    }

    public void doProcess(final @NotNull TopDownAnalysisContext c, @NotNull JetScope outerScope, @NotNull PackageLikeBuilder owner, @NotNull Collection<? extends PsiElement> declarations) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        if (declarations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "doProcess"));
        }
        c.debug("Enter");
        if (LAZY && !c.getTopDownAnalysisParameters().isDeclaredLocally()) {
            final ResolveSession resolveSession = new InjectorForLazyResolve(declarations.iterator().next().getProject(), new GlobalContextImpl((LockBasedStorageManager)c.getStorageManager(), c.getExceptionTracker()), (ModuleDescriptorImpl)this.moduleDescriptor, new FileBasedDeclarationProviderFactory(c.getStorageManager(), TopDownAnalyzer.getFiles(declarations)), this.trace).getResolveSession();
            final HashMultimap<FqName, JetElement> topLevelFqNames = HashMultimap.create();
            for (PsiElement psiElement : declarations) {
                psiElement.accept(new JetVisitorVoid(){

                    private void registerDeclarations(@NotNull List<JetDeclaration> declarations) {
                        if (declarations == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarations", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "registerDeclarations"));
                        }
                        for (JetDeclaration jetDeclaration : declarations) {
                            jetDeclaration.accept(this);
                        }
                    }

                    private void registerTopLevelFqName(@NotNull JetNamedDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
                        FqName fqName;
                        if (declaration == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "registerTopLevelFqName"));
                        }
                        if (descriptor == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "registerTopLevelFqName"));
                        }
                        if (DescriptorUtils.isTopLevelDeclaration(descriptor) && (fqName = JetPsiUtil.getFQName(declaration)) != null) {
                            topLevelFqNames.put(fqName, declaration);
                        }
                    }

                    private void registerScope(@Nullable JetDeclaration declaration, @NotNull JetDeclaration anchorForScope) {
                        if (anchorForScope == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorForScope", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "registerScope"));
                        }
                        if (declaration == null) {
                            return;
                        }
                        c.registerDeclaringScope(declaration, resolveSession.getScopeProvider().getResolutionScopeForDeclaration(anchorForScope));
                    }

                    @Override
                    public void visitDeclaration(@NotNull JetDeclaration dcl) {
                        if (dcl == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitDeclaration"));
                        }
                        throw new IllegalArgumentException("Unsupported declaration: " + dcl + " " + dcl.getText());
                    }

                    @Override
                    public void visitJetFile(@NotNull JetFile file) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitJetFile"));
                        }
                        if (file.isScript()) {
                            JetScript script = file.getScript();
                            assert (script != null);
                            TopDownAnalyzer.this.scriptHeaderResolver.processScriptHierarchy(c, script, resolveSession.getScopeProvider().getFileScope(file));
                        } else {
                            JetPackageDirective packageDirective = file.getPackageDirective();
                            assert (packageDirective != null) : "No package in a non-script file: " + file;
                            c.addFile(file);
                            DescriptorResolver.resolvePackageHeader(packageDirective, TopDownAnalyzer.this.moduleDescriptor, TopDownAnalyzer.this.trace);
                            this.registerDeclarations(file.getDeclarations());
                            topLevelFqNames.put(JetPsiUtil.getFQName(file), packageDirective);
                        }
                        this.resolveAndCheckImports(file, resolveSession);
                    }

                    private void resolveAndCheckImports(@NotNull JetFile file, @NotNull ResolveSession resolveSession2) {
                        if (file == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "resolveAndCheckImports"));
                        }
                        if (resolveSession2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveSession", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "resolveAndCheckImports"));
                        }
                        LazyImportScope fileScope = resolveSession2.getScopeProvider().getExplicitImportsScopeForFile(file);
                        fileScope.forceResolveAllContents();
                    }

                    private void visitClassOrObject(@NotNull JetClassOrObject classOrObject) {
                        if (classOrObject == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitClassOrObject"));
                        }
                        ClassDescriptorWithResolutionScopes descriptor = ForceResolveUtil.forceResolveAllContents((ClassDescriptorWithResolutionScopes)resolveSession.getClassDescriptor(classOrObject));
                        c.getClasses().put(classOrObject, descriptor);
                        this.registerDeclarations(classOrObject.getDeclarations());
                        this.registerTopLevelFqName(classOrObject, descriptor);
                        this.checkManyClassObjects(classOrObject);
                    }

                    private void checkManyClassObjects(JetClassOrObject classOrObject) {
                        boolean classObjectAlreadyFound = false;
                        for (JetDeclaration jetDeclaration : classOrObject.getDeclarations()) {
                            jetDeclaration.accept(this);
                            if (!(jetDeclaration instanceof JetClassObject)) continue;
                            if (classObjectAlreadyFound) {
                                TopDownAnalyzer.this.trace.report(Errors.MANY_CLASS_OBJECTS.on((JetClassObject)jetDeclaration));
                            }
                            classObjectAlreadyFound = true;
                        }
                    }

                    @Override
                    public void visitClass(@NotNull JetClass klass) {
                        if (klass == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitClass"));
                        }
                        this.visitClassOrObject(klass);
                        this.registerPrimaryConstructorParameters(klass);
                    }

                    private void registerPrimaryConstructorParameters(@NotNull JetClass klass) {
                        if (klass == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "registerPrimaryConstructorParameters"));
                        }
                        for (JetParameter jetParameter : klass.getPrimaryConstructorParameters()) {
                            if (jetParameter.getValOrVarNode() == null) continue;
                            c.getPrimaryConstructorParameterProperties().put(jetParameter, (PropertyDescriptor)resolveSession.resolveToDescriptor(jetParameter));
                        }
                    }

                    @Override
                    public void visitClassObject(@NotNull JetClassObject classObject) {
                        if (classObject == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitClassObject"));
                        }
                        this.visitClassOrObject(classObject.getObjectDeclaration());
                    }

                    @Override
                    public void visitEnumEntry(@NotNull JetEnumEntry enumEntry) {
                        if (enumEntry == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntry", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitEnumEntry"));
                        }
                        this.visitClassOrObject(enumEntry);
                    }

                    @Override
                    public void visitObjectDeclaration(@NotNull JetObjectDeclaration declaration) {
                        if (declaration == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitObjectDeclaration"));
                        }
                        this.visitClassOrObject(declaration);
                    }

                    @Override
                    public void visitAnonymousInitializer(@NotNull JetClassInitializer initializer) {
                        if (initializer == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitAnonymousInitializer"));
                        }
                        this.registerScope(initializer, initializer);
                    }

                    @Override
                    public void visitNamedFunction(@NotNull JetNamedFunction function) {
                        if (function == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitNamedFunction"));
                        }
                        c.getFunctions().put(function, ForceResolveUtil.forceResolveAllContents((SimpleFunctionDescriptor)resolveSession.resolveToDescriptor(function)));
                        this.registerScope(function, function);
                    }

                    @Override
                    public void visitProperty(@NotNull JetProperty property2) {
                        if (property2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$1", "visitProperty"));
                        }
                        PropertyDescriptor descriptor = ForceResolveUtil.forceResolveAllContents((PropertyDescriptor)resolveSession.resolveToDescriptor(property2));
                        c.getProperties().put(property2, descriptor);
                        this.registerTopLevelFqName(property2, descriptor);
                        this.registerScope(property2, property2);
                        this.registerScope(property2.getGetter(), property2);
                        this.registerScope(property2.getSetter(), property2);
                    }
                });
            }
            this.declarationResolver.checkRedeclarationsInPackages(resolveSession, topLevelFqNames);
            this.declarationResolver.checkRedeclarationsInInnerClassNames(c);
            this.overrideResolver.check(c);
        } else {
            this.typeHierarchyResolver.process(c, outerScope, owner, declarations);
            this.declarationResolver.process(c);
            this.overrideResolver.process(c);
            this.lockScopes(c);
        }
        this.overloadResolver.process(c);
        if (!c.getTopDownAnalysisParameters().isAnalyzingBootstrapLibrary()) {
            this.bodyResolver.resolveBodies(c);
        }
        c.debug("Exit");
        c.printDebugOutput(System.out);
    }

    private static Collection<JetFile> getFiles(Collection<? extends PsiElement> declarations) {
        return new LinkedHashSet<JetFile>(KotlinPackage.map(declarations, new Function1<PsiElement, JetFile>(){

            @Override
            @Nullable
            public JetFile invoke(PsiElement element) {
                return (JetFile)element.getContainingFile();
            }
        }));
    }

    private void lockScopes(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "lockScopes"));
        }
        for (ClassDescriptorWithResolutionScopes mutableClassDescriptor : c.getClasses().values()) {
            ((MutableClassDescriptor)mutableClassDescriptor).lockScopes();
        }
        HashSet<FqName> scriptFqNames = Sets.newHashSet();
        for (JetFile file : c.getFileScopes().keySet()) {
            if (!file.isScript()) continue;
            scriptFqNames.add(JetPsiUtil.getFQName(file));
        }
        for (MutablePackageFragmentDescriptor fragment : this.packageFragmentProvider.getAllFragments()) {
            if (scriptFqNames.contains(fragment.getFqName())) continue;
            fragment.getMemberScope().changeLockLevel(WritableScope.LockLevel.READING);
        }
    }

    public static void processClassOrObject(@NotNull GlobalContext globalContext, final @Nullable WritableScope scope, @NotNull ExpressionTypingContext context, final @NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject object2) {
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        if (object2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "processClassOrObject"));
        }
        ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<dummy for object>"), Collections.<ImportPath>emptyList(), PlatformToKotlinClassMap.EMPTY);
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(globalContext.getStorageManager(), globalContext.getExceptionTracker(), Predicates.equalTo(object2.getContainingFile()), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForTopDownAnalyzerBasic injector = new InjectorForTopDownAnalyzerBasic(object2.getProject(), topDownAnalysisParameters, context.trace, moduleDescriptor);
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        c.setOuterDataFlowInfo(context.dataFlowInfo);
        injector.getTopDownAnalyzer().doProcess(c, context.scope, new PackageLikeBuilder(){

            @Override
            @NotNull
            public DeclarationDescriptor getOwnerForChildren() {
                DeclarationDescriptor declarationDescriptor = containingDeclaration;
                if (declarationDescriptor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$3", "getOwnerForChildren"));
                }
                return declarationDescriptor;
            }

            @Override
            public void addClassifierDescriptor(@NotNull MutableClassDescriptorLite classDescriptor) {
                if (classDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$3", "addClassifierDescriptor"));
                }
                if (scope != null) {
                    scope.addClassifierDescriptor(classDescriptor);
                }
            }

            @Override
            public void addFunctionDescriptor(@NotNull SimpleFunctionDescriptor functionDescriptor) {
                if (functionDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$3", "addFunctionDescriptor"));
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public void addPropertyDescriptor(@NotNull PropertyDescriptor propertyDescriptor) {
                if (propertyDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$3", "addPropertyDescriptor"));
                }
            }

            @Override
            public PackageLikeBuilder.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                if (classObjectDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObjectDescriptor", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer$3", "setClassObjectDescriptor"));
                }
                return PackageLikeBuilder.ClassObjectStatus.NOT_ALLOWED;
            }
        }, Collections.singletonList(object2));
    }

    @NotNull
    public TopDownAnalysisContext analyzeFiles(@NotNull TopDownAnalysisParameters topDownAnalysisParameters, @NotNull Collection<JetFile> files) {
        if (topDownAnalysisParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topDownAnalysisParameters", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        ((ModuleDescriptorImpl)this.moduleDescriptor).addFragmentProvider(DependencyKind.SOURCES, this.packageFragmentProvider);
        ((ModuleDescriptorImpl)this.moduleDescriptor).addFragmentProvider(DependencyKind.BUILT_INS, KotlinBuiltIns.getInstance().getBuiltInsModule().getPackageFragmentProvider());
        TopDownAnalysisContext c = new TopDownAnalysisContext(topDownAnalysisParameters);
        this.doProcess(c, JetModuleUtil.getSubpackagesOfRootScope(this.moduleDescriptor), new PackageLikeBuilderDummy(), files);
        TopDownAnalysisContext topDownAnalysisContext = c;
        if (topDownAnalysisContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "analyzeFiles"));
        }
        return topDownAnalysisContext;
    }

    public void prepareForTheNextReplLine(@NotNull TopDownAnalysisContext c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "prepareForTheNextReplLine"));
        }
        c.getScriptScopes().clear();
        c.getScripts().clear();
    }

    @NotNull
    public MutablePackageFragmentProvider getPackageFragmentProvider() {
        MutablePackageFragmentProvider mutablePackageFragmentProvider = this.packageFragmentProvider;
        if (mutablePackageFragmentProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalyzer", "getPackageFragmentProvider"));
        }
        return mutablePackageFragmentProvider;
    }
}

