/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSafeQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.jet.lang.resolve.calls.CallResolverUtil;
import org.jetbrains.jet.lang.resolve.calls.CallTransformer;
import org.jetbrains.jet.lang.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastUtils;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CallResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.CheckValueArgumentsMode;
import org.jetbrains.jet.lang.resolve.calls.context.ContextDependency;
import org.jetbrains.jet.lang.resolve.calls.context.ResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.results.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.tasks.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.tasks.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.util.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeInfo;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class CandidateResolver {
    @NotNull
    private ArgumentTypeResolver argumentTypeResolver;

    public void setArgumentTypeResolver(@NotNull ArgumentTypeResolver argumentTypeResolver) {
        if (argumentTypeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypeResolver", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "setArgumentTypeResolver"));
        }
        this.argumentTypeResolver = argumentTypeResolver;
    }

    public <D extends CallableDescriptor, F extends D> void performResolutionForCandidateCall(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolutionTask<D, F> task) {
        List<JetTypeProjection> jetTypeArguments;
        LinkedHashSet<ValueArgument> unmappedArguments;
        ValueArgumentsToParametersMapper.Status argumentMappingStatus;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "performResolutionForCandidateCall"));
        }
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "performResolutionForCandidateCall"));
        }
        ProgressIndicatorProvider.checkCanceled();
        ResolvedCallImpl candidateCall = context.candidateCall;
        Object candidate = candidateCall.getCandidateDescriptor();
        candidateCall.addStatus(CandidateResolver.checkReceiverTypeError(context));
        if (ErrorUtils.isError(candidate)) {
            candidateCall.addStatus(ResolutionStatus.SUCCESS);
            CandidateResolver.markAllArgumentsAsUnmapped(context);
            return;
        }
        if (!CandidateResolver.checkOuterClassMemberIsAccessible(context)) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            CandidateResolver.markAllArgumentsAsUnmapped(context);
            return;
        }
        DeclarationDescriptorWithVisibility invisibleMember = Visibilities.findInvisibleMember(candidate, context.scope.getContainingDeclaration());
        if (invisibleMember != null) {
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            context.tracing.invisibleMember(context.trace, invisibleMember);
            CandidateResolver.markAllArgumentsAsUnmapped(context);
            return;
        }
        if (task.checkArguments == CheckValueArgumentsMode.ENABLED && !(argumentMappingStatus = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters(context.call, context.tracing, candidateCall, unmappedArguments = Sets.newLinkedHashSet())).isSuccess()) {
            if (argumentMappingStatus == ValueArgumentsToParametersMapper.Status.STRONG_ERROR) {
                candidateCall.addStatus(ResolutionStatus.RECEIVER_PRESENCE_ERROR);
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
            }
            candidateCall.setUnmappedArguments(unmappedArguments);
            if (argumentMappingStatus == ValueArgumentsToParametersMapper.Status.ERROR && candidate.getTypeParameters().isEmpty() || argumentMappingStatus == ValueArgumentsToParametersMapper.Status.STRONG_ERROR) {
                return;
            }
        }
        if ((jetTypeArguments = context.call.getTypeArguments()).isEmpty()) {
            if (!candidate.getTypeParameters().isEmpty()) {
                ResolutionStatus status = this.inferTypeArguments(context);
                candidateCall.addStatus(status);
            } else {
                candidateCall.addStatus(this.checkAllValueArguments(context, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).status);
            }
        } else {
            ArrayList<JetType> typeArguments = new ArrayList<JetType>();
            for (JetTypeProjection projection : jetTypeArguments) {
                if (projection.getProjectionKind() != JetProjectionKind.NONE) {
                    context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                }
                typeArguments.add(this.argumentTypeResolver.resolveTypeRefWithDefault(projection.getTypeReference(), context.scope, context.trace, ErrorUtils.createErrorType("Star projection in a call")));
            }
            int expectedTypeArgumentCount = candidate.getTypeParameters().size();
            if (expectedTypeArgumentCount == jetTypeArguments.size()) {
                CandidateResolver.checkGenericBoundsInAFunctionCall(jetTypeArguments, typeArguments, candidate, context.trace);
                Map<TypeConstructor, TypeProjection> substitutionContext = FunctionDescriptorUtil.createSubstitutionContext((FunctionDescriptor)candidate, typeArguments);
                TypeSubstitutor substitutor = TypeSubstitutor.create(substitutionContext);
                candidateCall.setResultingSubstitutor(substitutor);
                candidateCall.addStatus(this.checkAllValueArguments(context, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS).status);
            } else {
                candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
                context.tracing.wrongNumberOfTypeArguments(context.trace, expectedTypeArgumentCount);
            }
        }
        task.performAdvancedChecks(candidate, context.trace, context.tracing);
        JetSuperExpression superExpression = TaskPrioritizer.getReceiverSuper(candidateCall.getReceiverArgument());
        if (superExpression != null) {
            context.trace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(superExpression, superExpression.getText()));
            candidateCall.addStatus(ResolutionStatus.OTHER_ERROR);
        }
    }

    private static void markAllArgumentsAsUnmapped(CallCandidateResolutionContext<?> context) {
        if (context.checkArguments == CheckValueArgumentsMode.ENABLED) {
            context.candidateCall.setUnmappedArguments(context.call.getValueArguments());
        }
    }

    private static boolean checkOuterClassMemberIsAccessible(@NotNull CallCandidateResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkOuterClassMemberIsAccessible"));
        }
        if (context.call.getExplicitReceiver().exists() || context.call.getThisObject().exists()) {
            return true;
        }
        ClassDescriptor candidateThis = CandidateResolver.getDeclaringClass(context.candidateCall.getCandidateDescriptor());
        if (candidateThis == null || candidateThis.getKind().isSingleton()) {
            return true;
        }
        return DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, context.call.getCallElement(), candidateThis);
    }

    @Nullable
    private static ClassDescriptor getDeclaringClass(@NotNull CallableDescriptor candidate) {
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "getDeclaringClass"));
        }
        ReceiverParameterDescriptor expectedThis = candidate.getExpectedThisObject();
        if (expectedThis == null) {
            return null;
        }
        DeclarationDescriptor descriptor = expectedThis.getContainingDeclaration();
        return descriptor instanceof ClassDescriptor ? (ClassDescriptor)descriptor : null;
    }

    public <D extends CallableDescriptor> void completeTypeInferenceDependentOnFunctionLiteralsForCall(CallCandidateResolutionContext<D> context) {
        ResolvedCallImpl resolvedCall = context.candidateCall;
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        if (!resolvedCall.hasIncompleteTypeParameters() || constraintSystem == null) {
            return;
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = entry.getKey();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                this.addConstraintForFunctionLiteral(valueArgument, valueParameterDescriptor, constraintSystem, context);
            }
        }
        resolvedCall.setResultingSubstitutor(constraintSystem.getResultingSubstitutor());
    }

    @Nullable
    public <D extends CallableDescriptor> JetType completeTypeInferenceDependentOnExpectedTypeForCall(@NotNull CallCandidateResolutionContext<D> context, boolean isInnerCall) {
        PsiElement callElement;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeTypeInferenceDependentOnExpectedTypeForCall"));
        }
        ResolvedCallImpl resolvedCall = context.candidateCall;
        assert (resolvedCall.hasIncompleteTypeParameters());
        assert (resolvedCall.getConstraintSystem() != null);
        JetType unsubstitutedReturnType = resolvedCall.getCandidateDescriptor().getReturnType();
        if (unsubstitutedReturnType != null) {
            resolvedCall.getConstraintSystem().addSupertypeConstraint(context.expectedType, unsubstitutedReturnType, ConstraintPosition.EXPECTED_TYPE_POSITION);
        }
        CandidateResolver.updateSystemWithConstraintSystemCompleter(context, resolvedCall);
        CandidateResolver.updateSystemIfExpectedTypeIsUnit(context, resolvedCall);
        ((ConstraintSystemImpl)resolvedCall.getConstraintSystem()).processDeclaredBoundConstraints();
        if (!resolvedCall.getConstraintSystem().getStatus().isSuccessful()) {
            return this.reportInferenceError(context);
        }
        resolvedCall.setResultingSubstitutor(resolvedCall.getConstraintSystem().getResultingSubstitutor());
        this.completeNestedCallsInference(context);
        this.checkAllValueArguments(context, context.trace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        resolvedCall.setHasUnknownTypeParameters(false);
        ResolutionStatus status = resolvedCall.getStatus();
        if (status == ResolutionStatus.UNKNOWN_STATUS || status == ResolutionStatus.INCOMPLETE_TYPE_INFERENCE) {
            resolvedCall.setStatusToSuccess();
        }
        JetType returnType = resolvedCall.getResultingDescriptor().getReturnType();
        if (isInnerCall && (callElement = context.call.getCallElement()) instanceof JetCallExpression) {
            DataFlowUtils.checkType(returnType, (JetCallExpression)callElement, context, context.dataFlowInfo);
        }
        return returnType;
    }

    private static <D extends CallableDescriptor> void updateSystemWithConstraintSystemCompleter(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolvedCallImpl<D> resolvedCall) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "updateSystemWithConstraintSystemCompleter"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "updateSystemWithConstraintSystemCompleter"));
        }
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        assert (constraintSystem != null);
        ConstraintSystemCompleter constraintSystemCompleter = context.trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, context.call.getCalleeExpression());
        if (constraintSystemCompleter == null) {
            return;
        }
        ConstraintSystem copy = constraintSystem.copy();
        constraintSystemCompleter.completeConstraintSystem(copy, resolvedCall);
        if (!copy.getStatus().hasOnlyErrorsFromPosition(ConstraintPosition.FROM_COMPLETER)) {
            resolvedCall.setConstraintSystem(copy);
        }
    }

    private static <D extends CallableDescriptor> void updateSystemIfExpectedTypeIsUnit(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolvedCallImpl<D> resolvedCall) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "updateSystemIfExpectedTypeIsUnit"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "updateSystemIfExpectedTypeIsUnit"));
        }
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        assert (constraintSystem != null);
        JetType returnType = resolvedCall.getCandidateDescriptor().getReturnType();
        if (returnType == null) {
            return;
        }
        if (!constraintSystem.getStatus().isSuccessful() && context.expectedType == TypeUtils.UNIT_EXPECTED_TYPE) {
            ConstraintSystemImpl copy = (ConstraintSystemImpl)constraintSystem.copy();
            copy.addSupertypeConstraint(KotlinBuiltIns.getInstance().getUnitType(), returnType, ConstraintPosition.EXPECTED_TYPE_POSITION);
            if (copy.getStatus().isSuccessful()) {
                resolvedCall.setConstraintSystem(copy);
            }
        }
    }

    private <D extends CallableDescriptor> JetType reportInferenceError(@NotNull CallCandidateResolutionContext<D> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "reportInferenceError"));
        }
        ResolvedCallImpl resolvedCall = context.candidateCall;
        ConstraintSystem constraintSystem = resolvedCall.getConstraintSystem();
        assert (constraintSystem != null);
        resolvedCall.setResultingSubstitutor(constraintSystem.getResultingSubstitutor());
        this.completeNestedCallsInference(context);
        List<JetType> argumentTypes = this.checkValueArgumentTypes(context, resolvedCall, (BindingTrace)context.trace, (CallResolverUtil.ResolveArgumentsMode)CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).argumentTypes;
        JetType receiverType = resolvedCall.getReceiverArgument().exists() ? resolvedCall.getReceiverArgument().getType() : null;
        InferenceErrorData errorData = InferenceErrorData.create(resolvedCall.getCandidateDescriptor(), constraintSystem, argumentTypes, receiverType, context.expectedType);
        context.tracing.typeInferenceFailed(context.trace, errorData);
        resolvedCall.addStatus(ResolutionStatus.OTHER_ERROR);
        if (!resolvedCall.hasInferredReturnType()) {
            return null;
        }
        return resolvedCall.getResultingDescriptor().getReturnType();
    }

    public <D extends CallableDescriptor> void completeNestedCallsInference(@NotNull CallCandidateResolutionContext<D> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeNestedCallsInference"));
        }
        if (context.call.getCallType() == Call.CallType.INVOKE) {
            return;
        }
        ResolvedCallImpl resolvedCall = context.candidateCall;
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                this.completeInferenceForArgument(argument, parameterDescriptor, context);
            }
        }
        this.completeUnmappedArguments(context, context.candidateCall.getUnmappedArguments());
        CandidateResolver.recordReferenceForInvokeFunction(context);
    }

    private <D extends CallableDescriptor> void completeInferenceForArgument(@NotNull ValueArgument argument, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull CallCandidateResolutionContext<D> context) {
        JetType type;
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeInferenceForArgument"));
        }
        if (parameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeInferenceForArgument"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeInferenceForArgument"));
        }
        JetExpression expression = argument.getArgumentExpression();
        if (expression == null) {
            return;
        }
        JetType expectedType = CandidateResolver.getEffectiveExpectedType(parameterDescriptor, argument);
        context = (CallCandidateResolutionContext)context.replaceExpectedType(expectedType);
        JetExpression keyExpression = this.getDeferredComputationKeyExpression(expression);
        CallCandidateResolutionContext<?> storedContextForArgument = context.resolutionResultsCache.getDeferredComputation(keyExpression);
        PsiElement parent = expression.getParent();
        if (parent instanceof JetWhenExpression && expression == ((JetWhenExpression)parent).getSubjectExpression() || expression instanceof JetFunctionLiteralExpression) {
            return;
        }
        if (storedContextForArgument == null) {
            JetType type2 = ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression);
            CandidateResolver.checkResultArgumentType(type2, argument, context);
            return;
        }
        CallCandidateResolutionContext contextForArgument = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)storedContextForArgument.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceBindingTrace(context.trace)).replaceExpectedType(expectedType);
        if (contextForArgument.candidateCall.hasIncompleteTypeParameters() && !contextForArgument.candidateCall.isCompleted()) {
            type = this.completeTypeInferenceDependentOnExpectedTypeForCall(contextForArgument, true);
        } else {
            this.completeNestedCallsInference(contextForArgument);
            JetType recordedType = context.trace.get(BindingContext.EXPRESSION_TYPE, expression);
            type = recordedType != null && !recordedType.getConstructor().isDenotable() ? ArgumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression) : contextForArgument.candidateCall.getResultingDescriptor().getReturnType();
            this.checkValueArgumentTypes(contextForArgument);
        }
        JetType result2 = BindingContextUtils.updateRecordedType(type, expression, context.trace, CandidateResolver.isFairSafeCallExpression(expression, context.trace));
        CandidateResolver.markResultingCallAsCompleted(context, keyExpression);
        DataFlowUtils.checkType(result2, expression, (ResolutionContext)contextForArgument);
    }

    public void completeNestedCallsForNotResolvedInvocation(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeNestedCallsForNotResolvedInvocation"));
        }
        this.completeNestedCallsForNotResolvedInvocation(context, context.call.getValueArguments());
    }

    public void completeUnmappedArguments(@NotNull CallResolutionContext<?> context, @NotNull Collection<? extends ValueArgument> unmappedArguments) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeUnmappedArguments"));
        }
        if (unmappedArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmappedArguments", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeUnmappedArguments"));
        }
        this.completeNestedCallsForNotResolvedInvocation(context, unmappedArguments);
    }

    private void completeNestedCallsForNotResolvedInvocation(@NotNull CallResolutionContext<?> context, @NotNull Collection<? extends ValueArgument> arguments) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeNestedCallsForNotResolvedInvocation"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "completeNestedCallsForNotResolvedInvocation"));
        }
        if (context.call.getCallType() == Call.CallType.INVOKE) {
            return;
        }
        if (context.checkArguments == CheckValueArgumentsMode.DISABLED) {
            return;
        }
        for (ValueArgument valueArgument : arguments) {
            JetExpression expression = valueArgument.getArgumentExpression();
            JetExpression keyExpression = this.getDeferredComputationKeyExpression(expression);
            CandidateResolver.markResultingCallAsCompleted(context, keyExpression);
            CallCandidateResolutionContext<?> storedContextForArgument = context.resolutionResultsCache.getDeferredComputation(keyExpression);
            if (storedContextForArgument == null) continue;
            this.completeNestedCallsForNotResolvedInvocation(storedContextForArgument);
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)storedContextForArgument.replaceBindingTrace(context.trace);
            this.completeUnmappedArguments(newContext, storedContextForArgument.candidateCall.getUnmappedArguments());
            this.argumentTypeResolver.checkTypesForFunctionArgumentsWithNoCallee((CallResolutionContext)newContext.replaceContextDependency(ContextDependency.INDEPENDENT));
        }
    }

    private static void markResultingCallAsCompleted(@NotNull CallResolutionContext<?> context, @Nullable JetExpression keyExpression) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "markResultingCallAsCompleted"));
        }
        if (keyExpression == null) {
            return;
        }
        CallCandidateResolutionContext<?> storedContextForArgument = context.resolutionResultsCache.getDeferredComputation(keyExpression);
        if (storedContextForArgument == null) {
            return;
        }
        storedContextForArgument.candidateCall.markCallAsCompleted();
        ResolvedCallWithTrace<?> resolvedCall = context.resolutionResultsCache.getCallForArgument(keyExpression);
        assert (resolvedCall != null) : "Resolved call for '" + keyExpression + "' is not stored, but CallCandidateResolutionContext is.";
        resolvedCall.markCallAsCompleted();
    }

    @Nullable
    private JetExpression getDeferredComputationKeyExpression(@Nullable JetExpression expression) {
        if (expression == null) {
            return null;
        }
        return expression.accept(new JetVisitor<JetExpression, Void>(){

            @Nullable
            private JetExpression visitInnerExpression(@Nullable JetElement expression) {
                if (expression == null) {
                    return null;
                }
                return expression.accept(this, null);
            }

            @Override
            public JetExpression visitQualifiedExpression(@NotNull JetQualifiedExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitQualifiedExpression"));
                }
                return this.visitInnerExpression(expression.getSelectorExpression());
            }

            @Override
            public JetExpression visitExpression(@NotNull JetExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitExpression"));
                }
                return expression;
            }

            @Override
            public JetExpression visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitParenthesizedExpression"));
                }
                return this.visitInnerExpression(expression.getExpression());
            }

            @Override
            public JetExpression visitUnaryExpression(@NotNull JetUnaryExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitUnaryExpression"));
                }
                return ExpressionTypingUtils.isUnaryExpressionDependentOnExpectedType(expression) ? expression : null;
            }

            @Override
            public JetExpression visitPrefixExpression(@NotNull JetPrefixExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitPrefixExpression"));
                }
                return this.visitInnerExpression(JetPsiUtil.getBaseExpressionIfLabeledExpression(expression));
            }

            @Override
            public JetExpression visitBlockExpression(@NotNull JetBlockExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitBlockExpression"));
                }
                JetElement lastStatement = JetPsiUtil.getLastStatementInABlock(expression);
                if (lastStatement != null) {
                    return this.visitInnerExpression(lastStatement);
                }
                return expression;
            }

            @Override
            public JetExpression visitBinaryExpression(@NotNull JetBinaryExpression expression, Void data2) {
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$1", "visitBinaryExpression"));
                }
                return ExpressionTypingUtils.isBinaryExpressionDependentOnExpectedType(expression) ? expression : null;
            }
        }, null);
    }

    private static boolean isFairSafeCallExpression(@NotNull JetExpression expression, @NotNull BindingTrace trace) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "isFairSafeCallExpression"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "isFairSafeCallExpression"));
        }
        if (!(expression instanceof JetSafeQualifiedExpression)) {
            return false;
        }
        JetSafeQualifiedExpression safeQualifiedExpression = (JetSafeQualifiedExpression)expression;
        JetType type = trace.get(BindingContext.EXPRESSION_TYPE, safeQualifiedExpression.getReceiverExpression());
        return type != null && type.isNullable();
    }

    private static <D extends CallableDescriptor> void checkResultArgumentType(@Nullable JetType type, @NotNull ValueArgument argument, @NotNull CallCandidateResolutionContext<D> context) {
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkResultArgumentType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkResultArgumentType"));
        }
        JetExpression expression = argument.getArgumentExpression();
        if (expression == null) {
            return;
        }
        DataFlowInfo dataFlowInfoForValueArgument = context.candidateCall.getDataFlowInfoForArguments().getInfo(argument);
        Object newContext = ((CallCandidateResolutionContext)context.replaceExpectedType(context.expectedType)).replaceDataFlowInfo(dataFlowInfoForValueArgument);
        DataFlowUtils.checkType(type, expression, newContext);
    }

    private static <D extends CallableDescriptor> void recordReferenceForInvokeFunction(CallCandidateResolutionContext<D> context) {
        PsiElement callElement = context.call.getCallElement();
        if (!(callElement instanceof JetCallExpression)) {
            return;
        }
        JetCallExpression callExpression = (JetCallExpression)callElement;
        if (BindingContextUtils.isCallExpressionWithValidReference(callExpression, context.trace.getBindingContext())) {
            Object resultingDescriptor = context.candidateCall.getResultingDescriptor();
            context.trace.record(BindingContext.EXPRESSION_TYPE, callExpression, resultingDescriptor.getReturnType());
            context.trace.record(BindingContext.REFERENCE_TARGET, callExpression, context.candidateCall.getCandidateDescriptor());
        }
    }

    private <D extends CallableDescriptor> void addConstraintForFunctionLiteral(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<D> context) {
        boolean hasExpectedReturnType;
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForFunctionLiteral"));
        }
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        if (argumentExpression == null) {
            return;
        }
        if (!ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression)) {
            return;
        }
        JetFunctionLiteralExpression functionLiteralExpression = ArgumentTypeResolver.getFunctionLiteralArgument(argumentExpression);
        JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        JetType expectedType = constraintSystem.getCurrentSubstitutor().substitute(effectiveExpectedType, Variance.INVARIANT);
        if (expectedType == null || expectedType == TypeUtils.DONT_CARE) {
            expectedType = this.argumentTypeResolver.getShapeTypeOfFunctionLiteral(functionLiteralExpression, context.scope, context.trace, false);
        }
        if (expectedType == null || !KotlinBuiltIns.getInstance().isFunctionOrExtensionFunctionType(expectedType) || CallResolverUtil.hasUnknownFunctionParameter(expectedType)) {
            return;
        }
        MutableDataFlowInfoForArguments dataFlowInfoForArguments = context.candidateCall.getDataFlowInfoForArguments();
        DataFlowInfo dataFlowInfoForArgument = dataFlowInfoForArguments.getInfo(valueArgument);
        boolean bl = hasExpectedReturnType = !CallResolverUtil.hasUnknownReturnType(expectedType);
        if (hasExpectedReturnType) {
            TemporaryTraceAndCache temporaryToResolveFunctionLiteral = TemporaryTraceAndCache.create(context, "trace to resolve function literal with expected return type", argumentExpression);
            JetElement statementExpression = JetPsiUtil.getLastStatementInABlock(functionLiteralExpression.getBodyExpression());
            if (statementExpression == null) {
                return;
            }
            boolean[] mismatch = new boolean[1];
            ObservableBindingTrace errorInterceptingTrace = ExpressionTypingUtils.makeTraceInterceptingTypeMismatch(temporaryToResolveFunctionLiteral.trace, statementExpression, mismatch);
            CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceBindingTrace(errorInterceptingTrace)).replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceResolutionResultsCache(temporaryToResolveFunctionLiteral.cache)).replaceContextDependency(ContextDependency.INDEPENDENT);
            JetType type = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteralExpression, newContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
            if (!mismatch[0]) {
                constraintSystem.addSubtypeConstraint(type, effectiveExpectedType, ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
                temporaryToResolveFunctionLiteral.commit();
                return;
            }
        }
        JetType expectedTypeWithoutReturnType = hasExpectedReturnType ? CallResolverUtil.replaceReturnTypeByUnknown(expectedType) : expectedType;
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedTypeWithoutReturnType)).replaceDataFlowInfo(dataFlowInfoForArgument)).replaceContextDependency(ContextDependency.INDEPENDENT);
        JetType type = this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteralExpression, newContext, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS).getType();
        constraintSystem.addSubtypeConstraint(type, effectiveExpectedType, ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
    }

    private <D extends CallableDescriptor> ResolutionStatus inferTypeArguments(CallCandidateResolutionContext<D> context) {
        ResolvedCallImpl candidateCall = context.candidateCall;
        final Object candidate = candidateCall.getCandidateDescriptor();
        context.trace.get(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, context.call.getCallElement());
        ConstraintSystemImpl constraintSystem = new ConstraintSystemImpl();
        Object candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidate);
        LinkedHashMap<TypeParameterDescriptor, Variance> typeVariables = Maps.newLinkedHashMap();
        for (TypeParameterDescriptor typeParameterDescriptor : candidateWithFreshVariables.getTypeParameters()) {
            typeVariables.put(typeParameterDescriptor, Variance.INVARIANT);
        }
        constraintSystem.registerTypeVariables(typeVariables);
        TypeSubstitutor substituteDontCare = TypeUtils.makeConstantSubstitutor(candidateWithFreshVariables.getTypeParameters(), TypeUtils.DONT_CARE);
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ResolvedValueArgument resolvedValueArgument = entry.getValue();
            ValueParameterDescriptor valueParameterDescriptor = candidateWithFreshVariables.getValueParameters().get(entry.getKey().getIndex());
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                boolean[] isErrorType = new boolean[1];
                this.addConstraintForValueArgument(valueArgument, valueParameterDescriptor, substituteDontCare, constraintSystem, context, isErrorType, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
                if (!isErrorType[0]) continue;
                candidateCall.argumentHasNoType();
            }
        }
        ReceiverValue receiverArgument2 = candidateCall.getReceiverArgument();
        ReceiverParameterDescriptor receiverParameter = candidateWithFreshVariables.getReceiverParameter();
        if (receiverArgument2.exists() && receiverParameter != null) {
            JetType receiverType;
            JetType jetType = receiverType = context.candidateCall.isSafeCall() ? TypeUtils.makeNotNullable(receiverArgument2.getType()) : receiverArgument2.getType();
            if (receiverArgument2 instanceof ExpressionReceiver) {
                receiverType = CandidateResolver.updateResultTypeForSmartCasts(receiverType, ((ExpressionReceiver)receiverArgument2).getExpression(), context.dataFlowInfo, context.trace);
            }
            constraintSystem.addSubtypeConstraint(receiverType, receiverParameter.getType(), ConstraintPosition.RECEIVER_POSITION);
        }
        ConstraintSystem constraintSystemWithRightTypeParameters = constraintSystem.substituteTypeVariables(new Function<TypeParameterDescriptor, TypeParameterDescriptor>(){

            @Override
            public TypeParameterDescriptor apply(@Nullable TypeParameterDescriptor typeParameterDescriptor) {
                assert (typeParameterDescriptor != null);
                return candidate.getTypeParameters().get(typeParameterDescriptor.getIndex());
            }
        });
        candidateCall.setConstraintSystem(constraintSystemWithRightTypeParameters);
        boolean hasContradiction = constraintSystem.getStatus().hasContradiction();
        candidateCall.setHasUnknownTypeParameters(true);
        if (!hasContradiction) {
            return ResolutionStatus.INCOMPLETE_TYPE_INFERENCE;
        }
        ValueArgumentsCheckingResult checkingResult = this.checkAllValueArguments(context, CallResolverUtil.ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
        ResolutionStatus argumentsStatus = checkingResult.status;
        return ResolutionStatus.OTHER_ERROR.combine(argumentsStatus);
    }

    private void addConstraintForValueArgument(@NotNull ValueArgument valueArgument, @NotNull ValueParameterDescriptor valueParameterDescriptor, @NotNull TypeSubstitutor substitutor, @NotNull ConstraintSystem constraintSystem, @NotNull CallCandidateResolutionContext<?> context, @Nullable boolean[] isErrorType, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (valueArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueArgument", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (valueParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameterDescriptor", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (constraintSystem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintSystem", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "addConstraintForValueArgument"));
        }
        JetType effectiveExpectedType = CandidateResolver.getEffectiveExpectedType(valueParameterDescriptor, valueArgument);
        JetExpression argumentExpression = valueArgument.getArgumentExpression();
        JetType expectedType = substitutor.substitute(effectiveExpectedType, Variance.INVARIANT);
        DataFlowInfo dataFlowInfoForArgument = context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument);
        CallResolutionContext newContext = (CallResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(expectedType)).replaceDataFlowInfo(dataFlowInfoForArgument);
        JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(argumentExpression, newContext, resolveFunctionArgumentBodies);
        context.candidateCall.getDataFlowInfoForArguments().updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        JetType type = CandidateResolver.updateResultTypeForSmartCasts(typeInfoForCall.getType(), argumentExpression, dataFlowInfoForArgument, context.trace);
        constraintSystem.addSubtypeConstraint(type, effectiveExpectedType, ConstraintPosition.getValueParameterPosition(valueParameterDescriptor.getIndex()));
        if (isErrorType != null) {
            isErrorType[0] = type == null || type.isError();
        }
    }

    @Nullable
    private static JetType updateResultTypeForSmartCasts(@Nullable JetType type, @Nullable JetExpression argumentExpression, @NotNull DataFlowInfo dataFlowInfoForArgument, @NotNull BindingTrace trace) {
        if (dataFlowInfoForArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfoForArgument", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "updateResultTypeForSmartCasts"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "updateResultTypeForSmartCasts"));
        }
        if (argumentExpression == null || type == null) {
            return type;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(argumentExpression, type, trace.getBindingContext());
        if (!dataFlowValue.isStableIdentifier()) {
            return type;
        }
        Set<JetType> possibleTypes = dataFlowInfoForArgument.getPossibleTypes(dataFlowValue);
        if (possibleTypes.isEmpty()) {
            return type;
        }
        return TypeUtils.intersect(JetTypeChecker.INSTANCE, possibleTypes);
    }

    private <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        return this.checkAllValueArguments(context, context.candidateCall.getTrace(), resolveFunctionArgumentBodies);
    }

    private <D extends CallableDescriptor> ValueArgumentsCheckingResult checkAllValueArguments(@NotNull CallCandidateResolutionContext<D> context, @NotNull BindingTrace trace, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkAllValueArguments"));
        }
        ValueArgumentsCheckingResult checkingResult = this.checkValueArgumentTypes(context, context.candidateCall, trace, resolveFunctionArgumentBodies);
        ResolutionStatus resultStatus = checkingResult.status;
        resultStatus = resultStatus.combine(CandidateResolver.checkReceivers(context, trace));
        return new ValueArgumentsCheckingResult(resultStatus, checkingResult.argumentTypes);
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceivers(@NotNull CallCandidateResolutionContext<D> context, @NotNull BindingTrace trace) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceivers"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceivers"));
        }
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ResolvedCallImpl candidateCall = context.candidateCall;
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiverTypeError(context));
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context, candidateCall, trace, candidateCall.getResultingDescriptor().getReceiverParameter(), candidateCall.getReceiverArgument(), candidateCall.getExplicitReceiverKind().isReceiver(), false));
        resultStatus = resultStatus.combine(CandidateResolver.checkReceiver(context, candidateCall, trace, candidateCall.getResultingDescriptor().getExpectedThisObject(), candidateCall.getThisObject(), candidateCall.getExplicitReceiverKind().isThisObject(), context.call instanceof CallTransformer.CallForImplicitInvoke));
        return resultStatus;
    }

    public <D extends CallableDescriptor> ValueArgumentsCheckingResult checkValueArgumentTypes(@NotNull CallCandidateResolutionContext<D> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        return this.checkValueArgumentTypes(context, context.candidateCall, context.trace, CallResolverUtil.ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
    }

    private <D extends CallableDescriptor, C extends CallResolutionContext<C>> ValueArgumentsCheckingResult checkValueArgumentTypes(@NotNull CallResolutionContext<C> context, @NotNull ResolvedCallImpl<D> candidateCall, @NotNull BindingTrace trace, @NotNull CallResolverUtil.ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkValueArgumentTypes"));
        }
        ResolutionStatus resultStatus = ResolutionStatus.SUCCESS;
        ArrayList<JetType> argumentTypes = Lists.newArrayList();
        MutableDataFlowInfoForArguments infoForArguments = candidateCall.getDataFlowInfoForArguments();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                JetType resultingType;
                JetExpression expression = argument.getArgumentExpression();
                if (expression == null) continue;
                JetType expectedType = CandidateResolver.getEffectiveExpectedType(parameterDescriptor, argument);
                if (TypeUtils.dependsOnTypeParameters(expectedType, candidateCall.getCandidateDescriptor().getTypeParameters())) {
                    expectedType = TypeUtils.NO_EXPECTED_TYPE;
                }
                CallResolutionContext newContext = (CallResolutionContext)((CallResolutionContext)((CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(argument))).replaceBindingTrace(trace)).replaceExpectedType(expectedType);
                JetTypeInfo typeInfoForCall = this.argumentTypeResolver.getArgumentTypeInfo(expression, newContext, resolveFunctionArgumentBodies);
                JetType type = typeInfoForCall.getType();
                infoForArguments.updateInfo(argument, typeInfoForCall.getDataFlowInfo());
                if (type == null || type.isError() && type != TypeUtils.PLACEHOLDER_FUNCTION_TYPE) {
                    candidateCall.argumentHasNoType();
                    argumentTypes.add(type);
                    continue;
                }
                if (TypeUtils.noExpectedType(expectedType) || ArgumentTypeResolver.isSubtypeOfForArgumentType(type, expectedType)) {
                    resultingType = type;
                } else {
                    resultingType = CandidateResolver.autocastValueArgumentTypeIfPossible(expression, expectedType, type, newContext);
                    if (resultingType == null) {
                        resultingType = type;
                        resultStatus = ResolutionStatus.OTHER_ERROR;
                    }
                }
                argumentTypes.add(resultingType);
            }
        }
        return new ValueArgumentsCheckingResult(resultStatus, argumentTypes);
    }

    @Nullable
    private static JetType autocastValueArgumentTypeIfPossible(@NotNull JetExpression expression, @NotNull JetType expectedType, @NotNull JetType actualType, @NotNull ResolutionContext<?> context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "autocastValueArgumentTypeIfPossible"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "autocastValueArgumentTypeIfPossible"));
        }
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "autocastValueArgumentTypeIfPossible"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "autocastValueArgumentTypeIfPossible"));
        }
        ExpressionReceiver receiverToCast = new ExpressionReceiver(JetPsiUtil.safeDeparenthesize(expression, false), actualType);
        List<JetType> variants = AutoCastUtils.getAutoCastVariantsExcludingReceiver(context.trace.getBindingContext(), context.dataFlowInfo, receiverToCast);
        for (JetType possibleType : variants) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(possibleType, expectedType)) continue;
            return possibleType;
        }
        return null;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiverTypeError(@NotNull CallCandidateResolutionContext<D> context) {
        ReceiverValue receiverArgument2;
        ReceiverParameterDescriptor receiverParameterDescriptor;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceiverTypeError"));
        }
        ResolvedCallImpl candidateCall = context.candidateCall;
        Object candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (candidateDescriptor instanceof ExpressionAsFunctionDescriptor) {
            return ResolutionStatus.SUCCESS;
        }
        ReceiverParameterDescriptor receiverDescriptor = candidateDescriptor.getReceiverParameter();
        ReceiverParameterDescriptor expectedThisObjectDescriptor = candidateDescriptor.getExpectedThisObject();
        if (receiverDescriptor != null && candidateCall.getReceiverArgument().exists()) {
            receiverParameterDescriptor = receiverDescriptor;
            receiverArgument2 = candidateCall.getReceiverArgument();
        } else if (expectedThisObjectDescriptor != null && candidateCall.getThisObject().exists()) {
            receiverParameterDescriptor = expectedThisObjectDescriptor;
            receiverArgument2 = candidateCall.getThisObject();
        } else {
            return ResolutionStatus.SUCCESS;
        }
        JetType erasedReceiverType = CallResolverUtil.getErasedReceiverType(receiverParameterDescriptor, candidateDescriptor);
        boolean isSubtypeByAutoCast = AutoCastUtils.isSubTypeByAutoCastIgnoringNullability(receiverArgument2, erasedReceiverType, context);
        if (!isSubtypeByAutoCast) {
            return ResolutionStatus.RECEIVER_TYPE_ERROR;
        }
        return ResolutionStatus.SUCCESS;
    }

    private static <D extends CallableDescriptor> ResolutionStatus checkReceiver(@NotNull CallCandidateResolutionContext<D> context, @NotNull ResolvedCall<D> candidateCall, @NotNull BindingTrace trace, @Nullable ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument2, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (candidateCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidateCall", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkReceiver"));
        }
        if (receiverParameter == null || !receiverArgument2.exists()) {
            return ResolutionStatus.SUCCESS;
        }
        D candidateDescriptor = candidateCall.getCandidateDescriptor();
        if (TypeUtils.dependsOnTypeParameters(receiverParameter.getType(), candidateDescriptor.getTypeParameters())) {
            return ResolutionStatus.SUCCESS;
        }
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && candidateCall.isSafeCall();
        boolean isSubtypeByAutoCast = AutoCastUtils.isSubTypeByAutoCastIgnoringNullability(receiverArgument2, receiverParameter.getType(), context);
        if (!isSubtypeByAutoCast) {
            context.tracing.wrongReceiverType(trace, receiverParameter, receiverArgument2);
            return ResolutionStatus.OTHER_ERROR;
        }
        AutoCastUtils.recordAutoCastIfNecessary(receiverArgument2, receiverParameter.getType(), context, safeAccess);
        JetType receiverArgumentType = receiverArgument2.getType();
        BindingContext bindingContext = trace.getBindingContext();
        if (!safeAccess && !receiverParameter.getType().isNullable() && receiverArgumentType.isNullable() && !AutoCastUtils.isNotNull(receiverArgument2, bindingContext, context.dataFlowInfo)) {
            context.tracing.unsafeCall(trace, receiverArgumentType, implicitInvokeCheck);
            return ResolutionStatus.UNSAFE_CALL_ERROR;
        }
        DataFlowValue receiverValue = DataFlowValueFactory.createDataFlowValue(receiverArgument2, bindingContext);
        if (safeAccess && !context.dataFlowInfo.getNullability(receiverValue).canBeNull()) {
            context.tracing.unnecessarySafeCall(trace, receiverArgumentType);
        }
        return ResolutionStatus.SUCCESS;
    }

    @NotNull
    private static JetType getEffectiveExpectedType(ValueParameterDescriptor parameterDescriptor, ValueArgument argument) {
        if (argument.getSpreadElement() != null) {
            if (parameterDescriptor.getVarargElementType() == null) {
                JetType jetType = TypeUtils.DONT_CARE;
                if (jetType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
                }
                return jetType;
            }
            JetType jetType = parameterDescriptor.getType();
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
            }
            return jetType;
        }
        JetType varargElementType = parameterDescriptor.getVarargElementType();
        if (varargElementType != null) {
            JetType jetType = varargElementType;
            if (jetType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
            }
            return jetType;
        }
        JetType jetType = parameterDescriptor.getType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "getEffectiveExpectedType"));
        }
        return jetType;
    }

    private static void checkGenericBoundsInAFunctionCall(@NotNull List<JetTypeProjection> jetTypeArguments, @NotNull List<JetType> typeArguments, @NotNull CallableDescriptor functionDescriptor, @NotNull BindingTrace trace) {
        if (jetTypeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetTypeArguments", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver", "checkGenericBoundsInAFunctionCall"));
        }
        HashMap<TypeConstructor, TypeProjection> context = Maps.newHashMap();
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getOriginal().getTypeParameters();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            context.put(typeParameter.getTypeConstructor(), new TypeProjectionImpl(typeArgument));
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(context);
        int typeParametersSize2 = typeParameters.size();
        for (int i = 0; i < typeParametersSize2; ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            JetTypeReference typeReference = jetTypeArguments.get(i).getTypeReference();
            if (typeReference == null) continue;
            DescriptorResolver.checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor, trace);
        }
    }

    private static class ValueArgumentsCheckingResult {
        public final List<JetType> argumentTypes;
        public final ResolutionStatus status;

        private ValueArgumentsCheckingResult(@NotNull ResolutionStatus status, @NotNull List<JetType> argumentTypes) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult", "<init>"));
            }
            if (argumentTypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentTypes", "org/jetbrains/jet/lang/resolve/calls/CandidateResolver$ValueArgumentsCheckingResult", "<init>"));
            }
            this.status = status;
            this.argumentTypes = argumentTypes;
        }
    }
}

