/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;

public interface TypeBounds {
    @NotNull
    public Variance getVarianceOfPosition();

    @NotNull
    public TypeParameterDescriptor getTypeVariable();

    @NotNull
    public Collection<Bound> getBounds();

    public boolean isEmpty();

    @Nullable
    public JetType getValue();

    @NotNull
    public Collection<JetType> getValues();

    public static class Bound {
        public final JetType type;
        public final BoundKind kind;
        public final ConstraintPosition position;

        public Bound(@NotNull JetType type, @NotNull BoundKind kind, @NotNull ConstraintPosition position) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBounds$Bound", "<init>"));
            }
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBounds$Bound", "<init>"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/jet/lang/resolve/calls/inference/TypeBounds$Bound", "<init>"));
            }
            this.type = type;
            this.kind = kind;
            this.position = position;
        }
    }

    public static enum BoundKind {
        LOWER_BOUND,
        UPPER_BOUND,
        EXACT_BOUND;

    }
}

