/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.tasks;

import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintPosition;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCallWithTrace;
import org.jetbrains.jet.lang.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class TracingStrategyImpl
implements TracingStrategy {
    private final JetReferenceExpression reference;
    private final Call call;

    private TracingStrategyImpl(@NotNull JetReferenceExpression reference, @NotNull Call call) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "<init>"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "<init>"));
        }
        this.reference = reference;
        this.call = call;
    }

    @NotNull
    public static TracingStrategy create(@NotNull JetReferenceExpression reference, @NotNull Call call) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "create"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "create"));
        }
        TracingStrategyImpl tracingStrategyImpl = new TracingStrategyImpl(reference, call);
        if (tracingStrategyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "create"));
        }
        return tracingStrategyImpl;
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
        DeclarationDescriptor storedReference;
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "bindReference"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "bindReference"));
        }
        Object descriptor = resolvedCall.getCandidateDescriptor();
        if (resolvedCall instanceof VariableAsFunctionResolvedCall) {
            descriptor = ((VariableAsFunctionResolvedCall)resolvedCall).getVariableCall().getCandidateDescriptor();
        }
        if ((storedReference = trace.get(BindingContext.REFERENCE_TARGET, this.reference)) == null || !ErrorUtils.isError(descriptor)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.reference, descriptor);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCallWithTrace<D> resolvedCall) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "bindResolvedCall"));
        }
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "bindResolvedCall"));
        }
        trace.record(BindingContext.RESOLVED_CALL, this.call.getCalleeExpression(), resolvedCall);
        trace.record(BindingContext.CALL, this.call.getCalleeExpression(), this.call);
    }

    @Override
    public <D extends CallableDescriptor> void recordAmbiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> candidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "recordAmbiguity"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "recordAmbiguity"));
        }
        HashSet descriptors = Sets.newHashSet();
        for (ResolvedCallWithTrace<D> candidate : candidates) {
            descriptors.add(candidate.getCandidateDescriptor());
        }
        trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, this.reference, descriptors);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unresolvedReference"));
        }
        trace.report(Errors.UNRESOLVED_REFERENCE.on(this.reference, this.reference));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> candidates) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unresolvedReferenceWrongReceiver"));
        }
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unresolvedReferenceWrongReceiver"));
        }
        trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates));
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "noValueForParameter"));
        }
        if (valueParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "noValueForParameter"));
        }
        JetValueArgumentList valueArgumentList = this.call.getValueArgumentList();
        JetElementImpl reportOn = valueArgumentList != null ? valueArgumentList : this.reference;
        trace.report(Errors.NO_VALUE_FOR_PARAMETER.on(reportOn, valueParameter));
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "missingReceiver"));
        }
        if (expectedReceiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReceiver", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "missingReceiver"));
        }
        trace.report(Errors.MISSING_RECEIVER.on(this.reference, expectedReceiver.getType()));
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "wrongReceiverType"));
        }
        if (receiverParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameter", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "wrongReceiverType"));
        }
        if (receiverArgument2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "wrongReceiverType"));
        }
        if (receiverArgument2 instanceof ExpressionReceiver) {
            ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverArgument2;
            trace.report(Errors.TYPE_MISMATCH.on(expressionReceiver.getExpression(), receiverParameter.getType(), receiverArgument2.getType()));
        } else {
            trace.report(Errors.TYPE_MISMATCH.on(this.reference, receiverParameter.getType(), receiverArgument2.getType()));
        }
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "noReceiverAllowed"));
        }
        trace.report(Errors.NO_RECEIVER_ADMITTED.on(this.reference));
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "wrongNumberOfTypeArguments"));
        }
        JetTypeArgumentList typeArgumentList = this.call.getTypeArgumentList();
        if (typeArgumentList != null) {
            trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList, expectedTypeArgumentCount));
        } else {
            trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(this.reference, expectedTypeArgumentCount));
        }
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "ambiguity"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "ambiguity"));
        }
        trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "noneApplicable"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "noneApplicable"));
        }
        trace.report(Errors.NONE_APPLICABLE.on(this.reference, descriptors));
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallWithTrace<D>> descriptors) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "cannotCompleteResolve"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "cannotCompleteResolve"));
        }
        trace.report(Errors.CANNOT_COMPLETE_RESOLVE.on(this.reference, descriptors));
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "instantiationOfAbstractClass"));
        }
        trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(this.call.getCallElement()));
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull JetType type, boolean isCallForImplicitInvoke) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unsafeCall"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unsafeCall"));
        }
        ASTNode callOperationNode = this.call.getCallOperationNode();
        if (callOperationNode != null && !isCallForImplicitInvoke) {
            trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type));
        } else {
            PsiElement callElement = this.call.getCallElement();
            if (callElement instanceof JetBinaryExpression) {
                JetBinaryExpression binaryExpression = (JetBinaryExpression)callElement;
                JetSimpleNameExpression operationReference = binaryExpression.getOperationReference();
                Name operationString = operationReference.getReferencedNameElementType() == JetTokens.IDENTIFIER ? Name.identifier(operationReference.getText()) : OperatorConventions.getNameForOperationSymbol((JetToken)operationReference.getReferencedNameElementType());
                JetExpression left = binaryExpression.getLeft();
                JetExpression right = binaryExpression.getRight();
                if (left != null && right != null) {
                    trace.report(Errors.UNSAFE_INFIX_CALL.on(this.reference, left.getText(), operationString.asString(), right.getText()));
                }
            } else {
                trace.report(Errors.UNSAFE_CALL.on(this.reference, type));
            }
        }
    }

    @Override
    public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unnecessarySafeCall"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "unnecessarySafeCall"));
        }
        ASTNode callOperationNode = this.call.getCallOperationNode();
        assert (callOperationNode != null);
        trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type));
    }

    @Override
    public void danglingFunctionLiteralArgumentSuspected(@NotNull BindingTrace trace, @NotNull List<JetExpression> functionLiteralArguments) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "danglingFunctionLiteralArgumentSuspected"));
        }
        if (functionLiteralArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteralArguments", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "danglingFunctionLiteralArgumentSuspected"));
        }
        for (JetExpression functionLiteralArgument : functionLiteralArguments) {
            trace.report(Errors.DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED.on(functionLiteralArgument));
        }
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "invisibleMember"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "invisibleMember"));
        }
        trace.report(Errors.INVISIBLE_MEMBER.on(this.call.getCallElement(), descriptor, descriptor.getVisibility(), descriptor.getContainingDeclaration()));
    }

    @Override
    public void typeInferenceFailed(@NotNull BindingTrace trace, @NotNull InferenceErrorData data2) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "typeInferenceFailed"));
        }
        if (data2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/jet/lang/resolve/calls/tasks/TracingStrategyImpl", "typeInferenceFailed"));
        }
        ConstraintSystem constraintSystem = data2.constraintSystem;
        ConstraintSystemStatus status = constraintSystem.getStatus();
        assert (!status.isSuccessful()) : "Report error only for not successful constraint system";
        if (status.hasErrorInConstrainingTypes()) {
            return;
        }
        if (status.hasOnlyErrorsFromPosition(ConstraintPosition.EXPECTED_TYPE_POSITION)) {
            JetType declaredReturnType = data2.descriptor.getReturnType();
            if (declaredReturnType == null) {
                return;
            }
            ConstraintSystem systemWithoutExpectedTypeConstraint = ((ConstraintSystemImpl)constraintSystem).filterConstraintsOut(ConstraintPosition.EXPECTED_TYPE_POSITION);
            JetType substitutedReturnType = systemWithoutExpectedTypeConstraint.getResultingSubstitutor().substitute(declaredReturnType, Variance.INVARIANT);
            assert (substitutedReturnType != null);
            assert (!TypeUtils.noExpectedType(data2.expectedType)) : "Expected type doesn't exist, but there is an expected type mismatch error";
            trace.report(Errors.TYPE_INFERENCE_EXPECTED_TYPE_MISMATCH.on(this.reference, data2.expectedType, substitutedReturnType));
        } else if (status.hasViolatedUpperBound()) {
            trace.report(Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.on(this.reference, data2));
        } else if (status.hasTypeConstructorMismatch()) {
            trace.report(Errors.TYPE_INFERENCE_TYPE_CONSTRUCTOR_MISMATCH.on(this.reference, data2));
        } else if (status.hasConflictingConstraints()) {
            trace.report(Errors.TYPE_INFERENCE_CONFLICTING_SUBSTITUTIONS.on(this.reference, data2));
        } else {
            assert (status.hasUnknownParameters());
            trace.report(Errors.TYPE_INFERENCE_NO_INFORMATION_FOR_PARAMETER.on(this.reference, data2));
        }
    }
}

