/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.structure.impl;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.resolve.java.structure.JavaAnnotation;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMember;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaAnnotationOwnerImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaClassImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementImpl;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaElementUtil;
import org.jetbrains.jet.lang.resolve.java.structure.impl.JavaModifierListOwnerImpl;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class JavaMemberImpl<Psi extends PsiMember>
extends JavaElementImpl<Psi>
implements JavaMember,
JavaAnnotationOwnerImpl,
JavaModifierListOwnerImpl {
    protected JavaMemberImpl(@NotNull Psi psiMember) {
        if (psiMember == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMember", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaMemberImpl", "<init>"));
        }
        super(psiMember);
    }

    @Override
    @NotNull
    public Name getName() {
        String name = ((PsiMember)this.getPsi()).getName();
        assert (name != null) : "Member must have a name: " + this.getPsi();
        Name name2 = Name.identifier(name);
        if (name2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaMemberImpl", "getName"));
        }
        return name2;
    }

    @Override
    @NotNull
    public JavaClass getContainingClass() {
        PsiClass psiClass = ((PsiMember)this.getPsi()).getContainingClass();
        assert (psiClass != null) : "Member must have a containing class: " + this.getPsi();
        JavaClassImpl javaClassImpl = new JavaClassImpl(psiClass);
        if (javaClassImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaMemberImpl", "getContainingClass"));
        }
        return javaClassImpl;
    }

    @Override
    public boolean isAbstract() {
        return JavaElementUtil.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return JavaElementUtil.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return JavaElementUtil.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = JavaElementUtil.getVisibility(this);
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaMemberImpl", "getVisibility"));
        }
        return visibility;
    }

    @Override
    @NotNull
    public Collection<JavaAnnotation> getAnnotations() {
        Collection<JavaAnnotation> collection = JavaElementUtil.getAnnotations(this);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaMemberImpl", "getAnnotations"));
        }
        return collection;
    }

    @Override
    @Nullable
    public JavaAnnotation findAnnotation(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/structure/impl/JavaMemberImpl", "findAnnotation"));
        }
        return JavaElementUtil.findAnnotation(this, fqName);
    }
}

