/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.AbstractJetType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;

public final class JetTypeImpl
extends AbstractJetType {
    private final TypeConstructor constructor;
    private final List<? extends TypeProjection> arguments;
    private final boolean nullable;
    private final JetScope memberScope;
    private final Annotations annotations;

    public JetTypeImpl(Annotations annotations, TypeConstructor constructor, boolean nullable, @NotNull List<? extends TypeProjection> arguments, JetScope memberScope) {
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        this.annotations = annotations;
        if (memberScope instanceof ErrorUtils.ErrorScope) {
            throw new IllegalStateException("JetTypeImpl should not be created for error type: " + memberScope + "\n" + constructor);
        }
        this.constructor = constructor;
        this.nullable = nullable;
        this.arguments = arguments;
        this.memberScope = memberScope;
    }

    public JetTypeImpl(TypeConstructor constructor, JetScope memberScope) {
        this(Annotations.EMPTY, constructor, false, Collections.emptyList(), memberScope);
    }

    public JetTypeImpl(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/lang/types/JetTypeImpl", "<init>"));
        }
        this(Annotations.EMPTY, classDescriptor.getTypeConstructor(), false, Collections.emptyList(), classDescriptor.getMemberScope(Collections.emptyList()));
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations = this.annotations;
        if (annotations == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getAnnotations"));
        }
        return annotations;
    }

    @Override
    @NotNull
    public TypeConstructor getConstructor() {
        TypeConstructor typeConstructor = this.constructor;
        if (typeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getConstructor"));
        }
        return typeConstructor;
    }

    @Override
    @NotNull
    public List<TypeProjection> getArguments() {
        List<TypeProjection> list = this.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getArguments"));
        }
        return list;
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    @Override
    @NotNull
    public JetScope getMemberScope() {
        JetScope jetScope = this.memberScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/JetTypeImpl", "getMemberScope"));
        }
        return jetScope;
    }

    @Override
    public boolean isError() {
        return false;
    }
}

