/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util.slicedmap;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.RemovableSlice;
import org.jetbrains.jet.util.slicedmap.RewritePolicy;
import org.jetbrains.jet.util.slicedmap.SlicedMap;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.SlicedMapKey;
import org.jetbrains.jet.util.slicedmap.WritableSlice;
import org.jetbrains.jet.utils.Printer;

public class TrackingSlicedMap
extends SlicedMapImpl {
    private final Map<ReadOnlySlice<?, ?>, SliceWithStackTrace<?, ?>> sliceTranslationMap = Maps.newHashMap();
    private final boolean trackWithStackTraces;

    public TrackingSlicedMap(boolean trackWithStackTraces) {
        super(Maps.<SlicedMapKey<?, ?>, Object>newLinkedHashMap());
        this.trackWithStackTraces = trackWithStackTraces;
    }

    private <K, V> SliceWithStackTrace<K, V> wrapSlice(ReadOnlySlice<K, V> slice) {
        SliceWithStackTrace<Object, Object> translated = this.sliceTranslationMap.get(slice);
        if (translated == null) {
            translated = new SliceWithStackTrace(slice);
            this.sliceTranslationMap.put(slice, translated);
        }
        return translated;
    }

    @Override
    public <K, V> V get(ReadOnlySlice<K, V> slice, K key) {
        return (V)((TrackableValue)super.get(this.wrapSlice(slice), key)).value;
    }

    @Override
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> slice) {
        return super.getKeys(this.wrapSlice(slice));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<SlicedMapKey<?, ?>, ?>> iterator() {
        HashMap<SlicedMapKey<?, ?>, Object> map = Maps.newHashMap();
        Iterator<Map.Entry<SlicedMapKey<?, ?>, ?>> iterator2 = super.iterator();
        while (iterator2.hasNext()) {
            Map.Entry<SlicedMapKey<?, ?>, ?> entry = iterator2.next();
            map.put(entry.getKey(), ((TrackableValue)entry.getValue()).value);
        }
        Iterator<Map.Entry<SlicedMapKey<?, ?>, ?>> iterator3 = map.entrySet().iterator();
        if (iterator3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/slicedmap/TrackingSlicedMap", "iterator"));
        }
        return iterator3;
    }

    @Override
    public <K, V> void put(WritableSlice<K, V> slice, K key, V value) {
        super.put(this.wrapSlice(slice), key, new TrackableValue(value, this.trackWithStackTraces));
    }

    @Override
    public <K, V> V remove(RemovableSlice<K, V> slice, K key) {
        return (V)((TrackableValue)super.remove(this.wrapSlice(slice), key)).value;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    @NotNull
    public <K, V> ImmutableMap<K, V> getSliceContents(@NotNull ReadOnlySlice<K, V> slice) {
        if (slice == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "slice", "org/jetbrains/jet/util/slicedmap/TrackingSlicedMap", "getSliceContents"));
        }
        ImmutableMap<K, V> immutableMap = super.getSliceContents(slice);
        if (immutableMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/util/slicedmap/TrackingSlicedMap", "getSliceContents"));
        }
        return immutableMap;
    }

    public class SliceWithStackTrace<K, V>
    implements RemovableSlice<K, TrackableValue<V>> {
        private final ReadOnlySlice<K, V> delegate;

        private SliceWithStackTrace(@NotNull ReadOnlySlice<K, V> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/jet/util/slicedmap/TrackingSlicedMap$SliceWithStackTrace", "<init>"));
            }
            this.delegate = delegate;
        }

        @Override
        public SlicedMapKey<K, TrackableValue<V>> makeKey(K key) {
            return this.delegate.makeKey(key);
        }

        @Override
        public TrackableValue<V> computeValue(SlicedMap map, K key, TrackableValue<V> value, boolean valueNotFound) {
            return new TrackableValue(this.delegate.computeValue(map, key, value == null ? null : ((TrackableValue)value).value, valueNotFound), TrackingSlicedMap.this.trackWithStackTraces);
        }

        @Override
        public ReadOnlySlice<K, TrackableValue<V>> makeRawValueVersion() {
            return TrackingSlicedMap.this.wrapSlice(this.delegate.makeRawValueVersion());
        }

        private WritableSlice<K, V> getWritableDelegate() {
            return (WritableSlice)this.delegate;
        }

        @Override
        public boolean isCollective() {
            return this.getWritableDelegate().isCollective();
        }

        @Override
        public RewritePolicy getRewritePolicy() {
            return this.getWritableDelegate().getRewritePolicy();
        }

        @Override
        public void afterPut(MutableSlicedMap map, K key, TrackableValue<V> value) {
            this.getWritableDelegate().afterPut(map, key, ((TrackableValue)value).value);
        }

        @Override
        public boolean check(K key, TrackableValue<V> value) {
            return this.getWritableDelegate().check(key, ((TrackableValue)value).value);
        }
    }

    private static class TrackableValue<V> {
        private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
        private final V value;
        private final StackTraceElement[] stackTrace;
        private final String threadName;

        private TrackableValue(V value, boolean storeStack) {
            this.value = value;
            this.stackTrace = storeStack ? Thread.currentThread().getStackTrace() : EMPTY_STACK_TRACE;
            this.threadName = Thread.currentThread().getName();
        }

        private Appendable printStackTrace(Appendable appendable) {
            StackTraceElement[] trace;
            Printer s = new Printer(appendable);
            s.println(this.value);
            s.println("Thread: " + this.threadName);
            s.println("Written at ");
            for (StackTraceElement aTrace : trace = this.stackTrace) {
                s.println("\tat " + aTrace);
            }
            s.println("---------");
            return appendable;
        }

        public String toString() {
            return this.printStackTrace(new StringBuilder()).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrackableValue other = (TrackableValue)o;
            return !(this.value != null ? !this.value.equals(other.value) : other.value != null);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

