/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.intrinsic.functions.factories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.dart.compiler.backend.js.ast.HasArguments;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsNew;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.k2js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.DescriptorPredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.NamePredicate;
import org.jetbrains.k2js.translate.intrinsic.functions.patterns.PatternBuilder;
import org.jetbrains.k2js.translate.operation.OperatorTable;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class PrimitiveBinaryOperationFIF
extends Enum<PrimitiveBinaryOperationFIF>
implements FunctionIntrinsicFactory {
    public static final /* enum */ PrimitiveBinaryOperationFIF INSTANCE = new PrimitiveBinaryOperationFIF();
    @NotNull
    private static final FunctionIntrinsic RANGE_TO_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic INTEGER_DIVISION_INTRINSIC;
    @NotNull
    private static final NamePredicate BINARY_OPERATIONS;
    private static final DescriptorPredicate PRIMITIVE_NUMBERS_BINARY_OPERATIONS;
    private static final DescriptorPredicate INT_WITH_BIT_OPERATIONS;
    private static final DescriptorPredicate BOOLEAN_OPERATIONS;
    private static final DescriptorPredicate STRING_PLUS;
    private static final ImmutableMap<String, JsBinaryOperator> BINARY_BITWISE_OPERATIONS;
    private static final Predicate<FunctionDescriptor> PREDICATE;
    private static final /* synthetic */ PrimitiveBinaryOperationFIF[] $VALUES;

    public static PrimitiveBinaryOperationFIF[] values() {
        return (PrimitiveBinaryOperationFIF[])$VALUES.clone();
    }

    public static PrimitiveBinaryOperationFIF valueOf(String name) {
        return Enum.valueOf(PrimitiveBinaryOperationFIF.class, name);
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor) {
        JsBinaryOperator op;
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getIntrinsic"));
        }
        if (!PREDICATE.apply(descriptor)) {
            return null;
        }
        if (PatternBuilder.pattern("Int|Byte|Short.div").apply(descriptor)) {
            return INTEGER_DIVISION_INTRINSIC;
        }
        if (descriptor.getName().equals(Name.identifier("rangeTo"))) {
            return RANGE_TO_INTRINSIC;
        }
        if (INT_WITH_BIT_OPERATIONS.apply(descriptor) && (op = BINARY_BITWISE_OPERATIONS.get(descriptor.getName().asString())) != null) {
            return new PrimitiveBinaryOperationFunctionIntrinsic(op);
        }
        JsBinaryOperator operator = PrimitiveBinaryOperationFIF.getOperator(descriptor);
        return new PrimitiveBinaryOperationFunctionIntrinsic(operator);
    }

    @NotNull
    private static JsBinaryOperator getOperator(@NotNull FunctionDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
        }
        JetToken token = (JetToken)OperatorConventions.BINARY_OPERATION_NAMES.inverse().get(descriptor.getName());
        if (token == null) {
            token = (JetToken)OperatorConventions.BOOLEAN_OPERATIONS.inverse().get(descriptor.getName());
        }
        if (token == null) {
            assert (descriptor.getName().asString().equals("xor"));
            JsBinaryOperator jsBinaryOperator = JsBinaryOperator.BIT_XOR;
            if (jsBinaryOperator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
            }
            return jsBinaryOperator;
        }
        JsBinaryOperator jsBinaryOperator = OperatorTable.getBinaryOperator(token);
        if (jsBinaryOperator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF", "getOperator"));
        }
        return jsBinaryOperator;
    }

    static {
        $VALUES = new PrimitiveBinaryOperationFIF[]{INSTANCE};
        RANGE_TO_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression rangeStart, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                if (arguments == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "apply"));
                }
                assert (arguments.size() == 1) : "RangeTo must have one argument.";
                assert (rangeStart != null);
                JsExpression rangeEnd = arguments.get(0);
                JsNameRef expr = new JsNameRef("NumberRange", "Kotlin");
                JsNew numberRangeConstructorInvocation = new JsNew(expr);
                JsAstUtils.setArguments((HasArguments)numberRangeConstructorInvocation, rangeStart, rangeEnd);
                JsNew jsNew = numberRangeConstructorInvocation;
                if (jsNew == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$1", "apply"));
                }
                return jsNew;
            }
        };
        INTEGER_DIVISION_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
                JsBinaryOperation toInt32;
                if (arguments == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "apply"));
                }
                assert (receiver != null);
                assert (arguments.size() == 1);
                JsBinaryOperation div = new JsBinaryOperation(JsBinaryOperator.DIV, receiver, arguments.get(0));
                JsBinaryOperation jsBinaryOperation = toInt32 = new JsBinaryOperation(JsBinaryOperator.BIT_OR, div, context.program().getNumberLiteral(0));
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$2", "apply"));
                }
                return jsBinaryOperation;
            }
        };
        BINARY_OPERATIONS = new NamePredicate(OperatorConventions.BINARY_OPERATION_NAMES.values());
        PRIMITIVE_NUMBERS_BINARY_OPERATIONS = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, BINARY_OPERATIONS);
        INT_WITH_BIT_OPERATIONS = PatternBuilder.pattern("Int.or|and|xor|shl|shr|ushr");
        BOOLEAN_OPERATIONS = PatternBuilder.pattern("Boolean.or|and|xor");
        STRING_PLUS = PatternBuilder.pattern("String.plus");
        BINARY_BITWISE_OPERATIONS = ImmutableMap.builder().put("or", JsBinaryOperator.BIT_OR).put("and", JsBinaryOperator.BIT_AND).put("xor", JsBinaryOperator.BIT_XOR).put("shl", JsBinaryOperator.SHL).put("shr", JsBinaryOperator.SHR).put("ushr", JsBinaryOperator.SHRU).build();
        PREDICATE = Predicates.or(PRIMITIVE_NUMBERS_BINARY_OPERATIONS, BOOLEAN_OPERATIONS, STRING_PLUS, INT_WITH_BIT_OPERATIONS);
    }

    private static class PrimitiveBinaryOperationFunctionIntrinsic
    extends FunctionIntrinsic {
        @NotNull
        private final JsBinaryOperator operator;

        private PrimitiveBinaryOperationFunctionIntrinsic(@NotNull JsBinaryOperator operator) {
            if (operator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "<init>"));
            }
            this.operator = operator;
        }

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments, @NotNull TranslationContext context) {
            if (arguments == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "apply"));
            }
            assert (receiver != null);
            assert (arguments.size() == 1) : "Binary operator should have a receiver and one argument";
            JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(this.operator, receiver, arguments.get(0));
            if (jsBinaryOperation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/intrinsic/functions/factories/PrimitiveBinaryOperationFIF$PrimitiveBinaryOperationFunctionIntrinsic", "apply"));
            }
            return jsBinaryOperation;
        }
    }
}

