/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarVirtualFile;
import com.intellij.openapi.vfs.impl.jar.JarHandlerBase;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarHandler
extends JarHandlerBase {
    private final CoreJarFileSystem myFileSystem;
    private final VirtualFile myRoot;

    public CoreJarHandler(@NotNull CoreJarFileSystem fileSystem, @NotNull String path) {
        if (fileSystem == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "<init>"));
        }
        super(path);
        this.myFileSystem = fileSystem;
        HashMap<JarHandlerBase.EntryInfo, CoreJarVirtualFile> entries = new HashMap<JarHandlerBase.EntryInfo, CoreJarVirtualFile>();
        Map<String, JarHandlerBase.EntryInfo> entriesMap = this.getEntriesMap();
        for (JarHandlerBase.EntryInfo info : entriesMap.values()) {
            this.getOrCreateFile(info, entries);
        }
        JarHandlerBase.EntryInfo rootInfo = this.getEntryInfo("");
        this.myRoot = rootInfo != null ? this.getOrCreateFile(rootInfo, entries) : null;
    }

    @NotNull
    private CoreJarVirtualFile getOrCreateFile(@NotNull JarHandlerBase.EntryInfo info, @NotNull Map<JarHandlerBase.EntryInfo, CoreJarVirtualFile> entries) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        if (entries == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        CoreJarVirtualFile answer = entries.get(info);
        if (answer == null) {
            JarHandlerBase.EntryInfo parentEntry = info.parent;
            answer = new CoreJarVirtualFile(this, info, parentEntry != null ? this.getOrCreateFile(parentEntry, entries) : null);
            entries.put(info, answer);
        }
        CoreJarVirtualFile coreJarVirtualFile = answer;
        if (coreJarVirtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getOrCreateFile"));
        }
        return coreJarVirtualFile;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "findFileByPath"));
        }
        return this.myRoot != null ? this.myRoot.findFileByRelativePath(pathInJar) : null;
    }

    @NotNull
    public CoreJarFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myFileSystem;
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarHandler", "getFileSystem"));
        }
        return coreJarFileSystem;
    }
}

