/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;

public class Queue<T> {
    private Object[] myArray;
    private int myFirst;
    private int myLast;
    private boolean isWrapped;

    public Queue(int initialCapacity) {
        this.myArray = initialCapacity > 0 ? new Object[initialCapacity] : ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public void addLast(T object2) {
        int currentSize = this.size();
        if (currentSize == this.myArray.length) {
            this.myArray = this.normalize(Math.max(currentSize * 2, 5));
            this.myFirst = 0;
            this.myLast = currentSize;
            this.isWrapped = false;
        }
        this.myArray[this.myLast] = object2;
        ++this.myLast;
        if (this.myLast == this.myArray.length) {
            this.isWrapped = !this.isWrapped;
            this.myLast = 0;
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.isWrapped ? this.myArray.length - this.myFirst + this.myLast : this.myLast - this.myFirst;
    }

    public T pullFirst() {
        T result2 = this.peekFirst();
        this.myArray[this.myFirst] = null;
        ++this.myFirst;
        if (this.myFirst == this.myArray.length) {
            this.myFirst = 0;
            this.isWrapped = !this.isWrapped;
        }
        return result2;
    }

    public T peekFirst() {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("queue is empty");
        }
        Object t = this.myArray[this.myFirst];
        return (T)t;
    }

    private int copyFromTo(int first, int last2, Object[] result2, int destinationPos) {
        int length = last2 - first;
        System.arraycopy(this.myArray, first, result2, destinationPos, length);
        return length;
    }

    private T[] normalize(int capacity) {
        Object[] result2 = new Object[capacity];
        if (this.isWrapped) {
            int tailLength = this.copyFromTo(this.myFirst, this.myArray.length, result2, 0);
            this.copyFromTo(0, this.myLast, result2, tailLength);
        } else {
            this.copyFromTo(this.myFirst, this.myLast, result2, 0);
        }
        return result2;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "<empty>";
        }
        List<Object> list = Arrays.asList(this.myArray);
        if (this.isWrapped) {
            return "[[[ " + list.subList(0, this.myLast) + " ||| ... " + list.subList(this.myLast, this.myFirst) + " ... ||| " + list.subList(this.myFirst, this.myArray.length) + " ]]]";
        }
        return "[[[ ... " + list.subList(0, this.myFirst) + " ... ||| " + list.subList(this.myFirst, this.myLast) + " ||| ... " + list.subList(this.myFirst, this.myArray.length) + " ... ]]]";
    }
}

