/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.AnnotationVisitor;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.AsmUtil;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.ClassBuilderOnDemand;
import org.jetbrains.jet.codegen.CodegenUtil;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.JavaSerializerExtension;
import org.jetbrains.jet.codegen.JvmSerializationBindings;
import org.jetbrains.jet.codegen.MemberCodegen;
import org.jetbrains.jet.codegen.PackagePartCodegen;
import org.jetbrains.jet.codegen.ScriptCodegen;
import org.jetbrains.jet.codegen.context.CodegenContext;
import org.jetbrains.jet.codegen.context.FieldOwnerContext;
import org.jetbrains.jet.codegen.context.PackageContext;
import org.jetbrains.jet.codegen.state.GenerationState;
import org.jetbrains.jet.codegen.state.GenerationStateAware;
import org.jetbrains.jet.descriptors.serialization.BitEncoding;
import org.jetbrains.jet.descriptors.serialization.DescriptorSerializer;
import org.jetbrains.jet.descriptors.serialization.NameSerializationUtil;
import org.jetbrains.jet.descriptors.serialization.PackageData;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetScript;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.java.JvmAnnotationNames;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class PackageCodegen
extends GenerationStateAware {
    @NotNull
    private final ClassBuilderOnDemand v;
    @NotNull
    private final FqName name;
    @NotNull
    private final Collection<JetFile> files;
    private final Set<PackageFragmentDescriptor> packageFragments;

    public PackageCodegen(@NotNull ClassBuilderOnDemand v, final @NotNull FqName fqName, @NotNull GenerationState state, @NotNull Collection<JetFile> packageFiles) {
        if (v == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/jet/codegen/PackageCodegen", "<init>"));
        }
        super(state);
        PackageCodegen.checkAllFilesHaveSamePackage(packageFiles);
        this.v = v;
        this.name = fqName;
        this.files = packageFiles;
        this.packageFragments = Sets.newHashSet();
        for (JetFile file : packageFiles) {
            this.packageFragments.add(this.getPackageFragment(file));
        }
        final PsiFile sourceFile = packageFiles.size() == 1 ? packageFiles.iterator().next().getContainingFile() : null;
        v.addOptionalDeclaration(new ClassBuilderOnDemand.ClassBuilderCallback(){

            @Override
            public void doSomething(@NotNull ClassBuilder v) {
                if (v == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "v", "org/jetbrains/jet/codegen/PackageCodegen$1", "doSomething"));
                }
                v.defineClass(sourceFile, 50, 17, JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(fqName)).getInternalName(), null, "java/lang/Object", ArrayUtil.EMPTY_STRING_ARRAY);
                if (sourceFile != null) {
                    v.visitSource(sourceFile.getName(), null);
                }
            }
        });
    }

    public void generate(@NotNull CompilationErrorHandler errorHandler) {
        if (errorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorHandler", "org/jetbrains/jet/codegen/PackageCodegen", "generate"));
        }
        ArrayList<JvmSerializationBindings> bindings = new ArrayList<JvmSerializationBindings>(this.files.size() + 1);
        boolean shouldGeneratePackageClass = PackageCodegen.shouldGeneratePackageClass(this.files);
        if (shouldGeneratePackageClass) {
            bindings.add(this.v.getClassBuilder().getSerializationBindings());
        }
        for (JetFile file : this.files) {
            try {
                ClassBuilder builder = this.generate(file);
                if (builder == null) continue;
                bindings.add(builder.getSerializationBindings());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                VirtualFile vFile = file.getVirtualFile();
                errorHandler.reportException(e, vFile == null ? "no file" : vFile.getUrl());
                DiagnosticUtils.throwIfRunningOnServer(e);
                if (!ApplicationManager.getApplication().isInternal()) continue;
                e.printStackTrace();
            }
        }
        if (shouldGeneratePackageClass) {
            this.writeKotlinPackageAnnotationIfNeeded(JvmSerializationBindings.union(bindings));
        }
        assert (this.v.isActivated() == shouldGeneratePackageClass) : "Different algorithms for generating package class and for heuristics for: " + this.name.asString();
    }

    private void writeKotlinPackageAnnotationIfNeeded(@NotNull JvmSerializationBindings bindings) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/jet/codegen/PackageCodegen", "writeKotlinPackageAnnotationIfNeeded"));
        }
        if (this.state.getClassBuilderMode() != ClassBuilderMode.FULL) {
            return;
        }
        for (JetFile file : this.files) {
            if (!file.isScript()) continue;
            return;
        }
        DescriptorSerializer serializer2 = new DescriptorSerializer(new JavaSerializerExtension(bindings));
        ProtoBuf.Package packageProto = serializer2.packageProto(this.packageFragments).build();
        if (packageProto.getMemberCount() == 0) {
            return;
        }
        PackageData data2 = new PackageData(NameSerializationUtil.createNameResolver(serializer2.getNameTable()), packageProto);
        AnnotationVisitor av = this.v.getClassBuilder().newAnnotation(AsmUtil.asmDescByFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), true);
        av.visit("abiVersion", 15);
        AnnotationVisitor array = av.visitArray("data");
        for (String string : BitEncoding.encodeBytes(data2.toBytes())) {
            array.visit(null, string);
        }
        array.visitEnd();
        av.visitEnd();
    }

    @Nullable
    private ClassBuilder generate(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "generate"));
        }
        boolean generateSrcClass = false;
        Type packagePartType = PackageCodegen.getPackagePartType(PackageClassUtils.getPackageClassFqName(this.name), file.getVirtualFile());
        PackageContext packagePartContext = CodegenContext.STATIC.intoPackagePart(this.getPackageFragment(file), packagePartType);
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (declaration instanceof JetProperty || declaration instanceof JetNamedFunction) {
                generateSrcClass = true;
                continue;
            }
            if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)declaration;
                if (!this.state.getGenerateDeclaredClassFilter().shouldProcess(classOrObject)) continue;
                this.generateClassOrObject(classOrObject);
                continue;
            }
            if (!(declaration instanceof JetScript)) continue;
            ScriptCodegen.createScriptCodegen((JetScript)declaration, this.state, packagePartContext).generate();
        }
        if (!generateSrcClass) {
            return null;
        }
        ClassBuilder builder = this.state.getFactory().forPackagePart(packagePartType, file);
        new PackagePartCodegen(builder, file, packagePartType, packagePartContext, this.state).generate();
        FieldOwnerContext packageFacade = CodegenContext.STATIC.intoPackageFacade(packagePartType, this.getPackageFragment(file));
        MemberCodegen memberCodegen = new MemberCodegen(this.state, null, packageFacade, null){

            @Override
            @NotNull
            public ClassBuilder getBuilder() {
                ClassBuilder classBuilder = PackageCodegen.this.v.getClassBuilder();
                if (classBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen$2", "getBuilder"));
                }
                return classBuilder;
            }
        };
        for (JetDeclaration declaration : file.getDeclarations()) {
            if (!(declaration instanceof JetNamedFunction) && !(declaration instanceof JetProperty)) continue;
            memberCodegen.genFunctionOrProperty(packageFacade, (JetTypeParameterListOwner)declaration, this.v.getClassBuilder());
        }
        return builder;
    }

    @NotNull
    private PackageFragmentDescriptor getPackageFragment(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "getPackageFragment"));
        }
        PackageFragmentDescriptor packageFragment = this.bindingContext.get(BindingContext.FILE_TO_PACKAGE_FRAGMENT, file);
        assert (packageFragment != null) : "package fragment is null for " + file;
        PackageFragmentDescriptor packageFragmentDescriptor = packageFragment;
        if (packageFragmentDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPackageFragment"));
        }
        return packageFragmentDescriptor;
    }

    public void generateClassOrObject(@NotNull JetClassOrObject classOrObject) {
        if (classOrObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classOrObject", "org/jetbrains/jet/codegen/PackageCodegen", "generateClassOrObject"));
        }
        JetFile file = (JetFile)classOrObject.getContainingFile();
        Type packagePartType = PackageCodegen.getPackagePartType(PackageClassUtils.getPackageClassFqName(this.name), file.getVirtualFile());
        PackageContext context = CodegenContext.STATIC.intoPackagePart(this.getPackageFragment(file), packagePartType);
        MemberCodegen.genClassOrObject(context, classOrObject, this.state, null);
    }

    public static boolean shouldGeneratePackageClass(@NotNull Collection<JetFile> packageFiles) {
        if (packageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFiles", "org/jetbrains/jet/codegen/PackageCodegen", "shouldGeneratePackageClass"));
        }
        PackageCodegen.checkAllFilesHaveSamePackage(packageFiles);
        for (JetFile file : packageFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                if (!(declaration instanceof JetProperty) && !(declaration instanceof JetNamedFunction)) continue;
                return true;
            }
        }
        return false;
    }

    private static void checkAllFilesHaveSamePackage(Collection<JetFile> packageFiles) {
        FqName commonFqName = null;
        for (JetFile file : packageFiles) {
            FqName fqName = JetPsiUtil.getFQName(file);
            if (commonFqName != null) {
                if (commonFqName.equals(fqName)) continue;
                throw new IllegalArgumentException("All files should have same package name");
            }
            commonFqName = JetPsiUtil.getFQName(file);
        }
    }

    public void done() {
        this.v.done();
    }

    @NotNull
    public static Type getPackagePartType(@NotNull FqName facadeFqName, @NotNull VirtualFile file) {
        if (facadeFqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeFqName", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartType"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartType"));
        }
        String fileName = FileUtil.getNameWithoutExtension(PathUtil.getFileName(file.getName()));
        String srcName = facadeFqName.shortName().asString() + "-" + PackageCodegen.replaceSpecialSymbols(fileName) + "-" + Integer.toHexString(CodegenUtil.getPathHashCode(file));
        FqName srcFqName = facadeFqName.parent().child(Name.identifier(srcName));
        Type type = AsmUtil.asmTypeByFqNameWithoutInnerClasses(srcFqName);
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartType"));
        }
        return type;
    }

    @NotNull
    private static String replaceSpecialSymbols(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/jet/codegen/PackageCodegen", "replaceSpecialSymbols"));
        }
        String string = str.replace('.', '_');
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "replaceSpecialSymbols"));
        }
        return string;
    }

    @NotNull
    public static String getPackagePartInternalName(@NotNull JetFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartInternalName"));
        }
        FqName packageFqName = JetPsiUtil.getFQName(file);
        String string = PackageCodegen.getPackagePartType(PackageClassUtils.getPackageClassFqName(packageFqName), file.getVirtualFile()).getInternalName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/PackageCodegen", "getPackagePartInternalName"));
        }
        return string;
    }
}

