/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.cfg.Label;
import org.jetbrains.jet.lang.cfg.LoopInfo;
import org.jetbrains.jet.lang.cfg.pseudocode.AbstractJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.ConditionalJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionImpl;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithNext;
import org.jetbrains.jet.lang.cfg.pseudocode.JetElementInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.LocalFunctionDeclarationInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.NondeterministicJumpInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineEnterInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineExitInstruction;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.cfg.pseudocodeTraverser.PseudocodeTraverserPackage;
import org.jetbrains.jet.lang.cfg.pseudocodeTraverser.TraversalOrder;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;

public class PseudocodeImpl
implements Pseudocode {
    private final List<Instruction> mutableInstructionList = new ArrayList<Instruction>();
    private final List<Instruction> instructions = new ArrayList<Instruction>();
    private Pseudocode parent = null;
    private Set<LocalFunctionDeclarationInstruction> localDeclarations = null;
    private final Map<JetElement, Instruction> representativeInstructions = new HashMap<JetElement, Instruction>();
    private final Map<JetExpression, LoopInfo> loopInfo = Maps.newHashMap();
    private final List<PseudocodeLabel> labels = new ArrayList<PseudocodeLabel>();
    private final JetElement correspondingElement;
    private SubroutineExitInstruction exitInstruction;
    private SubroutineSinkInstruction sinkInstruction;
    private SubroutineExitInstruction errorInstruction;
    private boolean postPrecessed = false;

    public PseudocodeImpl(JetElement correspondingElement) {
        this.correspondingElement = correspondingElement;
    }

    @Override
    @NotNull
    public JetElement getCorrespondingElement() {
        JetElement jetElement = this.correspondingElement;
        if (jetElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getCorrespondingElement"));
        }
        return jetElement;
    }

    @Override
    @NotNull
    public Set<LocalFunctionDeclarationInstruction> getLocalDeclarations() {
        if (this.localDeclarations == null) {
            this.localDeclarations = PseudocodeImpl.getLocalDeclarations(this);
        }
        Set<LocalFunctionDeclarationInstruction> set = this.localDeclarations;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getLocalDeclarations"));
        }
        return set;
    }

    @NotNull
    private static Set<LocalFunctionDeclarationInstruction> getLocalDeclarations(@NotNull Pseudocode pseudocode) {
        if (pseudocode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pseudocode", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getLocalDeclarations"));
        }
        LinkedHashSet<LocalFunctionDeclarationInstruction> localDeclarations = Sets.newLinkedHashSet();
        for (Instruction instruction : ((PseudocodeImpl)pseudocode).mutableInstructionList) {
            if (!(instruction instanceof LocalFunctionDeclarationInstruction)) continue;
            localDeclarations.add((LocalFunctionDeclarationInstruction)instruction);
            localDeclarations.addAll(PseudocodeImpl.getLocalDeclarations(((LocalFunctionDeclarationInstruction)instruction).getBody()));
        }
        LinkedHashSet<LocalFunctionDeclarationInstruction> linkedHashSet = localDeclarations;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getLocalDeclarations"));
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public Pseudocode getParent() {
        return this.parent;
    }

    private void setParent(Pseudocode parent) {
        this.parent = parent;
    }

    @NotNull
    public Pseudocode getRootPseudocode() {
        for (Pseudocode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getParent() != null) continue;
            Pseudocode pseudocode = parent;
            if (pseudocode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getRootPseudocode"));
            }
            return pseudocode;
        }
        PseudocodeImpl pseudocodeImpl = this;
        if (pseudocodeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getRootPseudocode"));
        }
        return pseudocodeImpl;
    }

    PseudocodeLabel createLabel(String name) {
        PseudocodeLabel label = new PseudocodeLabel(name);
        this.labels.add(label);
        return label;
    }

    @Override
    @NotNull
    public List<Instruction> getInstructions() {
        List<Instruction> list = this.instructions;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getInstructions"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Instruction> getReversedInstructions() {
        LinkedHashSet<Instruction> traversedInstructions = Sets.newLinkedHashSet();
        PseudocodeTraverserPackage.traverseFollowingInstructions(this.sinkInstruction, traversedInstructions, TraversalOrder.BACKWARD, null);
        if (traversedInstructions.size() < this.instructions.size()) {
            ArrayList<Instruction> simplyReversedInstructions = Lists.newArrayList(this.instructions);
            Collections.reverse(simplyReversedInstructions);
            for (Instruction instruction : simplyReversedInstructions) {
                if (traversedInstructions.contains(instruction)) continue;
                PseudocodeTraverserPackage.traverseFollowingInstructions(instruction, traversedInstructions, TraversalOrder.BACKWARD, null);
            }
        }
        ArrayList<Instruction> arrayList = Lists.newArrayList(traversedInstructions);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getReversedInstructions"));
        }
        return arrayList;
    }

    @NotNull
    public List<Instruction> getAllInstructions() {
        List<Instruction> list = this.mutableInstructionList;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getAllInstructions"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<Instruction> getDeadInstructions() {
        ArrayList<Instruction> deadInstructions = Lists.newArrayList();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!PseudocodeImpl.isDead(instruction)) continue;
            deadInstructions.add(instruction);
        }
        ArrayList<Instruction> arrayList = deadInstructions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getDeadInstructions"));
        }
        return arrayList;
    }

    private static boolean isDead(@NotNull Instruction instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "isDead"));
        }
        if (!((InstructionImpl)instruction).isDead()) {
            return false;
        }
        for (Instruction copy : instruction.getCopies()) {
            if (((InstructionImpl)copy).isDead()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<PseudocodeLabel> getLabels() {
        List<PseudocodeLabel> list = this.labels;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getLabels"));
        }
        return list;
    }

    void addExitInstruction(SubroutineExitInstruction exitInstruction) {
        this.addInstruction(exitInstruction);
        assert (this.exitInstruction == null);
        this.exitInstruction = exitInstruction;
    }

    void addSinkInstruction(SubroutineSinkInstruction sinkInstruction) {
        this.addInstruction(sinkInstruction);
        assert (this.sinkInstruction == null);
        this.sinkInstruction = sinkInstruction;
    }

    void addErrorInstruction(SubroutineExitInstruction errorInstruction) {
        this.addInstruction(errorInstruction);
        assert (this.errorInstruction == null);
        this.errorInstruction = errorInstruction;
    }

    void addInstruction(Instruction instruction) {
        this.mutableInstructionList.add(instruction);
        instruction.setOwner(this);
        if (instruction instanceof JetElementInstruction) {
            JetElementInstruction elementInstruction = (JetElementInstruction)instruction;
            this.representativeInstructions.put(elementInstruction.getElement(), instruction);
        }
    }

    void recordLoopInfo(JetExpression expression, LoopInfo blockInfo) {
        this.loopInfo.put(expression, blockInfo);
    }

    @Override
    @NotNull
    public SubroutineExitInstruction getExitInstruction() {
        SubroutineExitInstruction subroutineExitInstruction = this.exitInstruction;
        if (subroutineExitInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getExitInstruction"));
        }
        return subroutineExitInstruction;
    }

    @Override
    @NotNull
    public SubroutineSinkInstruction getSinkInstruction() {
        SubroutineSinkInstruction subroutineSinkInstruction = this.sinkInstruction;
        if (subroutineSinkInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getSinkInstruction"));
        }
        return subroutineSinkInstruction;
    }

    @Override
    @NotNull
    public SubroutineEnterInstruction getEnterInstruction() {
        SubroutineEnterInstruction subroutineEnterInstruction = (SubroutineEnterInstruction)this.mutableInstructionList.get(0);
        if (subroutineEnterInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getEnterInstruction"));
        }
        return subroutineEnterInstruction;
    }

    void bindLabel(Label label) {
        ((PseudocodeLabel)label).setTargetInstructionIndex(this.mutableInstructionList.size());
    }

    public void postProcess() {
        if (this.postPrecessed) {
            return;
        }
        this.postPrecessed = true;
        this.errorInstruction.setSink(this.getSinkInstruction());
        this.exitInstruction.setSink(this.getSinkInstruction());
        int index = 0;
        for (Instruction instruction : this.mutableInstructionList) {
            this.processInstruction(instruction, index);
            ++index;
        }
        if (this.getParent() != null) {
            return;
        }
        this.collectAndCacheReachableInstructions();
        for (LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction : this.getLocalDeclarations()) {
            ((PseudocodeImpl)localFunctionDeclarationInstruction.getBody()).collectAndCacheReachableInstructions();
        }
    }

    private void collectAndCacheReachableInstructions() {
        Set<Instruction> reachableInstructions = this.collectReachableInstructions();
        for (Instruction instruction : this.mutableInstructionList) {
            if (!reachableInstructions.contains(instruction)) continue;
            this.instructions.add(instruction);
        }
        this.markDeadInstructions();
    }

    private void processInstruction(Instruction instruction, final int currentPosition) {
        instruction.accept(new InstructionVisitor(){

            @Override
            public void visitInstructionWithNext(InstructionWithNext instruction) {
                instruction.setNext(PseudocodeImpl.this.getNextPosition(currentPosition));
            }

            @Override
            public void visitJump(AbstractJumpInstruction instruction) {
                instruction.setResolvedTarget(PseudocodeImpl.this.getJumpTarget(instruction.getTargetLabel()));
            }

            @Override
            public void visitNondeterministicJump(NondeterministicJumpInstruction instruction) {
                instruction.setNext(PseudocodeImpl.this.getNextPosition(currentPosition));
                List<Label> targetLabels = instruction.getTargetLabels();
                for (Label targetLabel : targetLabels) {
                    instruction.setResolvedTarget(targetLabel, PseudocodeImpl.this.getJumpTarget(targetLabel));
                }
            }

            @Override
            public void visitConditionalJump(ConditionalJumpInstruction instruction) {
                Instruction nextInstruction = PseudocodeImpl.this.getNextPosition(currentPosition);
                Instruction jumpTarget = PseudocodeImpl.this.getJumpTarget(instruction.getTargetLabel());
                if (instruction.onTrue()) {
                    instruction.setNextOnFalse(nextInstruction);
                    instruction.setNextOnTrue(jumpTarget);
                } else {
                    instruction.setNextOnFalse(jumpTarget);
                    instruction.setNextOnTrue(nextInstruction);
                }
                this.visitJump(instruction);
            }

            @Override
            public void visitLocalFunctionDeclarationInstruction(LocalFunctionDeclarationInstruction instruction) {
                PseudocodeImpl body = (PseudocodeImpl)instruction.getBody();
                body.setParent(PseudocodeImpl.this);
                body.postProcess();
                instruction.setNext(PseudocodeImpl.this.getSinkInstruction());
            }

            @Override
            public void visitSubroutineExit(SubroutineExitInstruction instruction) {
            }

            @Override
            public void visitSubroutineSink(SubroutineSinkInstruction instruction) {
            }

            @Override
            public void visitInstruction(Instruction instruction) {
                throw new UnsupportedOperationException(instruction.toString());
            }
        });
    }

    private Set<Instruction> collectReachableInstructions() {
        HashSet<Instruction> visited = Sets.newHashSet();
        PseudocodeTraverserPackage.traverseFollowingInstructions(this.getEnterInstruction(), visited, TraversalOrder.FORWARD, null);
        if (!visited.contains(this.getExitInstruction())) {
            visited.add(this.getExitInstruction());
        }
        if (!visited.contains(this.errorInstruction)) {
            visited.add(this.errorInstruction);
        }
        if (!visited.contains(this.getSinkInstruction())) {
            visited.add(this.getSinkInstruction());
        }
        return visited;
    }

    private void markDeadInstructions() {
        HashSet<Instruction> instructionSet = Sets.newHashSet(this.instructions);
        for (Instruction instruction : this.mutableInstructionList) {
            if (instructionSet.contains(instruction)) continue;
            ((InstructionImpl)instruction).die();
            for (Instruction nextInstruction : instruction.getNextInstructions()) {
                nextInstruction.getPreviousInstructions().remove(instruction);
            }
        }
    }

    @NotNull
    private Instruction getJumpTarget(@NotNull Label targetLabel) {
        if (targetLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetLabel", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getJumpTarget"));
        }
        Instruction instruction = ((PseudocodeLabel)targetLabel).resolveToInstruction();
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getJumpTarget"));
        }
        return instruction;
    }

    @NotNull
    private Instruction getNextPosition(int currentPosition) {
        int targetPosition = currentPosition + 1;
        assert (targetPosition < this.mutableInstructionList.size()) : currentPosition;
        Instruction instruction = this.mutableInstructionList.get(targetPosition);
        if (instruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "getNextPosition"));
        }
        return instruction;
    }

    public void repeatPart(@NotNull Label startLabel, @NotNull Label finishLabel) {
        if (startLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLabel", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "repeatPart"));
        }
        if (finishLabel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishLabel", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "repeatPart"));
        }
        Integer startIndex = ((PseudocodeLabel)startLabel).getTargetInstructionIndex();
        assert (startIndex != null);
        Integer finishIndex = ((PseudocodeLabel)finishLabel).getTargetInstructionIndex();
        assert (finishIndex != null);
        HashMap<Label, Label> originalToCopy = Maps.newHashMap();
        HashMultimap<Instruction, Label> originalLabelsForInstruction = HashMultimap.create();
        for (PseudocodeLabel label : this.labels) {
            Integer index = label.getTargetInstructionIndex();
            if (index == null || label == startLabel || label == finishLabel || startIndex > index || index > finishIndex) continue;
            originalToCopy.put(label, label.copy());
            originalLabelsForInstruction.put(this.getJumpTarget(label), label);
        }
        for (int index = startIndex.intValue(); index < finishIndex; ++index) {
            Instruction originalInstruction = this.mutableInstructionList.get(index);
            this.repeatLabelsBindingForInstruction(originalInstruction, originalToCopy, originalLabelsForInstruction);
            this.addInstruction(this.copyInstruction(originalInstruction, originalToCopy));
        }
        this.repeatLabelsBindingForInstruction(this.mutableInstructionList.get(finishIndex), originalToCopy, originalLabelsForInstruction);
    }

    private void repeatLabelsBindingForInstruction(@NotNull Instruction originalInstruction, @NotNull Map<Label, Label> originalToCopy, @NotNull Multimap<Instruction, Label> originalLabelsForInstruction) {
        if (originalInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalInstruction", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "repeatLabelsBindingForInstruction"));
        }
        if (originalToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToCopy", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "repeatLabelsBindingForInstruction"));
        }
        if (originalLabelsForInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalLabelsForInstruction", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "repeatLabelsBindingForInstruction"));
        }
        for (Label originalLabel : originalLabelsForInstruction.get(originalInstruction)) {
            this.bindLabel(originalToCopy.get(originalLabel));
        }
    }

    private Instruction copyInstruction(@NotNull Instruction instruction, @NotNull Map<Label, Label> originalToCopy) {
        Label originalTarget;
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "copyInstruction"));
        }
        if (originalToCopy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalToCopy", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "copyInstruction"));
        }
        if (instruction instanceof AbstractJumpInstruction && originalToCopy.containsKey(originalTarget = ((AbstractJumpInstruction)instruction).getTargetLabel())) {
            return ((AbstractJumpInstruction)instruction).copy(originalToCopy.get(originalTarget));
        }
        if (instruction instanceof NondeterministicJumpInstruction) {
            List<Label> originalTargets = ((NondeterministicJumpInstruction)instruction).getTargetLabels();
            List<Label> copyTargets = this.copyLabels(originalTargets, originalToCopy);
            return ((NondeterministicJumpInstruction)instruction).copy(copyTargets);
        }
        return ((InstructionImpl)instruction).copy();
    }

    @NotNull
    private List<Label> copyLabels(Collection<Label> labels, Map<Label, Label> originalToCopy) {
        ArrayList<Label> newLabels = Lists.newArrayList();
        for (Label label : labels) {
            Label newLabel = originalToCopy.get(label);
            newLabels.add(newLabel != null ? newLabel : label);
        }
        ArrayList<Label> arrayList = newLabels;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/PseudocodeImpl", "copyLabels"));
        }
        return arrayList;
    }

    public class PseudocodeLabel
    implements Label {
        private final String name;
        private Integer targetInstructionIndex;

        private PseudocodeLabel(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Integer getTargetInstructionIndex() {
            return this.targetInstructionIndex;
        }

        public void setTargetInstructionIndex(int targetInstructionIndex) {
            this.targetInstructionIndex = targetInstructionIndex;
        }

        public Instruction resolveToInstruction() {
            assert (this.targetInstructionIndex != null);
            return (Instruction)PseudocodeImpl.this.mutableInstructionList.get(this.targetInstructionIndex);
        }

        public Label copy() {
            return new PseudocodeLabel("copy " + this.name);
        }
    }
}

