/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.IfNotParsed;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetExpressionImpl;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class JetQualifiedExpression
extends JetExpressionImpl {
    public JetQualifiedExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetQualifiedExpression", "<init>"));
        }
        super(node);
    }

    @NotNull
    public JetExpression getReceiverExpression() {
        JetExpression left = this.findChildByClass(JetExpression.class);
        assert (left != null);
        JetExpression jetExpression = left;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetQualifiedExpression", "getReceiverExpression"));
        }
        return jetExpression;
    }

    @IfNotParsed
    @Nullable
    public JetExpression getSelectorExpression() {
        for (ASTNode node = this.getOperationTokenNode(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof JetExpression)) continue;
            return (JetExpression)psi;
        }
        return null;
    }

    @NotNull
    public ASTNode getOperationTokenNode() {
        ASTNode operationNode = this.getNode().findChildByType(JetTokens.OPERATIONS);
        assert (operationNode != null);
        ASTNode aSTNode = operationNode;
        if (aSTNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetQualifiedExpression", "getOperationTokenNode"));
        }
        return aSTNode;
    }

    @NotNull
    public JetToken getOperationSign() {
        JetToken jetToken = (JetToken)this.getOperationTokenNode().getElementType();
        if (jetToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/JetQualifiedExpression", "getOperationSign"));
        }
        return jetToken;
    }
}

