/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi.stubs.impl;

import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFunctionStub;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class PsiJetFunctionStubImpl
extends StubBase<JetNamedFunction>
implements PsiJetFunctionStub {
    private final StringRef nameRef;
    private final boolean isTopLevel;
    private final boolean isExtension;
    private final FqName topFQName;

    public PsiJetFunctionStubImpl(@NotNull IStubElementType elementType, @NotNull StubElement parent, @Nullable String name, boolean isTopLevel, @Nullable FqName topFQName, boolean isExtension) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFunctionStubImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFunctionStubImpl", "<init>"));
        }
        this(elementType, parent, StringRef.fromString(name), isTopLevel, topFQName, isExtension);
    }

    public PsiJetFunctionStubImpl(@NotNull IStubElementType elementType, @NotNull StubElement parent, @Nullable StringRef nameRef, boolean isTopLevel, @Nullable FqName topFQName, boolean isExtension) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFunctionStubImpl", "<init>"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFunctionStubImpl", "<init>"));
        }
        super(parent, elementType);
        if (isTopLevel && topFQName == null) {
            throw new IllegalArgumentException("topFQName shouldn't be null for top level functions");
        }
        this.nameRef = nameRef;
        this.topFQName = topFQName;
        this.isTopLevel = isTopLevel;
        this.isExtension = isExtension;
    }

    @Override
    public String getName() {
        return StringRef.toString(this.nameRef);
    }

    @Override
    @Nullable
    public FqName getTopFQName() {
        return this.topFQName;
    }

    @Override
    public boolean isTopLevel() {
        return this.isTopLevel;
    }

    @Override
    public boolean isExtension() {
        return this.isExtension;
    }

    @Override
    @NotNull
    public String[] getAnnotations() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/psi/stubs/impl/PsiJetFunctionStubImpl", "getAnnotations"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PsiJetFunctionStubImpl[");
        if (this.isTopLevel()) {
            assert (this.topFQName != null);
            builder.append("top ").append("topFQName=").append(this.topFQName.toString()).append(" ");
        }
        if (this.isExtension()) {
            builder.append("ext ");
        }
        builder.append("name=").append(this.getName());
        builder.append("]");
        return builder.toString();
    }
}

