/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.model;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public abstract class DelegatingResolvedCall<D extends CallableDescriptor>
implements ResolvedCall<D> {
    private final ResolvedCall<? extends D> resolvedCall;

    public DelegatingResolvedCall(@NotNull ResolvedCall<? extends D> resolvedCall) {
        if (resolvedCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCall", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "<init>"));
        }
        this.resolvedCall = resolvedCall;
    }

    @Override
    @NotNull
    public Call getCall() {
        Call call = this.resolvedCall.getCall();
        if (call == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getCall"));
        }
        return call;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        D d = this.resolvedCall.getCandidateDescriptor();
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getCandidateDescriptor"));
        }
        return d;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.resolvedCall.getResultingDescriptor();
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getResultingDescriptor"));
        }
        return d;
    }

    @Override
    @NotNull
    public ReceiverValue getReceiverArgument() {
        ReceiverValue receiverValue = this.resolvedCall.getReceiverArgument();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getReceiverArgument"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ReceiverValue getThisObject() {
        ReceiverValue receiverValue = this.resolvedCall.getThisObject();
        if (receiverValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getThisObject"));
        }
        return receiverValue;
    }

    @Override
    @NotNull
    public ExplicitReceiverKind getExplicitReceiverKind() {
        ExplicitReceiverKind explicitReceiverKind = this.resolvedCall.getExplicitReceiverKind();
        if (explicitReceiverKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getExplicitReceiverKind"));
        }
        return explicitReceiverKind;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = this.resolvedCall.getValueArguments();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getValueArguments"));
        }
        return map;
    }

    @Override
    @Nullable
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        return this.resolvedCall.getValueArgumentsByIndex();
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        Map<TypeParameterDescriptor, JetType> map = this.resolvedCall.getTypeArguments();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getTypeArguments"));
        }
        return map;
    }

    @Override
    @NotNull
    public DataFlowInfoForArguments getDataFlowInfoForArguments() {
        DataFlowInfoForArguments dataFlowInfoForArguments = this.resolvedCall.getDataFlowInfoForArguments();
        if (dataFlowInfoForArguments == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/calls/model/DelegatingResolvedCall", "getDataFlowInfoForArguments"));
        }
        return dataFlowInfoForArguments;
    }

    @Override
    public boolean isSafeCall() {
        return this.resolvedCall.isSafeCall();
    }
}

