/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.DiagnosticFactory1;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.model.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ForLoopConventionsChecker {
    private Project project;
    private ExpressionTypingServices expressionTypingServices;
    private ExpressionTypingUtils expressionTypingUtils;

    public void setProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "setProject"));
        }
        this.project = project;
    }

    public void setExpressionTypingUtils(@NotNull ExpressionTypingUtils expressionTypingUtils) {
        if (expressionTypingUtils == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingUtils", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "setExpressionTypingUtils"));
        }
        this.expressionTypingUtils = expressionTypingUtils;
    }

    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    public boolean isVariableIterable(@NotNull VariableDescriptor variableDescriptor, @NotNull JetScope scope) {
        ExpressionTypingContext context;
        if (variableDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDescriptor", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "isVariableIterable"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "isVariableIterable"));
        }
        JetExpression expression = JetPsiFactory.createExpression(this.project, "fake");
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, variableDescriptor.getType());
        return this.checkIterableConvention(expressionReceiver, context = ExpressionTypingContext.newContext(this.expressionTypingServices, new BindingTraceContext(), scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE)) != null;
    }

    @Nullable
    JetType checkIterableConvention(@NotNull ExpressionReceiver loopRange, ExpressionTypingContext context) {
        if (loopRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRange", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkIterableConvention"));
        }
        JetExpression loopRangeExpression = loopRange.getExpression();
        Name iterator2 = Name.identifier("iterator");
        Pair<Call, OverloadResolutionResults<FunctionDescriptor>> calls = this.expressionTypingUtils.makeAndResolveFakeCall(loopRange, context, Collections.<JetExpression>emptyList(), iterator2);
        Call iteratorCall = calls.getFirst();
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResults = calls.getSecond();
        if (iteratorResolutionResults.isSuccess()) {
            ResolvedCall<FunctionDescriptor> iteratorResolvedCall = iteratorResolutionResults.getResultingCall();
            context.trace.record(BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL, loopRangeExpression, iteratorResolvedCall);
            context.trace.record(BindingContext.LOOP_RANGE_ITERATOR_CALL, loopRangeExpression, iteratorCall);
            FunctionDescriptor iteratorFunction = iteratorResolvedCall.getResultingDescriptor();
            JetType iteratorType = iteratorFunction.getReturnType();
            JetType hasNextType = this.checkConventionForIterator(context, loopRangeExpression, iteratorType, "hasNext", Errors.HAS_NEXT_FUNCTION_AMBIGUITY, Errors.HAS_NEXT_MISSING, Errors.HAS_NEXT_FUNCTION_NONE_APPLICABLE, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
            if (hasNextType != null && !ExpressionTypingUtils.isBoolean(hasNextType)) {
                context.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRangeExpression, hasNextType));
            }
            return this.checkConventionForIterator(context, loopRangeExpression, iteratorType, "next", Errors.NEXT_AMBIGUITY, Errors.NEXT_MISSING, Errors.NEXT_NONE_APPLICABLE, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
        }
        if (iteratorResolutionResults.isAmbiguity()) {
            context.trace.report(Errors.ITERATOR_AMBIGUITY.on(loopRangeExpression, iteratorResolutionResults.getResultingCalls()));
        } else {
            context.trace.report(Errors.ITERATOR_MISSING.on(loopRangeExpression));
        }
        return null;
    }

    @Nullable
    private JetType checkConventionForIterator(@NotNull ExpressionTypingContext context, @NotNull JetExpression loopRangeExpression, @NotNull JetType iteratorType, @NotNull String name, @NotNull DiagnosticFactory1<JetExpression, JetType> ambiguity, @NotNull DiagnosticFactory1<JetExpression, JetType> missing, @NotNull DiagnosticFactory1<JetExpression, JetType> noneApplicable, @NotNull WritableSlice<JetExpression, ResolvedCall<FunctionDescriptor>> resolvedCallKey) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (loopRangeExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "loopRangeExpression", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (iteratorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iteratorType", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (ambiguity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ambiguity", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (missing == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missing", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (noneApplicable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "noneApplicable", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        if (resolvedCallKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolvedCallKey", "org/jetbrains/jet/lang/types/expressions/ForLoopConventionsChecker", "checkConventionForIterator"));
        }
        OverloadResolutionResults<FunctionDescriptor> nextResolutionResults = this.expressionTypingUtils.resolveFakeCall(context, new TransientReceiver(iteratorType), Name.identifier(name));
        if (nextResolutionResults.isAmbiguity()) {
            context.trace.report(ambiguity.on(loopRangeExpression, iteratorType));
        } else if (nextResolutionResults.isNothing()) {
            context.trace.report(missing.on(loopRangeExpression, iteratorType));
        } else if (!nextResolutionResults.isSuccess()) {
            context.trace.report(noneApplicable.on(loopRangeExpression, iteratorType));
        } else {
            assert (nextResolutionResults.isSuccess());
            ResolvedCall<FunctionDescriptor> resolvedCall = nextResolutionResults.getResultingCall();
            context.trace.record(resolvedCallKey, loopRangeExpression, resolvedCall);
            return resolvedCall.getResultingDescriptor().getReturnType();
        }
        return null;
    }
}

