/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.ref;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ref.JetTypeNameParser;

public class JetTypeName {
    private final FqName className;
    private final List<JetTypeName> arguments;

    public JetTypeName(@NotNull FqName className, @NotNull List<JetTypeName> arguments) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/lang/types/ref/JetTypeName", "<init>"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/jet/lang/types/ref/JetTypeName", "<init>"));
        }
        this.className = className;
        this.arguments = arguments;
    }

    @NotNull
    public FqName getClassName() {
        FqName fqName = this.className;
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeName", "getClassName"));
        }
        return fqName;
    }

    @NotNull
    public List<JetTypeName> getArguments() {
        List<JetTypeName> list = this.arguments;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeName", "getArguments"));
        }
        return list;
    }

    @NotNull
    public static JetTypeName fromJavaClass(@NotNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/jet/lang/types/ref/JetTypeName", "fromJavaClass"));
        }
        if (clazz.getTypeParameters().length != 0) {
            throw new IllegalArgumentException("cannot create type reference: actual type parameters unknown: " + clazz);
        }
        FqName fqName = new FqName(clazz.getName());
        JetTypeName jetTypeName = JetTypeName.withoutParameters(fqName);
        if (jetTypeName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeName", "fromJavaClass"));
        }
        return jetTypeName;
    }

    @NotNull
    public static JetTypeName withoutParameters(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/types/ref/JetTypeName", "withoutParameters"));
        }
        JetTypeName jetTypeName = new JetTypeName(fqName, Collections.<JetTypeName>emptyList());
        if (jetTypeName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeName", "withoutParameters"));
        }
        return jetTypeName;
    }

    @NotNull
    public static JetTypeName parse(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jet/lang/types/ref/JetTypeName", "parse"));
        }
        JetTypeName jetTypeName = JetTypeNameParser.parse(value);
        if (jetTypeName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/types/ref/JetTypeName", "parse"));
        }
        return jetTypeName;
    }
}

