/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class TypeParameterExtendsBoundsListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.TypeParameterExtendsBoundsListElement");

    public TypeParameterExtendsBoundsListElement() {
        super(JavaElementType.EXTENDS_BOUND_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last2, ASTNode anchor, Boolean before) {
        if (first == last2 && first.getElementType() == JAVA_CODE_REFERENCE && this.getLastChildNode() != null && this.getLastChildNode().getElementType() == ERROR_ELEMENT) {
            super.deleteChildInternal(this.getLastChildNode());
        }
        TreeElement firstAdded = super.addInternal(first, last2, anchor, before);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (first == last2 && first.getElementType() == JAVA_CODE_REFERENCE) {
            LeafElement comma;
            ASTNode child;
            TreeElement element = first;
            for (child = element.getTreeNext(); child != null && child.getElementType() != AND; child = child.getTreeNext()) {
                if (child.getElementType() != JAVA_CODE_REFERENCE) continue;
                comma = Factory.createSingleLeafElement(AND, "&", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, element, Boolean.FALSE);
                break;
            }
            for (child = element.getTreePrev(); child != null && child.getElementType() != AND; child = child.getTreePrev()) {
                if (child.getElementType() != JAVA_CODE_REFERENCE) continue;
                comma = Factory.createSingleLeafElement(AND, "&", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        IElementType keywordType = JavaTokenType.EXTENDS_KEYWORD;
        String keywordText = "extends";
        if (this.findChildByType(keywordType) == null && this.findChildByType(JAVA_CODE_REFERENCE) != null) {
            LeafElement keyword = Factory.createSingleLeafElement(keywordType, "extends", treeCharTab, this.getManager());
            super.addInternal(keyword, keyword, this.getFirstChildNode(), Boolean.TRUE);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/TypeParameterExtendsBoundsListElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JAVA_CODE_REFERENCE) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == AND) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && (prev.getElementType() == AND || prev.getElementType() == EXTENDS_KEYWORD)) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType elType = child.getElementType();
        if (elType == AND) {
            return 123;
        }
        if (elType == JavaElementType.JAVA_CODE_REFERENCE) {
            return 78;
        }
        if (elType == JavaTokenType.EXTENDS_KEYWORD) {
            return 26;
        }
        return 0;
    }
}

