/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.inline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.inline.CapturedParamDesc;
import org.jetbrains.jet.codegen.inline.CapturedParamInfo;
import org.jetbrains.jet.codegen.inline.CapturedParamOwner;
import org.jetbrains.jet.codegen.inline.ParameterInfo;
import org.jetbrains.jet.codegen.inline.Parameters;

public class ParametersBuilder {
    private final List<ParameterInfo> params = new ArrayList<ParameterInfo>();
    private final List<CapturedParamInfo> capturedParams = new ArrayList<CapturedParamInfo>();
    private int nextIndex = 0;
    private int nextCaptured = 0;

    public static ParametersBuilder newBuilder() {
        return new ParametersBuilder();
    }

    public ParameterInfo addThis(Type type, boolean skipped) {
        ParameterInfo info = new ParameterInfo(type, skipped, this.nextIndex, -1);
        this.addParameter(info);
        return info;
    }

    @NotNull
    public ParametersBuilder addNextParameter(@NotNull Type type, boolean skipped, @Nullable ParameterInfo original) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addNextParameter"));
        }
        this.addParameter(new ParameterInfo(type, skipped, this.nextIndex, original != null ? original.getIndex() : -1));
        ParametersBuilder parametersBuilder = this;
        if (parametersBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addNextParameter"));
        }
        return parametersBuilder;
    }

    @NotNull
    public CapturedParamInfo addCapturedParam(@NotNull CapturedParamInfo original, @NotNull String newFieldName) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (newFieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFieldName", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        CapturedParamInfo info = new CapturedParamInfo(original.desc, newFieldName, original.isSkipped, this.nextCaptured, original.getIndex());
        info.setLambda(original.getLambda());
        CapturedParamInfo capturedParamInfo = this.addCapturedParameter(info);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        return capturedParamInfo;
    }

    @NotNull
    public CapturedParamInfo addCapturedParam(@NotNull String fieldName, @NotNull Type type, boolean skipped, @Nullable ParameterInfo original, @NotNull CapturedParamOwner containingLambda) {
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        if (containingLambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingLambda", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        CapturedParamInfo info = new CapturedParamInfo(CapturedParamDesc.createDesc(containingLambda, fieldName, type), skipped, this.nextCaptured, original != null ? original.getIndex() : -1);
        if (original != null) {
            info.setLambda(original.getLambda());
        }
        CapturedParamInfo capturedParamInfo = this.addCapturedParameter(info);
        if (capturedParamInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/codegen/inline/ParametersBuilder", "addCapturedParam"));
        }
        return capturedParamInfo;
    }

    private void addParameter(ParameterInfo info) {
        this.params.add(info);
        this.nextIndex += info.getType().getSize();
    }

    private CapturedParamInfo addCapturedParameter(CapturedParamInfo info) {
        this.capturedParams.add(info);
        this.nextCaptured += info.getType().getSize();
        return info;
    }

    public List<ParameterInfo> build() {
        return Collections.unmodifiableList(this.params);
    }

    public List<CapturedParamInfo> buildCaptured() {
        return Collections.unmodifiableList(this.capturedParams);
    }

    public List<ParameterInfo> buildWithStubs() {
        return Parameters.addStubs(this.build());
    }

    public List<CapturedParamInfo> buildCapturedWithStubs() {
        return Parameters.shiftAndAddStubs(this.buildCaptured(), this.nextIndex);
    }

    public Parameters buildParameters() {
        return new Parameters(this.buildWithStubs(), this.buildCapturedWithStubs());
    }
}

