/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.descriptors.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.impl.AbstractReceiverParameterDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.jet.lang.types.JetType;

public class LazyClassReceiverParameterDescriptor
extends AbstractReceiverParameterDescriptor {
    private final ClassDescriptor descriptor;
    private final ClassReceiver receiverValue;

    public LazyClassReceiverParameterDescriptor(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/descriptors/impl/LazyClassReceiverParameterDescriptor", "<init>"));
        }
        this.descriptor = descriptor;
        this.receiverValue = new ClassReceiver(descriptor);
    }

    @Override
    @NotNull
    public JetType getType() {
        JetType jetType = this.descriptor.getDefaultType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazyClassReceiverParameterDescriptor", "getType"));
        }
        return jetType;
    }

    @Override
    @NotNull
    public ReceiverValue getValue() {
        ClassReceiver classReceiver = this.receiverValue;
        if (classReceiver == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazyClassReceiverParameterDescriptor", "getValue"));
        }
        return classReceiver;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        ClassDescriptor classDescriptor = this.descriptor;
        if (classDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/descriptors/impl/LazyClassReceiverParameterDescriptor", "getContainingDeclaration"));
        }
        return classDescriptor;
    }

    @Override
    public String toString() {
        return "class " + this.descriptor.getName() + "::this";
    }
}

