/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.diagnostics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.diagnostics.PositioningStrategy;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassInitializer;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetModifierListOwner;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetWhenConditionInRange;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lexer.JetKeywordToken;
import org.jetbrains.jet.lexer.JetTokens;

public class PositioningStrategies {
    public static final PositioningStrategy<PsiElement> DEFAULT = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$1", "mark"));
            }
            if (element instanceof JetObjectLiteralExpression) {
                JetObjectDeclaration objectDeclaration = ((JetObjectLiteralExpression)element).getObjectDeclaration();
                PsiElement objectKeyword = objectDeclaration.getObjectKeyword();
                JetDelegationSpecifierList delegationSpecifierList = objectDeclaration.getDelegationSpecifierList();
                if (delegationSpecifierList == null) {
                    List<TextRange> list = 1.markElement(objectKeyword);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$1", "mark"));
                    }
                    return list;
                }
                List<TextRange> list = 1.markRange(objectKeyword.getTextRange().union(delegationSpecifierList.getTextRange()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$1", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$1", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetDeclaration> DECLARATION_RETURN_TYPE = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$2", "mark"));
            }
            List<TextRange> list = 2.markElement(this.getElementToMark(declaration));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$2", "mark"));
            }
            return list;
        }

        @Override
        public boolean isValid(@NotNull JetDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$2", "isValid"));
            }
            return !2.hasSyntaxErrors(this.getElementToMark(declaration));
        }

        private PsiElement getElementToMark(@NotNull JetDeclaration declaration) {
            if (declaration == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$2", "getElementToMark"));
            }
            JetTypeReference returnTypeRef = null;
            PsiElement nameIdentifierOrPlaceholder = null;
            if (declaration instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)declaration;
                returnTypeRef = function.getReturnTypeRef();
                nameIdentifierOrPlaceholder = function.getNameIdentifier();
            } else if (declaration instanceof JetProperty) {
                JetProperty property2 = (JetProperty)declaration;
                returnTypeRef = property2.getTypeRef();
                nameIdentifierOrPlaceholder = property2.getNameIdentifier();
            } else if (declaration instanceof JetPropertyAccessor) {
                JetPropertyAccessor accessor = (JetPropertyAccessor)declaration;
                returnTypeRef = accessor.getReturnTypeReference();
                nameIdentifierOrPlaceholder = accessor.getNamePlaceholder();
            }
            if (returnTypeRef != null) {
                return returnTypeRef;
            }
            if (nameIdentifierOrPlaceholder != null) {
                return nameIdentifierOrPlaceholder;
            }
            return declaration;
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> NAME_IDENTIFIER = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$3", "mark"));
            }
            PsiElement nameIdentifier = element.getNameIdentifier();
            if (nameIdentifier != null) {
                List<TextRange> list = 3.markElement(nameIdentifier);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$3", "mark"));
                }
                return list;
            }
            List<TextRange> list = 3.markElement(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$3", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<PsiNameIdentifierOwner> NAMED_ELEMENT = new PositioningStrategy<PsiNameIdentifierOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
            }
            if (element instanceof JetNamedFunction) {
                JetNamedFunction function = (JetNamedFunction)element;
                JetParameterList valueParameterList = function.getValueParameterList();
                JetTypeReference returnTypeRef = function.getReturnTypeRef();
                PsiElement nameIdentifier = function.getNameIdentifier();
                PsiElement endOfSignatureElement = returnTypeRef != null ? returnTypeRef : (valueParameterList != null ? valueParameterList : (nameIdentifier != null ? nameIdentifier : function));
                List<TextRange> list = 4.markRange(new TextRange(function.getTextRange().getStartOffset(), endOfSignatureElement.getTextRange().getEndOffset()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
                }
                return list;
            }
            if (element instanceof JetProperty) {
                JetProperty property2 = (JetProperty)element;
                JetTypeReference propertyTypeRef = property2.getTypeRef();
                PsiElement nameIdentifier = property2.getNameIdentifier();
                PsiElement endOfSignatureElement = propertyTypeRef != null ? propertyTypeRef : (nameIdentifier != null ? nameIdentifier : property2);
                List<TextRange> list = 4.markRange(new TextRange(property2.getTextRange().getStartOffset(), endOfSignatureElement.getTextRange().getEndOffset()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
                }
                return list;
            }
            if (element instanceof JetClass) {
                JetClass klass = (JetClass)element;
                PsiElement nameAsDeclaration = klass.getNameIdentifier();
                if (nameAsDeclaration == null) {
                    List<TextRange> list = 4.markElement(klass);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
                    }
                    return list;
                }
                JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
                if (primaryConstructorParameterList == null) {
                    List<TextRange> list = 4.markRange(nameAsDeclaration.getTextRange());
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
                    }
                    return list;
                }
                List<TextRange> list = 4.markRange(new TextRange(nameAsDeclaration.getTextRange().getStartOffset(), primaryConstructorParameterList.getTextRange().getEndOffset()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "mark"));
            }
            return list;
        }

        @Override
        public boolean isValid(@NotNull PsiNameIdentifierOwner element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$4", "isValid"));
            }
            return element.getNameIdentifier() != null && super.isValid(element);
        }
    };
    public static final PositioningStrategy<JetDeclaration> DECLARATION = new PositioningStrategy<JetDeclaration>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclaration element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$5", "mark"));
            }
            if (element instanceof PsiNameIdentifierOwner) {
                List<TextRange> list = NAMED_ELEMENT.mark((PsiNameIdentifierOwner)((Object)element));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$5", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$5", "mark"));
            }
            return list;
        }

        @Override
        public boolean isValid(@NotNull JetDeclaration element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$5", "isValid"));
            }
            if (element instanceof PsiNameIdentifierOwner) {
                return NAMED_ELEMENT.isValid((PsiNameIdentifierOwner)((Object)element));
            }
            return super.isValid(element);
        }
    };
    public static final PositioningStrategy<JetModifierListOwner> ABSTRACT_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.ABSTRACT_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> OVERRIDE_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.OVERRIDE_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> FINAL_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.FINAL_KEYWORD);
    public static final PositioningStrategy<JetModifierListOwner> VARIANCE_MODIFIER = PositioningStrategies.modifierSetPosition(JetTokens.IN_KEYWORD, JetTokens.OUT_KEYWORD);
    public static final PositioningStrategy<PsiElement> FOR_REDECLARATION = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            JetFile file;
            PsiElement nameIdentifier;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$6", "mark"));
            }
            if (element instanceof JetNamedDeclaration) {
                PsiElement nameIdentifier2 = ((JetNamedDeclaration)element).getNameIdentifier();
                if (nameIdentifier2 != null) {
                    List<TextRange> list = 6.markElement(nameIdentifier2);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$6", "mark"));
                    }
                    return list;
                }
            } else if (element instanceof JetFile && (nameIdentifier = (file = (JetFile)element).getPackageDirective().getNameIdentifier()) != null) {
                List<TextRange> list = 6.markElement(nameIdentifier);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$6", "mark"));
                }
                return list;
            }
            List<TextRange> list = 6.markElement(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$6", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetReferenceExpression> FOR_UNRESOLVED_REFERENCE = new PositioningStrategy<JetReferenceExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetReferenceExpression element) {
            List<TextRange> ranges;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$7", "mark"));
            }
            if (element instanceof JetArrayAccessExpression && !(ranges = ((JetArrayAccessExpression)element).getBracketRanges()).isEmpty()) {
                List<TextRange> list = ranges;
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$7", "mark"));
                }
                return list;
            }
            List<TextRange> list = Collections.singletonList(element.getTextRange());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$7", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetArrayAccessExpression> ARRAY_ACCESS = new PositioningStrategy<JetArrayAccessExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetArrayAccessExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$9", "mark"));
            }
            List<TextRange> list = 9.markElement(element.getIndicesNode());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$9", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetModifierListOwner> VISIBILITY_MODIFIER = new PositioningStrategy<JetModifierListOwner>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetModifierListOwner element) {
            PsiElement nameIdentifier;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$10", "mark"));
            }
            ArrayList<JetKeywordToken> visibilityTokens = Lists.newArrayList(JetTokens.PRIVATE_KEYWORD, JetTokens.PROTECTED_KEYWORD, JetTokens.PUBLIC_KEYWORD, JetTokens.INTERNAL_KEYWORD);
            ArrayList<TextRange> result2 = Lists.newArrayList();
            for (JetKeywordToken token : visibilityTokens) {
                if (!element.hasModifier(token)) continue;
                result2.add(element.getModifierList().getModifierNode(token).getTextRange());
            }
            if (!result2.isEmpty()) {
                ArrayList<TextRange> arrayList = result2;
                if (arrayList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$10", "mark"));
                }
                return arrayList;
            }
            if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)((Object)element)).getNameIdentifier()) != null) {
                ImmutableList<TextRange> immutableList = ImmutableList.of(nameIdentifier.getTextRange());
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$10", "mark"));
                }
                return immutableList;
            }
            if (element instanceof JetPropertyAccessor) {
                ImmutableList<TextRange> immutableList = ImmutableList.of(((JetPropertyAccessor)element).getNamePlaceholder().getTextRange());
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$10", "mark"));
                }
                return immutableList;
            }
            if (element instanceof JetClassInitializer) {
                ImmutableList<TextRange> immutableList = ImmutableList.of(element.getTextRange());
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$10", "mark"));
                }
                return immutableList;
            }
            if (element instanceof JetClassObject) {
                JetObjectDeclaration objectDeclaration = ((JetClassObject)element).getObjectDeclaration();
                ImmutableList<TextRange> immutableList = ImmutableList.of(objectDeclaration.getObjectKeyword().getTextRange());
                if (immutableList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$10", "mark"));
                }
                return immutableList;
            }
            throw new IllegalArgumentException(String.format("Can't find text range for element '%s' with the text '%s'", element.getClass().getCanonicalName(), element.getText()));
        }
    };
    public static final PositioningStrategy<JetTypeProjection> VARIANCE_IN_PROJECTION = new PositioningStrategy<JetTypeProjection>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetTypeProjection element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$11", "mark"));
            }
            List<TextRange> list = 11.markNode(element.getProjectionNode());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$11", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetParameter> PARAMETER_DEFAULT_VALUE = new PositioningStrategy<JetParameter>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetParameter element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$12", "mark"));
            }
            List<TextRange> list = 12.markNode(element.getDefaultValue().getNode());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$12", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<PsiElement> CALL_ELEMENT = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement callElement) {
            JetExpression calleeExpression;
            if (callElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$13", "mark"));
            }
            if (callElement instanceof JetCallElement && (calleeExpression = ((JetCallElement)callElement).getCalleeExpression()) != null) {
                List<TextRange> list = 13.markElement(calleeExpression);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$13", "mark"));
                }
                return list;
            }
            List<TextRange> list = 13.markElement(callElement);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$13", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetDeclarationWithBody> DECLARATION_WITH_BODY = new PositioningStrategy<JetDeclarationWithBody>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetDeclarationWithBody element) {
            TextRange lastBracketRange;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$14", "mark"));
            }
            JetExpression bodyExpression = element.getBodyExpression();
            if (bodyExpression instanceof JetBlockExpression && (lastBracketRange = ((JetBlockExpression)bodyExpression).getLastBracketRange()) != null) {
                List<TextRange> list = 14.markRange(lastBracketRange);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$14", "mark"));
                }
                return list;
            }
            List<TextRange> list = 14.markElement(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$14", "mark"));
            }
            return list;
        }

        @Override
        public boolean isValid(@NotNull JetDeclarationWithBody element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$14", "isValid"));
            }
            if (!super.isValid(element)) {
                return false;
            }
            JetExpression bodyExpression = element.getBodyExpression();
            if (!(bodyExpression instanceof JetBlockExpression)) {
                return false;
            }
            return ((JetBlockExpression)bodyExpression).getLastBracketRange() != null;
        }
    };
    public static final PositioningStrategy<JetProperty> VAL_OR_VAR_NODE = new PositioningStrategy<JetProperty>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetProperty property2) {
            if (property2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$15", "mark"));
            }
            List<TextRange> list = 15.markNode(property2.getValOrVarNode());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$15", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetWhenEntry> ELSE_ENTRY = new PositioningStrategy<JetWhenEntry>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$16", "mark"));
            }
            PsiElement elseKeywordElement = entry.getElseKeywordElement();
            assert (elseKeywordElement != null);
            List<TextRange> list = 16.markElement(elseKeywordElement);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$16", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetWhenExpression> WHEN_EXPRESSION = new PositioningStrategy<JetWhenExpression>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenExpression element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$17", "mark"));
            }
            List<TextRange> list = 17.markElement(element.getWhenKeywordElement());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$17", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetWhenConditionInRange> WHEN_CONDITION_IN_RANGE = new PositioningStrategy<JetWhenConditionInRange>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetWhenConditionInRange condition) {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$18", "mark"));
            }
            List<TextRange> list = 18.markElement(condition.getOperationReference());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$18", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetNullableType> NULLABLE_TYPE = new PositioningStrategy<JetNullableType>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetNullableType element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$19", "mark"));
            }
            List<TextRange> list = 19.markNode(element.getQuestionMarkNode());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$19", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<PsiElement> CALL_EXPRESSION = new PositioningStrategy<PsiElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$20", "mark"));
            }
            if (element instanceof JetCallExpression) {
                JetCallExpression callExpression = (JetCallExpression)element;
                JetTypeArgumentList typeArgumentList = callExpression.getTypeArgumentList();
                JetExpression calleeExpression = callExpression.getCalleeExpression();
                PsiElement endElement = typeArgumentList != null ? typeArgumentList : (calleeExpression != null ? calleeExpression : element);
                List<TextRange> list = 20.markRange(new TextRange(element.getTextRange().getStartOffset(), endElement.getTextRange().getEndOffset()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$20", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$20", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetElement> VALUE_ARGUMENTS = new PositioningStrategy<JetElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetElement element) {
            PsiElement rightParenthesis;
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$21", "mark"));
            }
            if (element instanceof JetValueArgumentList && (rightParenthesis = ((JetValueArgumentList)element).getRightParenthesis()) != null) {
                List<TextRange> list = 21.markElement(rightParenthesis);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$21", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$21", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetFunctionLiteral> FUNCTION_LITERAL_PARAMETERS = new PositioningStrategy<JetFunctionLiteral>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetFunctionLiteral functionLiteral) {
            if (functionLiteral == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteral", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$22", "mark"));
            }
            JetParameterList valueParameterList = functionLiteral.getValueParameterList();
            if (valueParameterList != null) {
                List<TextRange> list = 22.markElement(valueParameterList);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$22", "mark"));
                }
                return list;
            }
            List<TextRange> list = 22.markNode(functionLiteral.getOpenBraceNode());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$22", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetElement> CUT_CHAR_QUOTES = new PositioningStrategy<JetElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$23", "mark"));
            }
            if (element instanceof JetConstantExpression && element.getNode().getElementType() == JetNodeTypes.CHARACTER_CONSTANT) {
                TextRange elementTextRange = element.getTextRange();
                List<TextRange> list = Collections.singletonList(TextRange.create(elementTextRange.getStartOffset() + 1, elementTextRange.getEndOffset() - 1));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$23", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$23", "mark"));
            }
            return list;
        }
    };
    public static final PositioningStrategy<JetElement> LONG_LITERAL_SUFFIX = new PositioningStrategy<JetElement>(){

        @Override
        @NotNull
        public List<TextRange> mark(@NotNull JetElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$24", "mark"));
            }
            if (element instanceof JetConstantExpression && element.getNode().getElementType() == JetNodeTypes.INTEGER_CONSTANT) {
                int endOffset = element.getTextRange().getEndOffset();
                List<TextRange> list = Collections.singletonList(TextRange.create(endOffset - 1, endOffset));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$24", "mark"));
                }
                return list;
            }
            List<TextRange> list = super.mark(element);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$24", "mark"));
            }
            return list;
        }
    };

    public static PositioningStrategy<JetModifierListOwner> modifierSetPosition(final JetKeywordToken ... tokens) {
        return new PositioningStrategy<JetModifierListOwner>(){

            @Override
            @NotNull
            public List<TextRange> mark(@NotNull JetModifierListOwner modifierListOwner) {
                if (modifierListOwner == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierListOwner", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$8", "mark"));
                }
                JetModifierList modifierList = modifierListOwner.getModifierList();
                assert (modifierList != null) : "No modifier list, but modifier has been found by the analyzer";
                for (JetKeywordToken token : tokens) {
                    ASTNode node = modifierList.getModifierNode(token);
                    if (node == null) continue;
                    List<TextRange> list = 8.markNode(node);
                    if (list == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/diagnostics/PositioningStrategies$8", "mark"));
                    }
                    return list;
                }
                throw new IllegalStateException("None of the modifiers is found: " + Arrays.asList(tokens));
            }
        };
    }

    private PositioningStrategies() {
    }
}

