/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.context.GlobalContext;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.storage.ExceptionTracker;
import org.jetbrains.jet.storage.StorageManager;

public class TopDownAnalysisParameters
implements GlobalContext {
    @NotNull
    private final StorageManager storageManager;
    @NotNull
    private final ExceptionTracker exceptionTracker;
    @NotNull
    private final Predicate<PsiFile> analyzeCompletely;
    private final boolean analyzingBootstrapLibrary;
    private final boolean declaredLocally;
    @NotNull
    private final List<AnalyzerScriptParameter> scriptParameters;

    public TopDownAnalysisParameters(@NotNull StorageManager storageManager, @NotNull ExceptionTracker exceptionTracker, @NotNull Predicate<PsiFile> analyzeCompletely, boolean analyzingBootstrapLibrary, boolean declaredLocally, @NotNull List<AnalyzerScriptParameter> scriptParameters) {
        if (storageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageManager", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "<init>"));
        }
        if (exceptionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionTracker", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "<init>"));
        }
        if (analyzeCompletely == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "analyzeCompletely", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "<init>"));
        }
        if (scriptParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptParameters", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "<init>"));
        }
        this.storageManager = storageManager;
        this.exceptionTracker = exceptionTracker;
        this.analyzeCompletely = analyzeCompletely;
        this.analyzingBootstrapLibrary = analyzingBootstrapLibrary;
        this.declaredLocally = declaredLocally;
        this.scriptParameters = scriptParameters;
    }

    @Override
    @NotNull
    public StorageManager getStorageManager() {
        StorageManager storageManager = this.storageManager;
        if (storageManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "getStorageManager"));
        }
        return storageManager;
    }

    @Override
    @NotNull
    public ExceptionTracker getExceptionTracker() {
        ExceptionTracker exceptionTracker = this.exceptionTracker;
        if (exceptionTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "getExceptionTracker"));
        }
        return exceptionTracker;
    }

    @NotNull
    public Predicate<PsiFile> getAnalyzeCompletely() {
        Predicate<PsiFile> predicate = this.analyzeCompletely;
        if (predicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "getAnalyzeCompletely"));
        }
        return predicate;
    }

    public boolean isAnalyzingBootstrapLibrary() {
        return this.analyzingBootstrapLibrary;
    }

    public boolean isDeclaredLocally() {
        return this.declaredLocally;
    }

    @NotNull
    public List<AnalyzerScriptParameter> getScriptParameters() {
        List<AnalyzerScriptParameter> list = this.scriptParameters;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/TopDownAnalysisParameters", "getScriptParameters"));
        }
        return list;
    }
}

