/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class PackageClassUtils {
    public static final String PACKAGE_CLASS_NAME_SUFFIX = "Package";

    private PackageClassUtils() {
    }

    @NotNull
    public static String getPackageClassName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassName"));
        }
        if (packageFQN.isRoot()) {
            if ("_DefaultPackage" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassName"));
            }
            return "_DefaultPackage";
        }
        String string = PackageClassUtils.capitalizeNonEmptyString(packageFQN.shortName().asString()) + PACKAGE_CLASS_NAME_SUFFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassName"));
        }
        return string;
    }

    @NotNull
    private static String capitalizeNonEmptyString(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "capitalizeNonEmptyString"));
        }
        String string = Character.isUpperCase(s.charAt(0)) ? s : Character.toUpperCase(s.charAt(0)) + s.substring(1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "capitalizeNonEmptyString"));
        }
        return string;
    }

    @NotNull
    public static FqName getPackageClassFqName(@NotNull FqName packageFQN) {
        if (packageFQN == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFQN", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassFqName"));
        }
        FqName fqName = packageFQN.child(Name.identifier(PackageClassUtils.getPackageClassName(packageFQN)));
        if (fqName == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "getPackageClassFqName"));
        }
        return fqName;
    }

    public static boolean isPackageClassFqName(@NotNull FqName fqName) {
        if (fqName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/java/PackageClassUtils", "isPackageClassFqName"));
        }
        return !fqName.isRoot() && PackageClassUtils.getPackageClassFqName(fqName.parent()).equals(fqName);
    }
}

