/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java.sam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotations;
import org.jetbrains.jet.lang.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.resolve.java.descriptor.JavaClassDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamAdapterDescriptor;
import org.jetbrains.jet.lang.resolve.java.descriptor.SamConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.resolver.DescriptorResolverUtils;
import org.jetbrains.jet.lang.resolve.java.sam.SamAdapterConstructorDescriptor;
import org.jetbrains.jet.lang.resolve.java.sam.SamAdapterFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClass;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifier;
import org.jetbrains.jet.lang.resolve.java.structure.JavaClassifierType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaMethod;
import org.jetbrains.jet.lang.resolve.java.structure.JavaType;
import org.jetbrains.jet.lang.resolve.java.structure.JavaTypeSubstitutor;
import org.jetbrains.jet.lang.resolve.java.structure.JavaValueParameter;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeProjectionImpl;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;

public class SingleAbstractMethodUtils {
    private SingleAbstractMethodUtils() {
    }

    @NotNull
    public static List<CallableMemberDescriptor> getAbstractMembers(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getAbstractMembers"));
        }
        ArrayList<CallableMemberDescriptor> abstractMembers = new ArrayList<CallableMemberDescriptor>();
        for (DeclarationDescriptor member : type.getMemberScope().getAllDescriptors()) {
            if (!(member instanceof CallableMemberDescriptor) || ((CallableMemberDescriptor)member).getModality() != Modality.ABSTRACT) continue;
            abstractMembers.add((CallableMemberDescriptor)member);
        }
        ArrayList<CallableMemberDescriptor> arrayList = abstractMembers;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getAbstractMembers"));
        }
        return arrayList;
    }

    private static JetType fixProjections(@NotNull JetType functionType) {
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "fixProjections"));
        }
        List<TypeParameterDescriptor> typeParameters = functionType.getConstructor().getParameters();
        ArrayList<TypeProjection> arguments = new ArrayList<TypeProjection>(typeParameters.size());
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            Variance variance = typeParameter.getVariance();
            TypeProjection argument = functionType.getArguments().get(typeParameter.getIndex());
            Variance kind = argument.getProjectionKind();
            if (kind != Variance.INVARIANT && variance != Variance.INVARIANT) {
                if (kind == variance) {
                    arguments.add(new TypeProjectionImpl(argument.getType()));
                    continue;
                }
                return null;
            }
            arguments.add(argument);
        }
        ClassifierDescriptor classifier2 = functionType.getConstructor().getDeclarationDescriptor();
        assert (classifier2 instanceof ClassDescriptor) : "Not class: " + classifier2;
        return new JetTypeImpl(functionType.getAnnotations(), functionType.getConstructor(), functionType.isNullable(), arguments, ((ClassDescriptor)classifier2).getMemberScope(arguments));
    }

    @Nullable
    private static JetType getFunctionTypeForSamType(@NotNull JetType samType) {
        JetType functionTypeDefault;
        if (samType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samType", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForSamType"));
        }
        ClassifierDescriptor classifier2 = samType.getConstructor().getDeclarationDescriptor();
        if (classifier2 instanceof JavaClassDescriptor && (functionTypeDefault = ((JavaClassDescriptor)classifier2).getFunctionTypeForSamInterface()) != null) {
            JetType substitute = TypeSubstitutor.create(samType).substitute(functionTypeDefault, Variance.INVARIANT);
            return substitute == null ? null : SingleAbstractMethodUtils.fixProjections(TypeUtils.makeNullableAsSpecified(substitute, samType.isNullable()));
        }
        return null;
    }

    @NotNull
    public static JetType getFunctionTypeForAbstractMethod(@NotNull FunctionDescriptor function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForAbstractMethod"));
        }
        JetType returnType = function.getReturnType();
        assert (returnType != null) : "function is not initialized: " + function;
        List<ValueParameterDescriptor> valueParameters = function.getValueParameters();
        ArrayList<JetType> parameterTypes = new ArrayList<JetType>(valueParameters.size());
        for (ValueParameterDescriptor parameter : valueParameters) {
            parameterTypes.add(parameter.getType());
        }
        JetType jetType = KotlinBuiltIns.getInstance().getFunctionType(Annotations.EMPTY, null, parameterTypes, returnType);
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getFunctionTypeForAbstractMethod"));
        }
        return jetType;
    }

    private static boolean isSamInterface(@NotNull ClassDescriptor klass) {
        CallableMemberDescriptor member;
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "isSamInterface"));
        }
        if (klass.getKind() != ClassKind.TRAIT) {
            return false;
        }
        List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(klass.getDefaultType());
        if (abstractMembers.size() == 1 && (member = abstractMembers.get(0)) instanceof SimpleFunctionDescriptor) {
            return member.getTypeParameters().isEmpty();
        }
        return false;
    }

    @NotNull
    public static SamConstructorDescriptor createSamConstructorFunction(@NotNull ClassOrPackageFragmentDescriptor owner, @NotNull JavaClassDescriptor samInterface) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterface", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        assert (SingleAbstractMethodUtils.isSamInterface(samInterface)) : samInterface;
        SamConstructorDescriptor result2 = new SamConstructorDescriptor(owner, samInterface);
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(samInterface.getTypeConstructor().getParameters(), result2);
        JetType parameterTypeUnsubstituted = SingleAbstractMethodUtils.getFunctionTypeForSamType(samInterface.getDefaultType());
        assert (parameterTypeUnsubstituted != null) : "couldn't get function type for SAM type " + samInterface.getDefaultType();
        JetType parameterType = typeParameters.substitutor.substitute(parameterTypeUnsubstituted, Variance.IN_VARIANCE);
        assert (parameterType != null) : "couldn't substitute type: " + parameterTypeUnsubstituted + ", substitutor = " + typeParameters.substitutor;
        ValueParameterDescriptorImpl parameter = new ValueParameterDescriptorImpl(result2, 0, Annotations.EMPTY, Name.identifier("function"), parameterType, false, null);
        JetType returnType = typeParameters.substitutor.substitute(samInterface.getDefaultType(), Variance.OUT_VARIANCE);
        assert (returnType != null) : "couldn't substitute type: " + samInterface.getDefaultType() + ", substitutor = " + typeParameters.substitutor;
        result2.initialize((JetType)null, (ReceiverParameterDescriptor)null, typeParameters.descriptors, (List)Arrays.asList(parameter), returnType, Modality.FINAL, samInterface.getVisibility());
        SamConstructorDescriptor samConstructorDescriptor = result2;
        if (samConstructorDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamConstructorFunction"));
        }
        return samConstructorDescriptor;
    }

    public static boolean isSamType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "isSamType"));
        }
        return SingleAbstractMethodUtils.getFunctionTypeForSamType(type) != null;
    }

    public static boolean isSamAdapterNecessary(@NotNull FunctionDescriptor fun) {
        if (fun == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "isSamAdapterNecessary"));
        }
        for (ValueParameterDescriptor param : fun.getValueParameters()) {
            if (!SingleAbstractMethodUtils.isSamType(param.getType())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static SamAdapterDescriptor<SimpleFunctionDescriptor> createSamAdapterFunction(final @NotNull SimpleFunctionDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamAdapterFunction"));
        }
        final SamAdapterFunctionDescriptor result2 = new SamAdapterFunctionDescriptor(original);
        SamAdapterDescriptor<SimpleFunctionDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @Nullable JetType returnType) {
                if (typeParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                if (valueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$1", "initialize"));
                }
                result2.initialize((JetType)null, original.getExpectedThisObject(), typeParameters, (List)valueParameters, returnType, Modality.FINAL, original.getVisibility());
            }
        });
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamAdapterFunction"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    public static SamAdapterDescriptor<ConstructorDescriptor> createSamAdapterConstructor(final @NotNull ConstructorDescriptor original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamAdapterConstructor"));
        }
        final SamAdapterConstructorDescriptor result2 = new SamAdapterConstructorDescriptor(original);
        SamAdapterDescriptor<ConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.initSamAdapter(original, result2, new FunctionInitializer(){

            @Override
            public void initialize(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull List<ValueParameterDescriptor> valueParameters, @Nullable JetType returnType) {
                if (typeParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                if (valueParameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$2", "initialize"));
                }
                result2.initialize(typeParameters, valueParameters, original.getVisibility(), original.getExpectedThisObject() == ReceiverParameterDescriptor.NO_RECEIVER_PARAMETER);
            }
        });
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "createSamAdapterConstructor"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    private static <F extends FunctionDescriptor> SamAdapterDescriptor<F> initSamAdapter(@NotNull F original, @NotNull SamAdapterDescriptor<F> adapter, @NotNull FunctionInitializer initializer) {
        JetType returnType;
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        if (adapter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "adapter", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        TypeParameters typeParameters = SingleAbstractMethodUtils.recreateAndInitializeTypeParameters(original.getTypeParameters(), adapter);
        JetType returnTypeUnsubstituted = original.getReturnType();
        if (returnTypeUnsubstituted == null) {
            returnType = null;
        } else {
            returnType = typeParameters.substitutor.substitute(returnTypeUnsubstituted, Variance.OUT_VARIANCE);
            assert (returnType != null) : "couldn't substitute type: " + returnTypeUnsubstituted + ", substitutor = " + typeParameters.substitutor;
        }
        List<ValueParameterDescriptor> originalValueParameters = original.getValueParameters();
        ArrayList<ValueParameterDescriptor> valueParameters = new ArrayList<ValueParameterDescriptor>(originalValueParameters.size());
        for (ValueParameterDescriptor originalParam : originalValueParameters) {
            JetType originalType = originalParam.getType();
            JetType functionType = SingleAbstractMethodUtils.getFunctionTypeForSamType(originalType);
            JetType newTypeUnsubstituted = functionType != null ? functionType : originalType;
            JetType newType = typeParameters.substitutor.substitute(newTypeUnsubstituted, Variance.IN_VARIANCE);
            assert (newType != null) : "couldn't substitute type: " + newTypeUnsubstituted + ", substitutor = " + typeParameters.substitutor;
            ValueParameterDescriptorImpl newParam = new ValueParameterDescriptorImpl(adapter, originalParam.getIndex(), originalParam.getAnnotations(), originalParam.getName(), newType, false, null);
            valueParameters.add(newParam);
        }
        initializer.initialize(typeParameters.descriptors, valueParameters, returnType);
        SamAdapterDescriptor<F> samAdapterDescriptor = adapter;
        if (samAdapterDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "initSamAdapter"));
        }
        return samAdapterDescriptor;
    }

    @NotNull
    private static TypeParameters recreateAndInitializeTypeParameters(@NotNull List<TypeParameterDescriptor> originalParameters, @Nullable DeclarationDescriptor newOwner) {
        if (originalParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalParameters", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
        }
        Map<TypeParameterDescriptor, TypeParameterDescriptorImpl> traitToFunTypeParameters = DescriptorResolverUtils.recreateTypeParametersAndReturnMapping(originalParameters, newOwner);
        TypeSubstitutor typeParametersSubstitutor = DescriptorResolverUtils.createSubstitutorForTypeParameters(traitToFunTypeParameters);
        for (Map.Entry<TypeParameterDescriptor, TypeParameterDescriptorImpl> mapEntry : traitToFunTypeParameters.entrySet()) {
            TypeParameterDescriptor traitTypeParameter = mapEntry.getKey();
            TypeParameterDescriptorImpl funTypeParameter = mapEntry.getValue();
            for (JetType upperBound : traitTypeParameter.getUpperBounds()) {
                JetType upperBoundSubstituted = typeParametersSubstitutor.substitute(upperBound, Variance.INVARIANT);
                assert (upperBoundSubstituted != null) : "couldn't substitute type: " + upperBound + ", substitutor = " + typeParametersSubstitutor;
                funTypeParameter.addUpperBound(upperBoundSubstituted);
            }
            funTypeParameter.setInitialized();
        }
        ArrayList<TypeParameterDescriptorImpl> typeParameters = new ArrayList<TypeParameterDescriptorImpl>(traitToFunTypeParameters.values());
        TypeParameters typeParameters2 = new TypeParameters(typeParameters, typeParametersSubstitutor);
        if (typeParameters2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "recreateAndInitializeTypeParameters"));
        }
        return typeParameters2;
    }

    @NotNull
    public static SimpleFunctionDescriptor getAbstractMethodOfSamType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getAbstractMethodOfSamType"));
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)SingleAbstractMethodUtils.getAbstractMembers(type).get(0);
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getAbstractMethodOfSamType"));
        }
        return simpleFunctionDescriptor;
    }

    @NotNull
    public static SimpleFunctionDescriptor getAbstractMethodOfSamInterface(@NotNull ClassDescriptor samInterface) {
        if (samInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "samInterface", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getAbstractMethodOfSamInterface"));
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = SingleAbstractMethodUtils.getAbstractMethodOfSamType(samInterface.getDefaultType());
        if (simpleFunctionDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getAbstractMethodOfSamInterface"));
        }
        return simpleFunctionDescriptor;
    }

    public static boolean isSamInterface(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "isSamInterface"));
        }
        return SingleAbstractMethodUtils.getSamInterfaceMethod(javaClass) != null;
    }

    @Nullable
    public static JavaMethod getSamInterfaceMethod(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "getSamInterfaceMethod"));
        }
        FqName fqName = javaClass.getFqName();
        if (fqName == null || fqName.firstSegmentIs(KotlinBuiltIns.BUILT_INS_PACKAGE_NAME)) {
            return null;
        }
        if (!javaClass.isInterface() || javaClass.isAnnotationType()) {
            return null;
        }
        return SingleAbstractMethodUtils.findOnlyAbstractMethod(javaClass);
    }

    @Nullable
    private static JavaMethod findOnlyAbstractMethod(@NotNull JavaClass javaClass) {
        if (javaClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaClass", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils", "findOnlyAbstractMethod"));
        }
        OnlyAbstractMethodFinder finder = new OnlyAbstractMethodFinder();
        if (finder.find(javaClass.getDefaultType())) {
            return finder.getFoundMethod();
        }
        return null;
    }

    private static class OnlyAbstractMethodFinder {
        private JavaMethod foundMethod;
        private JavaTypeSubstitutor foundClassSubstitutor;

        private OnlyAbstractMethodFinder() {
        }

        private boolean find(@NotNull JavaClassifierType classifierType) {
            if (classifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifierType", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "find"));
            }
            JavaTypeSubstitutor classSubstitutor = classifierType.getSubstitutor();
            JavaClassifier classifier2 = classifierType.getClassifier();
            if (classifier2 == null) {
                return false;
            }
            assert (classifier2 instanceof JavaClass) : "Classifier should be a class here: " + classifier2;
            JavaClass javaClass = (JavaClass)classifier2;
            if (DescriptorResolverUtils.OBJECT_FQ_NAME.equals(javaClass.getFqName())) {
                return true;
            }
            for (JavaMethod method : javaClass.getMethods()) {
                if (DescriptorResolverUtils.isObjectMethod(method)) continue;
                if (!method.getTypeParameters().isEmpty()) {
                    return false;
                }
                if (this.foundMethod == null) {
                    this.foundMethod = method;
                    this.foundClassSubstitutor = classSubstitutor;
                    continue;
                }
                if (OnlyAbstractMethodFinder.areSignaturesErasureEqual(method, classSubstitutor, this.foundMethod, this.foundClassSubstitutor)) continue;
                return false;
            }
            for (JavaClassifierType t : classifierType.getSupertypes()) {
                if (this.find(t)) continue;
                return false;
            }
            return true;
        }

        private static boolean areSignaturesErasureEqual(@NotNull JavaMethod method1, @NotNull JavaTypeSubstitutor substitutor1, @NotNull JavaMethod method2, @NotNull JavaTypeSubstitutor substitutor2) {
            if (method1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method1", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (substitutor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor1", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (method2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method2", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (substitutor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor2", "org/jetbrains/jet/lang/resolve/java/sam/SingleAbstractMethodUtils$OnlyAbstractMethodFinder", "areSignaturesErasureEqual"));
            }
            if (method1.isConstructor() != method2.isConstructor()) {
                return false;
            }
            if (!method1.isConstructor() && !method1.getName().equals(method2.getName())) {
                return false;
            }
            if (method1.isVararg() != method2.isVararg()) {
                return false;
            }
            List<JavaValueParameter> parameters1 = method1.getValueParameters();
            List<JavaValueParameter> parameters2 = method2.getValueParameters();
            if (parameters1.size() != parameters2.size()) {
                return false;
            }
            Iterator it1 = parameters1.iterator();
            Iterator it2 = parameters2.iterator();
            while (it1.hasNext()) {
                JavaType type1 = DescriptorResolverUtils.erasure(substitutor1.substitute(((JavaValueParameter)it1.next()).getType()), substitutor1);
                JavaType type2 = DescriptorResolverUtils.erasure(substitutor2.substitute(((JavaValueParameter)it2.next()).getType()), substitutor2);
                if (type1 != null ? type1.equals(type2) : type2 == null) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private JavaMethod getFoundMethod() {
            return this.foundMethod;
        }
    }

    private static abstract class FunctionInitializer {
        private FunctionInitializer() {
        }

        public abstract void initialize(@NotNull List<TypeParameterDescriptor> var1, @NotNull List<ValueParameterDescriptor> var2, @Nullable JetType var3);
    }

    private static class TypeParameters {
        public final List<TypeParameterDescriptor> descriptors;
        public final TypeSubstitutor substitutor;

        private TypeParameters(List<TypeParameterDescriptor> descriptors, TypeSubstitutor substitutor) {
            this.descriptors = descriptors;
            this.substitutor = substitutor;
        }
    }
}

