/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.kotlin;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.descriptors.serialization.JavaProtoBuf;
import org.jetbrains.jet.descriptors.serialization.NameResolver;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.descriptors.Deserializers;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.java.resolver.ErrorReporter;
import org.jetbrains.jet.lang.resolve.kotlin.DescriptorDeserializersStorage;
import org.jetbrains.jet.lang.resolve.kotlin.DeserializedResolverUtils;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinClassFinder;
import org.jetbrains.jet.lang.resolve.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.DependencyClassByQualifiedNameResolver;

public abstract class BaseDescriptorDeserializer {
    protected DependencyClassByQualifiedNameResolver classResolver;
    protected KotlinClassFinder kotlinClassFinder;
    protected ErrorReporter errorReporter;
    protected DescriptorDeserializersStorage storage;

    public abstract void setClassResolver(@NotNull DependencyClassByQualifiedNameResolver var1);

    public abstract void setKotlinClassFinder(@NotNull KotlinClassFinder var1);

    public abstract void setErrorReporter(@NotNull ErrorReporter var1);

    public abstract void setStorage(@NotNull DescriptorDeserializersStorage var1);

    @Nullable
    protected static DescriptorDeserializersStorage.MemberSignature getCallableSignature(@NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull Deserializers.AnnotatedCallableKind kind) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "getCallableSignature"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "getCallableSignature"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "getCallableSignature"));
        }
        SignatureDeserializer deserializer = new SignatureDeserializer(nameResolver);
        switch (kind) {
            case FUNCTION: {
                if (!proto.hasExtension(JavaProtoBuf.methodSignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.methodSignature));
            }
            case PROPERTY_GETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.propertySignature).getGetter());
            }
            case PROPERTY_SETTER: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                return deserializer.methodSignature(proto.getExtension(JavaProtoBuf.propertySignature).getSetter());
            }
            case PROPERTY: {
                if (!proto.hasExtension(JavaProtoBuf.propertySignature)) break;
                JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
                if (propertySignature.hasField()) {
                    JavaProtoBuf.JavaFieldSignature field = propertySignature.getField();
                    String type = deserializer.typeDescriptor(field.getType());
                    Name name = nameResolver.getName(field.getName());
                    return DescriptorDeserializersStorage.MemberSignature.fromFieldNameAndDesc(name, type);
                }
                if (!propertySignature.hasSyntheticMethod()) break;
                return deserializer.methodSignature(propertySignature.getSyntheticMethod());
            }
        }
        return null;
    }

    @Nullable
    protected KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(@NotNull ClassOrPackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver, @NotNull Deserializers.AnnotatedCallableKind kind) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "findClassWithAnnotationsAndInitializers"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "findClassWithAnnotationsAndInitializers"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "findClassWithAnnotationsAndInitializers"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "findClassWithAnnotationsAndInitializers"));
        }
        if (container instanceof PackageFragmentDescriptor) {
            return this.loadPackageFragmentClassFqName((PackageFragmentDescriptor)container, proto, nameResolver);
        }
        if (DescriptorUtils.isClassObject(container) && BaseDescriptorDeserializer.isStaticFieldInOuter(proto)) {
            return this.findKotlinClassByDescriptor((ClassOrPackageFragmentDescriptor)container.getContainingDeclaration());
        }
        if (DescriptorUtils.isTrait(container) && kind == Deserializers.AnnotatedCallableKind.PROPERTY) {
            PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(container, PackageFragmentDescriptor.class);
            assert (containingPackage != null) : "Trait must have a package fragment among his parents: " + container;
            if (proto.hasExtension(JavaProtoBuf.implClassName)) {
                Name tImplName = nameResolver.getName(proto.getExtension(JavaProtoBuf.implClassName));
                return this.kotlinClassFinder.findKotlinClass(containingPackage.getFqName().child(tImplName));
            }
            return null;
        }
        return this.findKotlinClassByDescriptor(container);
    }

    @Nullable
    private KotlinJvmBinaryClass loadPackageFragmentClassFqName(@NotNull PackageFragmentDescriptor container, @NotNull ProtoBuf.Callable proto, @NotNull NameResolver nameResolver) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "loadPackageFragmentClassFqName"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "loadPackageFragmentClassFqName"));
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "loadPackageFragmentClassFqName"));
        }
        if (proto.hasExtension(JavaProtoBuf.implClassName)) {
            Name name = nameResolver.getName(proto.getExtension(JavaProtoBuf.implClassName));
            FqName fqName = PackageClassUtils.getPackageClassFqName(container.getFqName()).parent().child(name);
            return this.kotlinClassFinder.findKotlinClass(fqName);
        }
        return null;
    }

    private static boolean isStaticFieldInOuter(@NotNull ProtoBuf.Callable proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "isStaticFieldInOuter"));
        }
        if (!proto.hasExtension(JavaProtoBuf.propertySignature)) {
            return false;
        }
        JavaProtoBuf.JavaPropertySignature propertySignature = proto.getExtension(JavaProtoBuf.propertySignature);
        return propertySignature.hasField() && propertySignature.getField().getIsStaticInOuter();
    }

    @Nullable
    protected KotlinJvmBinaryClass findKotlinClassByDescriptor(@NotNull ClassOrPackageFragmentDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer", "findKotlinClassByDescriptor"));
        }
        if (descriptor instanceof ClassDescriptor) {
            return this.kotlinClassFinder.findKotlinClass(DeserializedResolverUtils.kotlinFqNameToJavaFqName(DeserializedResolverUtils.naiveKotlinFqName((ClassDescriptor)descriptor)));
        }
        if (descriptor instanceof PackageFragmentDescriptor) {
            return this.kotlinClassFinder.findKotlinClass(PackageClassUtils.getPackageClassFqName(((PackageFragmentDescriptor)descriptor).getFqName()));
        }
        throw new IllegalStateException("Unrecognized descriptor: " + descriptor);
    }

    protected static class SignatureDeserializer {
        private static final char[] PRIMITIVE_TYPES = new char[]{'V', 'Z', 'C', 'B', 'S', 'I', 'F', 'J', 'D'};
        private final NameResolver nameResolver;

        public SignatureDeserializer(@NotNull NameResolver nameResolver) {
            if (nameResolver == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameResolver", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "<init>"));
            }
            this.nameResolver = nameResolver;
        }

        @NotNull
        public DescriptorDeserializersStorage.MemberSignature methodSignature(@NotNull JavaProtoBuf.JavaMethodSignature signature) {
            if (signature == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "methodSignature"));
            }
            Name name = this.nameResolver.getName(signature.getName());
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            int length = signature.getParameterTypeCount();
            for (int i = 0; i < length; ++i) {
                this.typeDescriptor(signature.getParameterType(i), sb);
            }
            sb.append(')');
            this.typeDescriptor(signature.getReturnType(), sb);
            DescriptorDeserializersStorage.MemberSignature memberSignature = DescriptorDeserializersStorage.MemberSignature.fromMethodNameAndDesc(name, sb.toString());
            if (memberSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "methodSignature"));
            }
            return memberSignature;
        }

        @NotNull
        public String typeDescriptor(@NotNull JavaProtoBuf.JavaType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            String string = this.typeDescriptor(type, new StringBuilder()).toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            return string;
        }

        @NotNull
        private StringBuilder typeDescriptor(@NotNull JavaProtoBuf.JavaType type, @NotNull StringBuilder sb) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            if (sb == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            for (int i = 0; i < type.getArrayDimension(); ++i) {
                sb.append('[');
            }
            if (type.hasPrimitiveType()) {
                sb.append(PRIMITIVE_TYPES[type.getPrimitiveType().ordinal()]);
            } else {
                sb.append("L");
                sb.append(SignatureDeserializer.fqNameToInternalName(this.nameResolver.getFqName(type.getClassFqName())));
                sb.append(";");
            }
            StringBuilder stringBuilder = sb;
            if (stringBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "typeDescriptor"));
            }
            return stringBuilder;
        }

        @NotNull
        private static String fqNameToInternalName(@NotNull FqName fqName) {
            if (fqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "fqNameToInternalName"));
            }
            String string = fqName.asString().replace('.', '/');
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/kotlin/BaseDescriptorDeserializer$SignatureDeserializer", "fqNameToInternalName"));
            }
            return string;
        }
    }
}

