/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageViewDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.utils.Printer;

public class SubstitutingScope
implements JetScope {
    private final JetScope workerScope;
    private final TypeSubstitutor substitutor;
    private Map<DeclarationDescriptor, DeclarationDescriptor> substitutedDescriptors;
    private Collection<DeclarationDescriptor> allDescriptors;

    public SubstitutingScope(JetScope workerScope, @NotNull TypeSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "<init>"));
        }
        this.substitutedDescriptors = null;
        this.allDescriptors = null;
        this.workerScope = workerScope;
        this.substitutor = substitutor;
    }

    @Nullable
    private <D extends DeclarationDescriptor> D substitute(@Nullable D descriptor) {
        DeclarationDescriptor substituted;
        if (descriptor == null) {
            return null;
        }
        if (this.substitutor.isEmpty()) {
            return descriptor;
        }
        if (this.substitutedDescriptors == null) {
            this.substitutedDescriptors = Maps.newHashMap();
        }
        if ((substituted = this.substitutedDescriptors.get(descriptor)) == null && !this.substitutedDescriptors.containsKey(descriptor)) {
            substituted = descriptor.substitute(this.substitutor);
            this.substitutedDescriptors.put(descriptor, substituted);
        }
        return (D)substituted;
    }

    @NotNull
    private <D extends DeclarationDescriptor> Collection<D> substitute(@NotNull Collection<D> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "substitute"));
        }
        if (this.substitutor.isEmpty()) {
            Collection<D> collection = descriptors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "substitute"));
            }
            return collection;
        }
        if (descriptors.isEmpty()) {
            Collection<D> collection = descriptors;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "substitute"));
            }
            return collection;
        }
        HashSet<DeclarationDescriptor> result2 = Sets.newHashSetWithExpectedSize(descriptors.size());
        for (DeclarationDescriptor descriptor : descriptors) {
            DeclarationDescriptor substitute = this.substitute(descriptor);
            if (substitute == null) continue;
            result2.add(substitute);
        }
        HashSet<DeclarationDescriptor> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "substitute"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Collection<VariableDescriptor> getProperties(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getProperties"));
        }
        Collection<VariableDescriptor> collection = this.substitute(this.workerScope.getProperties(name));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getProperties"));
        }
        return collection;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getLocalVariable"));
        }
        return this.substitute(this.workerScope.getLocalVariable(name));
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getClassifier"));
        }
        return this.substitute(this.workerScope.getClassifier(name));
    }

    @Override
    @NotNull
    public Collection<FunctionDescriptor> getFunctions(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getFunctions"));
        }
        Collection<FunctionDescriptor> collection = this.substitute(this.workerScope.getFunctions(name));
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getFunctions"));
        }
        return collection;
    }

    @Override
    public PackageViewDescriptor getPackage(@NotNull Name name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getPackage"));
        }
        return this.workerScope.getPackage(name);
    }

    @Override
    @NotNull
    public List<ReceiverParameterDescriptor> getImplicitReceiversHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        DeclarationDescriptor declarationDescriptor = this.workerScope.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getContainingDeclaration"));
        }
        return declarationDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getDeclarationsByLabel"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = this.substitute(this.workerScope.getAllDescriptors());
        }
        Collection<DeclarationDescriptor> collection = this.allDescriptors;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getAllDescriptors"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getOwnDeclaredDescriptors() {
        Collection<DeclarationDescriptor> collection = this.substitute(this.workerScope.getOwnDeclaredDescriptors());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "getOwnDeclaredDescriptors"));
        }
        return collection;
    }

    @Override
    public void printScopeStructure(@NotNull Printer p) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "org/jetbrains/jet/lang/resolve/scopes/SubstitutingScope", "printScopeStructure"));
        }
        p.println(this.getClass().getSimpleName(), " {");
        p.pushIndent();
        p.println("substitutor = ");
        p.pushIndent();
        p.println(this.substitutor);
        p.popIndent();
        p.print("workerScope = ");
        this.workerScope.printScopeStructure(p.withholdIndentOnce());
        p.popIndent();
        p.println("}");
    }
}

