/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import com.intellij.openapi.vfs.impl.jar.CoreJarHandler;
import com.intellij.openapi.vfs.impl.jar.JarHandlerBase;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreJarVirtualFile
extends VirtualFile {
    private final CoreJarHandler myHandler;
    private final VirtualFile myParent;
    private final List<VirtualFile> myChildren;
    private final JarHandlerBase.EntryInfo myEntry;

    public CoreJarVirtualFile(@NotNull CoreJarHandler handler, @NotNull JarHandlerBase.EntryInfo entry, @Nullable CoreJarVirtualFile parent) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "<init>"));
        }
        this.myChildren = new ArrayList<VirtualFile>();
        this.myHandler = handler;
        this.myParent = parent;
        this.myEntry = entry;
        if (parent != null) {
            parent.myChildren.add(this);
        }
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myEntry.shortName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        CoreJarFileSystem coreJarFileSystem = this.myHandler.getFileSystem();
        if (coreJarFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getFileSystem"));
        }
        return coreJarFileSystem;
    }

    @Override
    @NotNull
    public String getPath() {
        if (this.myParent == null) {
            String string = this.myHandler.myBasePath + "!/";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getPath"));
            }
            return string;
        }
        String parentPath = this.myParent.getPath();
        StringBuilder answer = new StringBuilder(parentPath.length() + 1 + this.myEntry.shortName.length());
        answer.append(parentPath);
        if (answer.charAt(answer.length() - 1) != '/') {
            answer.append('/');
        }
        answer.append(this.myEntry.shortName);
        String string = answer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "getPath"));
        }
        return string;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.myEntry.isDirectory;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Override
    public VirtualFile[] getChildren() {
        return this.myChildren.toArray(new VirtualFile[this.myChildren.size()]);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException("JarFileSystem is read-only");
    }

    @Override
    @NotNull
    public byte[] contentsToByteArray() throws IOException {
        byte[] byArray = this.myHandler.contentsToByteArray(this);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/CoreJarVirtualFile", "contentsToByteArray"));
        }
        return byArray;
    }

    @Override
    public long getTimeStamp() {
        return this.myHandler.getTimeStamp(this);
    }

    @Override
    public long getLength() {
        return this.myHandler.getLength(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.myHandler.getInputStream(this);
    }

    @Override
    public long getModificationStamp() {
        return 0L;
    }
}

