/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.file;

import com.intellij.codeInsight.completion.scope.JavaCompletionHints;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiFacadeImpl;
import com.intellij.psi.impl.file.PsiPackageBase;
import com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import com.intellij.psi.impl.source.tree.java.PsiCompositeModifierList;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ConcurrentSoftValueHashMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPackageImpl
extends PsiPackageBase
implements Queryable,
PsiPackage {
    public static boolean DEBUG = false;
    private volatile CachedValue<PsiModifierList> myAnnotationList;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectories;
    private volatile CachedValue<Collection<PsiDirectory>> myDirectoriesWithLibSources;
    private volatile SoftReference<Map<String, PsiClass[]>> myClassCache;

    public PsiPackageImpl(PsiManager manager, String qualifiedName) {
        super(manager, qualifiedName);
    }

    @Override
    protected Collection<PsiDirectory> getAllDirectories(boolean includeLibrarySources) {
        if (includeLibrarySources) {
            if (this.myDirectoriesWithLibSources == null) {
                this.myDirectoriesWithLibSources = this.createCachedDirectories(true);
            }
            return this.myDirectoriesWithLibSources.getValue();
        }
        if (this.myDirectories == null) {
            this.myDirectories = this.createCachedDirectories(false);
        }
        return this.myDirectories.getValue();
    }

    private CachedValue<Collection<PsiDirectory>> createCachedDirectories(final boolean includeLibrarySources) {
        return CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new CachedValueProvider<Collection<PsiDirectory>>(){

            @Override
            public CachedValueProvider.Result<Collection<PsiDirectory>> compute() {
                CommonProcessors.CollectProcessor<PsiDirectory> processor = new CommonProcessors.CollectProcessor<PsiDirectory>();
                PsiPackageImpl.this.getFacade().processPackageDirectories(PsiPackageImpl.this, PsiPackageImpl.this.allScope(), processor, includeLibrarySources);
                return CachedValueProvider.Result.create(processor.getResults(), PsiPackageImplementationHelper.getInstance().getDirectoryCachedValueDependencies(PsiPackageImpl.this));
            }
        }, false);
    }

    @Override
    protected PsiElement findPackage(String qName) {
        return this.getFacade().findPackage(qName);
    }

    @Override
    public void handleQualifiedNameChange(@NotNull String newQualifiedName) {
        if (newQualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "handleQualifiedNameChange"));
        }
        PsiPackageImplementationHelper.getInstance().handleQualifiedNameChange(this, newQualifiedName);
    }

    @Override
    public VirtualFile[] occursInPackagePrefixes() {
        return PsiPackageImplementationHelper.getInstance().occursInPackagePrefixes(this);
    }

    @Override
    public PsiPackageImpl getParentPackage() {
        return (PsiPackageImpl)super.getParentPackage();
    }

    @Override
    protected PsiPackageImpl createInstance(PsiManager manager, String qName) {
        return new PsiPackageImpl(this.myManager, qName);
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    @Override
    public boolean isValid() {
        return PsiPackageImplementationHelper.getInstance().packagePrefixExists(this) || !this.getAllDirectories(true).isEmpty();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitPackage(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiPackage:" + this.getQualifiedName();
    }

    @Override
    @NotNull
    public PsiClass[] getClasses() {
        PsiClass[] psiClassArray = this.getClasses(this.allScope());
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    protected GlobalSearchScope allScope() {
        return PsiPackageImplementationHelper.getInstance().adjustAllScope(this, GlobalSearchScope.allScope(this.getProject()));
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        PsiClass[] psiClassArray = this.getFacade().getClasses(this, scope);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getClasses"));
        }
        return psiClassArray;
    }

    @Override
    @Nullable
    public PsiModifierList getAnnotationList() {
        if (this.myAnnotationList == null) {
            this.myAnnotationList = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new PackageAnnotationValueProvider());
        }
        return this.myAnnotationList.getValue();
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages() {
        PsiPackage[] psiPackageArray = this.getSubPackages(this.allScope());
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        PsiPackage[] psiPackageArray = this.getFacade().getSubPackages(this, scope);
        if (psiPackageArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getSubPackages"));
        }
        return psiPackageArray;
    }

    private JavaPsiFacadeImpl getFacade() {
        return (JavaPsiFacadeImpl)JavaPsiFacade.getInstance(this.myManager.getProject());
    }

    @NotNull
    private PsiClass[] getCachedClassesByName(String name) {
        PsiClass[] classes2;
        SoftReference<Map<String, PsiClass[]>> ref = this.myClassCache;
        Map<String, PsiClass[]> map = SoftReference.dereference(ref);
        if (map == null) {
            map = new ConcurrentSoftValueHashMap<String, PsiClass[]>();
            this.myClassCache = new SoftReference<ConcurrentSoftValueHashMap<String, PsiClass[]>>((ConcurrentSoftValueHashMap<String, PsiClass[]>)map);
        }
        if ((classes2 = map.get(name)) != null) {
            if (classes2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return classes2;
        }
        EverythingGlobalScope scope = new EverythingGlobalScope(this.getProject());
        if (DumbService.getInstance(this.getProject()).isDumb()) {
            if (ref == null) {
                for (PsiClass psiClass : this.getClasses(scope)) {
                    PsiClass[] psiClassArray;
                    String psiClassName = psiClass.getName();
                    if (psiClassName == null) continue;
                    PsiClass[] existing = map.get(psiClassName);
                    if (existing == null) {
                        PsiClass[] psiClassArray2 = new PsiClass[1];
                        psiClassArray = psiClassArray2;
                        psiClassArray2[0] = psiClass;
                    } else {
                        psiClassArray = ArrayUtil.append(existing, psiClass);
                    }
                    map.put(psiClassName, psiClassArray);
                }
            }
            PsiClass[] psiClassArray = (classes2 = map.get(name)) == null ? PsiClass.EMPTY_ARRAY : classes2;
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
            }
            return psiClassArray;
        }
        String qName = this.getQualifiedName();
        String classQName = !qName.isEmpty() ? qName + "." + name : name;
        classes2 = this.getFacade().findClasses(classQName, scope);
        map.put(name, classes2);
        if (classes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "getCachedClassesByName"));
        }
        return classes2;
    }

    @Override
    public boolean containsClassNamed(String name) {
        return this.getCachedClassesByName(name).length > 0;
    }

    @Override
    @NotNull
    public PsiClass[] findClassByShortName(@NotNull String name, final @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        PsiClass[] allClasses = this.getCachedClassesByName(name);
        if (allClasses.length == 0) {
            if (allClasses == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return allClasses;
        }
        if (allClasses.length == 1) {
            PsiClass[] psiClassArray = PsiSearchScopeUtil.isInScope(scope, (PsiElement)allClasses[0]) ? allClasses : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
            }
            return psiClassArray;
        }
        PsiClass[] array = ContainerUtil.findAllAsArray(allClasses, new Condition<PsiClass>(){

            @Override
            public boolean value(PsiClass aClass) {
                return PsiSearchScopeUtil.isInScope(scope, (PsiElement)aClass);
            }
        });
        Arrays.sort(array, new Comparator<PsiClass>(){

            @Override
            public int compare(PsiClass o1, PsiClass o2) {
                VirtualFile file1 = o1.getContainingFile().getVirtualFile();
                VirtualFile file2 = o2.getContainingFile().getVirtualFile();
                if (file1 == null) {
                    return file2 == null ? 0 : -1;
                }
                if (file2 == null) {
                    return 1;
                }
                return scope.compare(file2, file1);
            }
        });
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/file/PsiPackageImpl", "findClassByShortName"));
        }
        return array;
    }

    @Nullable
    private PsiPackage findSubPackageByName(String name) {
        String qName = this.getQualifiedName();
        String subpackageQName = qName.isEmpty() ? name : qName + "." + name;
        return this.getFacade().findPackage(subpackageQName);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiClass[] classes2;
        String shortName;
        PsiClass[] classes3;
        NameHint nameHint;
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/file/PsiPackageImpl", "processDeclarations"));
        }
        GlobalSearchScope scope = place.getResolveScope();
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        ElementClassHint classHint = processor.getHint(ElementClassHint.KEY);
        JavaPsiFacadeImpl facade = this.getFacade();
        Condition nameCondition = processor.getHint(JavaCompletionHints.NAME_FILTER);
        if ((classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) && ((nameHint = processor.getHint(NameHint.KEY)) != null ? !PsiPackageImpl.processClasses(processor, state, classes3 = this.findClassByShortName(shortName = nameHint.getName(state), scope), Condition.TRUE) : !PsiPackageImpl.processClasses(processor, state, classes2 = this.getClasses(scope), nameCondition != null ? nameCondition : Condition.TRUE))) {
            return false;
        }
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.PACKAGE)) {
            nameHint = processor.getHint(NameHint.KEY);
            if (nameHint != null) {
                PsiPackage aPackage = this.findSubPackageByName(nameHint.getName(state));
                if (aPackage != null && !processor.execute(aPackage, state)) {
                    return false;
                }
            } else {
                PsiPackage[] packs;
                for (PsiPackage pack : packs = this.getSubPackages(scope)) {
                    String packageName = pack.getName();
                    if (packageName == null || !((JavaPsiFacade)facade).getNameHelper().isIdentifier(packageName, PsiUtil.getLanguageLevel(this)) || processor.execute(pack, state)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean processClasses(PsiScopeProcessor processor, ResolveState state, PsiClass[] classes2, @NotNull Condition<String> nameCondition) {
        if (nameCondition == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/file/PsiPackageImpl", "processClasses"));
        }
        for (PsiClass aClass : classes2) {
            String name = aClass.getName();
            if (name == null || !nameCondition.value(name) || processor.execute(aClass, state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void navigate(boolean requestFocus) {
        PsiPackageImplementationHelper.getInstance().navigate(this, requestFocus);
    }

    @Override
    @Nullable
    public PsiModifierList getModifierList() {
        return this.getAnnotationList();
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/file/PsiPackageImpl", "hasModifierProperty"));
        }
        return false;
    }

    @Override
    public PsiQualifiedNamedElement getContainer() {
        return this.getParentPackage();
    }

    private class PackageAnnotationValueProvider
    implements CachedValueProvider<PsiModifierList> {
        private final Object[] OOCB_DEPENDENCY = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};

        private PackageAnnotationValueProvider() {
        }

        @Override
        public CachedValueProvider.Result<PsiModifierList> compute() {
            ArrayList<PsiModifierList> list = new ArrayList<PsiModifierList>();
            for (PsiDirectory directory : PsiPackageImpl.this.getDirectories()) {
                PsiModifierList modifierList;
                PsiPackageStatement stmt;
                PsiFile file = directory.findFile("package-info.java");
                if (file == null || (stmt = PsiTreeUtil.getChildOfType(file, PsiPackageStatement.class)) == null || (modifierList = stmt.getAnnotationList()) == null) continue;
                list.add(modifierList);
            }
            JavaPsiFacadeImpl facade = PsiPackageImpl.this.getFacade();
            GlobalSearchScope scope = PsiPackageImpl.this.allScope();
            for (PsiClass aClass : ((JavaPsiFacade)facade).findClasses(PsiPackageImpl.this.getQualifiedName() + ".package-info", scope)) {
                ContainerUtil.addIfNotNull(aClass.getModifierList(), list);
            }
            return new CachedValueProvider.Result<PsiModifierList>(list.isEmpty() ? null : new PsiCompositeModifierList(PsiPackageImpl.this.getManager(), list), this.OOCB_DEPENDENCY);
        }
    }
}

