/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaHighlightingUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLambdaExpressionType;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.IntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLambdaExpressionImpl
extends ExpressionPsiElement
implements PsiLambdaExpression {
    public PsiLambdaExpressionImpl() {
        super(JavaElementType.LAMBDA_EXPRESSION);
    }

    @Override
    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = PsiTreeUtil.getRequiredChildOfType(this, PsiParameterList.class);
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "getParameterList"));
        }
        return psiParameterList;
    }

    @Override
    public int getChildRole(ASTNode child) {
        IElementType elType = child.getElementType();
        if (elType == JavaTokenType.ARROW) {
            return 252;
        }
        if (elType == JavaElementType.PARAMETER_LIST) {
            return 14;
        }
        if (elType == JavaElementType.CODE_BLOCK) {
            return 18;
        }
        return 64;
    }

    @Override
    public PsiElement getBody() {
        PsiElement element = this.getLastChild();
        return element instanceof PsiExpression || element instanceof PsiCodeBlock ? element : null;
    }

    @Override
    @Nullable
    public PsiType getFunctionalInterfaceType() {
        return FunctionalInterfaceParameterizationUtil.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(this, true), this);
    }

    @Override
    public boolean isVoidCompatible() {
        PsiElement body = this.getBody();
        if (body != null) {
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                int startOffset = controlFlow.getStartOffset(body);
                int endOffset = controlFlow.getEndOffset(body);
                return startOffset != -1 && endOffset != -1 && !ControlFlowUtil.canCompleteNormally(controlFlow, startOffset, endOffset);
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean isValueCompatible() {
        PsiElement body = this.getBody();
        if (body != null) {
            try {
                ControlFlow controlFlow = ControlFlowFactory.getInstance(this.getProject()).getControlFlow(body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                if (ControlFlowUtil.findExitPointsAndStatements(controlFlow, 0, controlFlow.getSize(), new IntArrayList(), PsiReturnStatement.class, PsiThrowStatement.class).isEmpty()) {
                    return false;
                }
            }
            catch (AnalysisCanceledException e) {
                return true;
            }
        }
        return true;
    }

    @Override
    public PsiType getType() {
        return new PsiLambdaExpressionType(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitLambdaExpression(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/tree/java/PsiLambdaExpressionImpl", "processDeclarations"));
        }
        return PsiImplUtil.processDeclarationsInLambda(this, processor, state, lastParent, place);
    }

    @Override
    public String toString() {
        return "PsiLambdaExpression:" + this.getText();
    }

    @Override
    public boolean hasFormalParameterTypes() {
        PsiParameter[] parameters;
        for (PsiParameter parameter : parameters = this.getParameterList().getParameters()) {
            if (parameter.getTypeElement() != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAcceptable(PsiType leftType, boolean checkReturnType) {
        PsiType[] parameterTypes;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (leftType instanceof PsiIntersectionType) {
            for (PsiType conjunctType : ((PsiIntersectionType)leftType).getConjuncts()) {
                if (!this.isAcceptable(conjunctType, checkReturnType)) continue;
                return true;
            }
            return false;
        }
        PsiExpressionList argsList = PsiTreeUtil.getParentOfType((PsiElement)this, PsiExpressionList.class);
        if (MethodCandidateInfo.ourOverloadGuard.currentStack().contains(argsList)) {
            if (!this.hasFormalParameterTypes()) {
                return true;
            }
            MethodCandidateInfo.CurrentCandidateProperties candidateProperties = MethodCandidateInfo.getCurrentMethod(argsList);
            if (candidateProperties != null && !InferenceSession.isPertinentToApplicability(this, candidateProperties.getMethod())) {
                return true;
            }
        }
        if ((psiClass = (resolveResult = PsiUtil.resolveGenericsClassInType(leftType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(leftType, this))).getElement()) instanceof PsiAnonymousClass) {
            return this.isAcceptable(((PsiAnonymousClass)psiClass).getBaseClassType(), checkReturnType);
        }
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod == null) {
            return false;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        assert (leftType != null);
        PsiParameter[] lambdaParameters = this.getParameterList().getParameters();
        if (lambdaParameters.length != (parameterTypes = interfaceMethod.getSignature(substitutor).getParameterTypes()).length) {
            return false;
        }
        int length = lambdaParameters.length;
        for (int lambdaParamIdx = 0; lambdaParamIdx < length; ++lambdaParamIdx) {
            PsiType methodParameterType;
            PsiType lambdaFormalType;
            PsiParameter parameter = lambdaParameters[lambdaParamIdx];
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null || (lambdaFormalType = PsiLambdaExpressionImpl.toArray(typeElement.getType())).equals(methodParameterType = PsiLambdaExpressionImpl.toArray(parameterTypes[lambdaParamIdx]))) continue;
            return false;
        }
        if (checkReturnType) {
            String uniqueVarName = JavaCodeStyleManager.getInstance(this.getProject()).suggestUniqueVariableName("l", (PsiElement)this, true);
            String canonicalText = PsiLambdaExpressionImpl.toArray(leftType).getCanonicalText();
            PsiStatement assignmentFromText = JavaPsiFacade.getElementFactory(this.getProject()).createStatementFromText(canonicalText + " " + uniqueVarName + " = " + this.getText(), this);
            PsiLocalVariable localVariable = (PsiLocalVariable)((PsiDeclarationStatement)assignmentFromText).getDeclaredElements()[0];
            PsiType methodReturnType = interfaceMethod.getReturnType();
            if (methodReturnType != null) {
                return LambdaHighlightingUtil.checkReturnTypeCompatible((PsiLambdaExpression)localVariable.getInitializer(), substitutor.substitute(methodReturnType)) == null;
            }
        }
        return true;
    }

    private static PsiType toArray(PsiType paramType) {
        if (paramType instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)paramType).toArrayType();
        }
        return paramType;
    }
}

