/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class TypeParameterListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.TypeParameterListElement");

    public TypeParameterListElement() {
        super(JavaElementType.TYPE_PARAMETER_LIST);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType elType = child.getElementType();
        if (elType == JavaElementType.TYPE_PARAMETER) {
            return 244;
        }
        if (elType == JavaTokenType.COMMA) {
            return 23;
        }
        if (elType == JavaTokenType.LT) {
            return 121;
        }
        if (elType == JavaTokenType.GT) {
            return 122;
        }
        return 0;
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last2, ASTNode anchor, Boolean before) {
        TreeElement gt;
        TreeElement lt = (TreeElement)this.findChildByRole(121);
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
        if (lt == null) {
            lt = Factory.createSingleLeafElement(JavaTokenType.LT, "<", 0, 1, treeCharTab, this.getManager());
            super.addInternal(lt, lt, this.getFirstChildNode(), Boolean.TRUE);
        }
        if ((gt = (TreeElement)this.findChildByRole(122)) == null) {
            gt = Factory.createSingleLeafElement(JavaTokenType.GT, ">", 0, 1, treeCharTab, this.getManager());
            super.addInternal(gt, gt, this.getLastChildNode(), Boolean.FALSE);
        }
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = gt;
                before = Boolean.TRUE;
            } else {
                anchor = lt;
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last2, anchor, before);
        if (first == last2 && first.getElementType() == JavaElementType.TYPE_PARAMETER) {
            LeafElement comma;
            ASTNode child;
            for (child = first.getTreeNext(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreeNext()) {
                if (child.getElementType() != JavaElementType.TYPE_PARAMETER) continue;
                comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, first, Boolean.FALSE);
                break;
            }
            for (child = first.getTreePrev(); child != null && child.getElementType() != JavaTokenType.COMMA; child = child.getTreePrev()) {
                if (child.getElementType() != JavaElementType.TYPE_PARAMETER) continue;
                comma = Factory.createSingleLeafElement(JavaTokenType.COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode lt;
        ASTNode next;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/TypeParameterListElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JavaElementType.TYPE_PARAMETER) {
            ASTNode next2 = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next2 != null && next2.getElementType() == JavaTokenType.COMMA) {
                this.deleteChildInternal(next2);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
        if (child.getElementType() == JavaElementType.TYPE_PARAMETER && (next = PsiImplUtil.skipWhitespaceAndComments((lt = this.findChildByRole(121)).getTreeNext())) != null && next.getElementType() == JavaTokenType.GT) {
            this.deleteChildInternal(lt);
            this.deleteChildInternal(next);
        }
    }
}

