/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectUtils {
    public static final Object NULL = new Object();

    @NotNull
    public static <T> T assertNotNull(@Nullable T t) {
        T t2 = ObjectUtils._assertNotNull(t);
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "assertNotNull"));
        }
        return t2;
    }

    @NotNull
    private static <T> T _assertNotNull(@NotNull T t) {
        if (t == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/util/ObjectUtils", "_assertNotNull"));
        }
        T t2 = t;
        if (t2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "_assertNotNull"));
        }
        return t2;
    }

    @NotNull
    public static <T> T notNull(@Nullable T value, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/util/ObjectUtils", "notNull"));
        }
        T t = value != null ? value : defaultValue;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ObjectUtils", "notNull"));
        }
        return t;
    }
}

