/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.codegen.binding;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.asm4.Type;
import org.jetbrains.jet.codegen.PackageCodegen;
import org.jetbrains.jet.codegen.binding.CodegenBinding;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.java.PackageClassUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public final class PsiCodegenPredictor {
    private PsiCodegenPredictor() {
    }

    public static boolean checkPredictedNameFromPsi(@NotNull BindingTrace bindingTrace, @NotNull DeclarationDescriptor descriptor, @Nullable Type nameFromDescriptors) {
        if (bindingTrace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingTrace", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "checkPredictedNameFromPsi"));
        }
        PsiElement element = BindingContextUtils.descriptorToDeclaration(bindingTrace.getBindingContext(), descriptor);
        if (element instanceof JetDeclaration) {
            String classNameFromPsi = PsiCodegenPredictor.getPredefinedJvmInternalName((JetDeclaration)element);
            assert (classNameFromPsi == null || Type.getObjectType(classNameFromPsi).equals(nameFromDescriptors)) : String.format("Invalid algorithm for getting qualified name from psi! Predicted: %s, actual %s\nElement: %s", classNameFromPsi, nameFromDescriptors, element.getText());
        }
        return true;
    }

    @Nullable
    public static String getPredefinedJvmInternalName(@NotNull JetDeclaration declaration) {
        String parentInternalName;
        if (declaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getPredefinedJvmInternalName"));
        }
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)declaration, JetDeclaration.class);
        if (parentDeclaration instanceof JetClassObject) {
            assert (declaration instanceof JetObjectDeclaration) : "Only object declarations can be children of JetClassObject: " + declaration;
            return PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration);
        }
        if (parentDeclaration != null) {
            parentInternalName = PsiCodegenPredictor.getPredefinedJvmInternalName(parentDeclaration);
            if (parentInternalName == null) {
                return null;
            }
        } else {
            String packageName = ((JetFile)declaration.getContainingFile()).getPackageName();
            if (packageName == null) {
                return null;
            }
            if (declaration instanceof JetNamedFunction) {
                JvmClassName packageClass = JvmClassName.byFqNameWithoutInnerClasses(PackageClassUtils.getPackageClassFqName(new FqName(packageName)));
                Name name = ((JetNamedFunction)declaration).getNameAsName();
                return name == null ? null : packageClass.getInternalName() + "$" + name.asString();
            }
            parentInternalName = JvmClassName.byFqNameWithoutInnerClasses(packageName).getInternalName();
        }
        if (declaration instanceof JetClassObject) {
            return parentInternalName + "$object";
        }
        if (!PsiTreeUtil.instanceOf(declaration, JetClass.class, JetObjectDeclaration.class, JetNamedFunction.class, JetProperty.class) || declaration instanceof JetEnumEntry) {
            return null;
        }
        Name name = ((JetNamedDeclaration)declaration).getNameAsName();
        if (name == null) {
            return null;
        }
        if (declaration instanceof JetNamedFunction && !(parentDeclaration instanceof JetClass) && !(parentDeclaration instanceof JetObjectDeclaration)) {
            return null;
        }
        if (declaration instanceof JetProperty) {
            return parentInternalName + "$" + name.asString();
        }
        if (parentInternalName.isEmpty()) {
            return name.asString();
        }
        return parentInternalName + (parentDeclaration == null ? "/" : "$") + name.asString();
    }

    @Nullable
    public static JetFile getFileForPackagePartName(@NotNull Collection<JetFile> allPackageFiles, @NotNull JvmClassName className) {
        if (allPackageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageFiles", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForPackagePartName"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForPackagePartName"));
        }
        for (JetFile file : allPackageFiles) {
            String internalName = PackageCodegen.getPackagePartInternalName(file);
            JvmClassName jvmClassName = JvmClassName.byInternalName(internalName);
            if (!jvmClassName.equals(className)) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static JetFile getFileForCodegenNamedClass(@NotNull BindingContext context, @NotNull Collection<JetFile> allPackageFiles, final @NotNull String classInternalName) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (allPackageFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allPackageFiles", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        if (classInternalName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classInternalName", "org/jetbrains/jet/codegen/binding/PsiCodegenPredictor", "getFileForCodegenNamedClass"));
        }
        final Ref resultingDescriptor = Ref.create();
        DelegatingBindingTrace trace = new DelegatingBindingTrace(context, "trace in PsiCodegenPredictor"){

            @Override
            public <K, V> void record(WritableSlice<K, V> slice, K key, V value) {
                super.record(slice, key, value);
                if (slice == CodegenBinding.ASM_TYPE && key instanceof DeclarationDescriptor && value instanceof Type && classInternalName.equals(((Type)value).getInternalName())) {
                    resultingDescriptor.set((DeclarationDescriptor)key);
                }
            }
        };
        CodegenBinding.initTrace(trace, allPackageFiles);
        return resultingDescriptor.isNull() ? null : BindingContextUtils.getContainingFile(trace.getBindingContext(), (DeclarationDescriptor)resultingDescriptor.get());
    }
}

