/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.descriptors.serialization;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.descriptors.serialization.Flags;
import org.jetbrains.jet.descriptors.serialization.Interner;
import org.jetbrains.jet.descriptors.serialization.NameTable;
import org.jetbrains.jet.descriptors.serialization.ProtoBuf;
import org.jetbrains.jet.descriptors.serialization.SerializerExtension;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PackageFragmentDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.Annotated;
import org.jetbrains.jet.lang.resolve.DescriptorFactory;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.KotlinBuiltIns;
import org.jetbrains.jet.renderer.DescriptorRenderer;

public class DescriptorSerializer {
    private static final DescriptorRenderer RENDERER = DescriptorRenderer.STARTS_FROM_NAME;
    private static final Comparator<DeclarationDescriptor> DESCRIPTOR_COMPARATOR = new Comparator<DeclarationDescriptor>(){

        @Override
        public int compare(@NotNull DeclarationDescriptor o1, @NotNull DeclarationDescriptor o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer$1", "compare"));
            }
            int names = o1.getName().compareTo(o2.getName());
            if (names != 0) {
                return names;
            }
            String o1String = RENDERER.render(o1);
            String o2String = RENDERER.render(o2);
            return o1String.compareTo(o2String);
        }
    };
    private final NameTable nameTable;
    private final Interner<TypeParameterDescriptor> typeParameters;
    private final SerializerExtension extension;

    public DescriptorSerializer() {
        this(SerializerExtension.DEFAULT);
    }

    public DescriptorSerializer(@NotNull SerializerExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "<init>"));
        }
        this(new NameTable(), new Interner<TypeParameterDescriptor>(), extension);
    }

    private DescriptorSerializer(NameTable nameTable, Interner<TypeParameterDescriptor> typeParameters, SerializerExtension extension) {
        this.nameTable = nameTable;
        this.typeParameters = typeParameters;
        this.extension = extension;
    }

    private DescriptorSerializer createChildSerializer() {
        return new DescriptorSerializer(this.nameTable, new Interner<TypeParameterDescriptor>(this.typeParameters), this.extension);
    }

    @NotNull
    public NameTable getNameTable() {
        NameTable nameTable = this.nameTable;
        if (nameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getNameTable"));
        }
        return nameTable;
    }

    @NotNull
    public ProtoBuf.Class.Builder classProto(@NotNull ClassDescriptor classDescriptor) {
        ConstructorDescriptor primaryConstructor;
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classProto"));
        }
        ProtoBuf.Class.Builder builder = ProtoBuf.Class.newBuilder();
        int flags = Flags.getClassFlags(DescriptorSerializer.hasAnnotations(classDescriptor), classDescriptor.getVisibility(), classDescriptor.getModality(), classDescriptor.getKind(), classDescriptor.isInner());
        builder.setFlags(flags);
        builder.setFqName(this.getClassId(classDescriptor));
        DescriptorSerializer local = this.createChildSerializer();
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getTypeConstructor().getParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        if (this.extension.hasSupertypes(classDescriptor)) {
            for (JetType supertype : classDescriptor.getTypeConstructor().getSupertypes()) {
                builder.addSupertype(local.type(supertype));
            }
        }
        if ((primaryConstructor = classDescriptor.getUnsubstitutedPrimaryConstructor()) != null) {
            if (DescriptorFactory.isDefaultPrimaryConstructor(primaryConstructor)) {
                builder.setPrimaryConstructor(ProtoBuf.Class.PrimaryConstructor.getDefaultInstance());
            } else {
                ProtoBuf.Class.PrimaryConstructor.Builder constructorBuilder = ProtoBuf.Class.PrimaryConstructor.newBuilder();
                constructorBuilder.setData(local.callableProto(primaryConstructor));
                builder.setPrimaryConstructor(constructorBuilder);
            }
        }
        for (DeclarationDescriptor descriptor : DescriptorSerializer.sort(classDescriptor.getDefaultType().getMemberScope().getAllDescriptors())) {
            CallableMemberDescriptor member;
            if (!(descriptor instanceof CallableMemberDescriptor) || (member = (CallableMemberDescriptor)descriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) continue;
            builder.addMember(local.callableProto(member));
        }
        Collection<DeclarationDescriptor> nestedClasses2 = classDescriptor.getUnsubstitutedInnerClassesScope().getAllDescriptors();
        for (DeclarationDescriptor descriptor : DescriptorSerializer.sort(nestedClasses2)) {
            if (DescriptorUtils.isEnumEntry(descriptor)) continue;
            builder.addNestedClassName(this.nameTable.getSimpleNameIndex(descriptor.getName()));
        }
        ClassDescriptor classObject = classDescriptor.getClassObjectDescriptor();
        if (classObject != null) {
            builder.setClassObject(this.classObjectProto(classObject));
        }
        if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
            for (DeclarationDescriptor descriptor : nestedClasses2) {
                if (!DescriptorUtils.isEnumEntry(descriptor)) continue;
                builder.addEnumEntry(this.nameTable.getSimpleNameIndex(descriptor.getName()));
            }
        }
        ProtoBuf.Class.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classProto"));
        }
        return builder2;
    }

    @NotNull
    private ProtoBuf.Class.ClassObject classObjectProto(@NotNull ClassDescriptor classObject) {
        if (classObject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classObject", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classObjectProto"));
        }
        if (DescriptorUtils.isObject(classObject.getContainingDeclaration())) {
            ProtoBuf.Class.ClassObject classObject2 = ProtoBuf.Class.ClassObject.newBuilder().setData(this.classProto(classObject)).build();
            if (classObject2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classObjectProto"));
            }
            return classObject2;
        }
        ProtoBuf.Class.ClassObject classObject3 = ProtoBuf.Class.ClassObject.getDefaultInstance();
        if (classObject3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "classObjectProto"));
        }
        return classObject3;
    }

    @NotNull
    public ProtoBuf.Callable.Builder callableProto(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableProto"));
        }
        ProtoBuf.Callable.Builder builder = ProtoBuf.Callable.newBuilder();
        DescriptorSerializer local = this.createChildSerializer();
        boolean hasGetter = false;
        boolean hasSetter = false;
        boolean hasConstant = false;
        if (descriptor instanceof PropertyDescriptor) {
            PropertySetterDescriptor setter;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            int propertyFlags = Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(propertyDescriptor), propertyDescriptor.getVisibility(), propertyDescriptor.getModality(), false);
            PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
            if (getter != null) {
                hasGetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(getter);
                if (accessorFlags != propertyFlags) {
                    builder.setGetterFlags(accessorFlags);
                }
            }
            if ((setter = propertyDescriptor.getSetter()) != null) {
                hasSetter = true;
                int accessorFlags = DescriptorSerializer.getAccessorFlags(setter);
                if (accessorFlags != propertyFlags) {
                    builder.setSetterFlags(accessorFlags);
                }
                if (!setter.isDefault()) {
                    for (ValueParameterDescriptor valueParameterDescriptor : setter.getValueParameters()) {
                        builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
                    }
                }
            }
            hasConstant = propertyDescriptor.getCompileTimeInitializer() != null;
        }
        builder.setFlags(Flags.getCallableFlags(DescriptorSerializer.hasAnnotations(descriptor), descriptor.getVisibility(), descriptor.getModality(), descriptor.getKind(), DescriptorSerializer.callableKind(descriptor), hasGetter, hasSetter, hasConstant));
        for (TypeParameterDescriptor typeParameterDescriptor : descriptor.getTypeParameters()) {
            builder.addTypeParameter(local.typeParameter(typeParameterDescriptor));
        }
        ReceiverParameterDescriptor receiverParameter = descriptor.getReceiverParameter();
        if (receiverParameter != null) {
            builder.setReceiverType(local.type(receiverParameter.getType()));
        }
        builder.setName(this.nameTable.getSimpleNameIndex(descriptor.getName()));
        for (ValueParameterDescriptor valueParameterDescriptor : descriptor.getValueParameters()) {
            builder.addValueParameter(local.valueParameter(valueParameterDescriptor));
        }
        builder.setReturnType(local.type(DescriptorSerializer.getSerializableReturnType(descriptor.getReturnType())));
        this.extension.serializeCallable(descriptor, builder, this.nameTable);
        ProtoBuf.Callable.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableProto"));
        }
        return builder2;
    }

    @NotNull
    private static JetType getSerializableReturnType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getSerializableReturnType"));
        }
        JetType jetType = DescriptorSerializer.isSerializableType(type) ? type : KotlinBuiltIns.getInstance().getAnyType();
        if (jetType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getSerializableReturnType"));
        }
        return jetType;
    }

    private static boolean isSerializableType(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "isSerializableType"));
        }
        ClassifierDescriptor descriptor = type.getConstructor().getDeclarationDescriptor();
        if (descriptor instanceof TypeParameterDescriptor) {
            return true;
        }
        if (descriptor instanceof ClassDescriptor) {
            for (TypeProjection projection : type.getArguments()) {
                if (DescriptorSerializer.isSerializableType(projection.getType())) continue;
                return false;
            }
            return DescriptorUtils.isTopLevelOrInnerClass((ClassDescriptor)descriptor);
        }
        throw new IllegalStateException("Unknown type constructor: " + type);
    }

    private static int getAccessorFlags(@NotNull PropertyAccessorDescriptor accessor) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getAccessorFlags"));
        }
        return Flags.getAccessorFlags(DescriptorSerializer.hasAnnotations(accessor), accessor.getVisibility(), accessor.getModality(), !accessor.isDefault());
    }

    @NotNull
    private static ProtoBuf.Callable.CallableKind callableKind(@NotNull CallableMemberDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableKind"));
        }
        if (descriptor instanceof PropertyDescriptor) {
            ProtoBuf.Callable.CallableKind callableKind = ((PropertyDescriptor)descriptor).isVar() ? ProtoBuf.Callable.CallableKind.VAR : ProtoBuf.Callable.CallableKind.VAL;
            if (callableKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableKind"));
            }
            return callableKind;
        }
        if (descriptor instanceof ConstructorDescriptor) {
            ProtoBuf.Callable.CallableKind callableKind = ProtoBuf.Callable.CallableKind.CONSTRUCTOR;
            if (callableKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableKind"));
            }
            return callableKind;
        }
        assert (descriptor instanceof FunctionDescriptor) : "Unknown descriptor class: " + descriptor.getClass();
        ProtoBuf.Callable.CallableKind callableKind = ProtoBuf.Callable.CallableKind.FUN;
        if (callableKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "callableKind"));
        }
        return callableKind;
    }

    @NotNull
    private ProtoBuf.Callable.ValueParameter.Builder valueParameter(@NotNull ValueParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "valueParameter"));
        }
        ProtoBuf.Callable.ValueParameter.Builder builder = ProtoBuf.Callable.ValueParameter.newBuilder();
        builder.setFlags(Flags.getValueParameterFlags(DescriptorSerializer.hasAnnotations(descriptor), descriptor.declaresDefaultValue()));
        builder.setName(this.nameTable.getSimpleNameIndex(descriptor.getName()));
        builder.setType(this.type(descriptor.getType()));
        JetType varargElementType = descriptor.getVarargElementType();
        if (varargElementType != null) {
            builder.setVarargElementType(this.type(varargElementType));
        }
        this.extension.serializeValueParameter(descriptor, builder, this.nameTable);
        ProtoBuf.Callable.ValueParameter.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "valueParameter"));
        }
        return builder2;
    }

    private ProtoBuf.TypeParameter.Builder typeParameter(TypeParameterDescriptor typeParameter) {
        ProtoBuf.TypeParameter.Variance variance;
        ProtoBuf.TypeParameter.Builder builder = ProtoBuf.TypeParameter.newBuilder();
        builder.setId(this.getTypeParameterId(typeParameter));
        builder.setName(this.nameTable.getSimpleNameIndex(typeParameter.getName()));
        if (typeParameter.isReified()) {
            builder.setReified(true);
        }
        if ((variance = DescriptorSerializer.variance(typeParameter.getVariance())) != ProtoBuf.TypeParameter.Variance.INV) {
            builder.setVariance(variance);
        }
        for (JetType upperBound : typeParameter.getUpperBounds()) {
            builder.addUpperBound(this.type(upperBound));
        }
        return builder;
    }

    private static ProtoBuf.TypeParameter.Variance variance(Variance variance) {
        switch (variance) {
            case INVARIANT: {
                return ProtoBuf.TypeParameter.Variance.INV;
            }
            case IN_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.IN;
            }
            case OUT_VARIANCE: {
                return ProtoBuf.TypeParameter.Variance.OUT;
            }
        }
        throw new IllegalStateException("Unknown variance: " + (Object)((Object)variance));
    }

    @NotNull
    public ProtoBuf.Type.Builder type(@NotNull JetType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "type"));
        }
        assert (!type.isError()) : "Can't serialize error types: " + type;
        ProtoBuf.Type.Builder builder = ProtoBuf.Type.newBuilder();
        builder.setConstructor(this.typeConstructor(type.getConstructor()));
        for (TypeProjection projection : type.getArguments()) {
            builder.addArgument(this.typeArgument(projection));
        }
        if (type.isNullable()) {
            builder.setNullable(true);
        }
        ProtoBuf.Type.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "type"));
        }
        return builder2;
    }

    @NotNull
    private ProtoBuf.Type.Argument.Builder typeArgument(@NotNull TypeProjection typeProjection) {
        if (typeProjection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeProjection", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeArgument"));
        }
        ProtoBuf.Type.Argument.Builder builder = ProtoBuf.Type.Argument.newBuilder();
        ProtoBuf.Type.Argument.Projection projection = DescriptorSerializer.projection(typeProjection.getProjectionKind());
        if (projection != ProtoBuf.Type.Argument.Projection.INV) {
            builder.setProjection(projection);
        }
        builder.setType(this.type(typeProjection.getType()));
        ProtoBuf.Type.Argument.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeArgument"));
        }
        return builder2;
    }

    @NotNull
    private ProtoBuf.Type.Constructor.Builder typeConstructor(@NotNull TypeConstructor typeConstructor) {
        if (typeConstructor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeConstructor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeConstructor"));
        }
        ProtoBuf.Type.Constructor.Builder builder = ProtoBuf.Type.Constructor.newBuilder();
        ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
        assert (declarationDescriptor instanceof TypeParameterDescriptor || declarationDescriptor instanceof ClassDescriptor) : "Unknown declaration descriptor: " + typeConstructor;
        if (declarationDescriptor instanceof TypeParameterDescriptor) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
            builder.setKind(ProtoBuf.Type.Constructor.Kind.TYPE_PARAMETER);
            builder.setId(this.getTypeParameterId(typeParameterDescriptor));
        } else {
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            builder.setId(this.getClassId(classDescriptor));
        }
        ProtoBuf.Type.Constructor.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "typeConstructor"));
        }
        return builder2;
    }

    @NotNull
    public ProtoBuf.Package.Builder packageProto(@NotNull Collection<PackageFragmentDescriptor> fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "packageProto"));
        }
        ProtoBuf.Package.Builder builder = ProtoBuf.Package.newBuilder();
        ArrayList<DeclarationDescriptor> members = Lists.newArrayList();
        for (PackageFragmentDescriptor fragment : fragments) {
            members.addAll(fragment.getMemberScope().getAllDescriptors());
        }
        for (DeclarationDescriptor declaration : DescriptorSerializer.sort(members)) {
            if (!(declaration instanceof PropertyDescriptor) && !(declaration instanceof FunctionDescriptor)) continue;
            builder.addMember(this.callableProto((CallableMemberDescriptor)declaration));
        }
        ProtoBuf.Package.Builder builder2 = builder;
        if (builder2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "packageProto"));
        }
        return builder2;
    }

    @NotNull
    private static ProtoBuf.Type.Argument.Projection projection(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
        }
        switch (projectionKind) {
            case INVARIANT: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.INV;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case IN_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.IN;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
            case OUT_VARIANCE: {
                ProtoBuf.Type.Argument.Projection projection = ProtoBuf.Type.Argument.Projection.OUT;
                if (projection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "projection"));
                }
                return projection;
            }
        }
        throw new IllegalStateException("Unknown projectionKind: " + (Object)((Object)projectionKind));
    }

    private int getClassId(@NotNull ClassDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getClassId"));
        }
        return this.nameTable.getFqNameIndex(descriptor);
    }

    private int getTypeParameterId(@NotNull TypeParameterDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "getTypeParameterId"));
        }
        return this.typeParameters.intern(descriptor);
    }

    private static boolean hasAnnotations(Annotated descriptor) {
        return !descriptor.getAnnotations().isEmpty();
    }

    @NotNull
    public static <T extends DeclarationDescriptor> List<T> sort(@NotNull Collection<T> descriptors) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "sort"));
        }
        ArrayList<T> result2 = new ArrayList<T>(descriptors);
        Collections.sort(result2, DESCRIPTOR_COMPARATOR);
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/descriptors/serialization/DescriptorSerializer", "sort"));
        }
        return arrayList;
    }
}

