/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.cfg.pseudocode;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.pseudocode.Instruction;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitor;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionVisitorWithResult;
import org.jetbrains.jet.lang.cfg.pseudocode.InstructionWithNext;
import org.jetbrains.jet.lang.cfg.pseudocode.LexicalScope;
import org.jetbrains.jet.lang.cfg.pseudocode.Pseudocode;
import org.jetbrains.jet.lang.cfg.pseudocode.SubroutineSinkInstruction;
import org.jetbrains.jet.lang.psi.JetElement;

public class LocalFunctionDeclarationInstruction
extends InstructionWithNext {
    private final Pseudocode body;
    private Instruction sink;

    public LocalFunctionDeclarationInstruction(@NotNull JetElement element, @NotNull Pseudocode body, LexicalScope lexicalScope) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "<init>"));
        }
        if (body == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "body", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "<init>"));
        }
        super(element, lexicalScope);
        this.body = body;
    }

    @NotNull
    public Pseudocode getBody() {
        Pseudocode pseudocode = this.body;
        if (pseudocode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "getBody"));
        }
        return pseudocode;
    }

    @Override
    @NotNull
    public Collection<Instruction> getNextInstructions() {
        if (this.sink != null) {
            ArrayList<Instruction> instructions = Lists.newArrayList(this.sink);
            instructions.addAll(super.getNextInstructions());
            ArrayList<Instruction> arrayList = instructions;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "getNextInstructions"));
            }
            return arrayList;
        }
        Collection<Instruction> collection = super.getNextInstructions();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "getNextInstructions"));
        }
        return collection;
    }

    public void setSink(SubroutineSinkInstruction sink) {
        this.sink = this.outgoingEdgeTo(sink);
    }

    @Override
    public void accept(@NotNull InstructionVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "accept"));
        }
        visitor.visitLocalFunctionDeclarationInstruction(this);
    }

    @Override
    public <R> R accept(@NotNull InstructionVisitorWithResult<R> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "accept"));
        }
        return visitor.visitLocalFunctionDeclarationInstruction(this);
    }

    public String toString() {
        return "d(" + this.render(this.element) + ")";
    }

    @Override
    @NotNull
    protected Instruction createCopy() {
        LocalFunctionDeclarationInstruction localFunctionDeclarationInstruction = new LocalFunctionDeclarationInstruction(this.element, this.body, this.lexicalScope);
        if (localFunctionDeclarationInstruction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jet/lang/cfg/pseudocode/LocalFunctionDeclarationInstruction", "createCopy"));
        }
        return localFunctionDeclarationInstruction;
    }
}

