/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetAnnotation;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetElementImpl;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetVisitor;

public class JetTypeReference
extends JetElementImpl {
    public JetTypeReference(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/jet/lang/psi/JetTypeReference", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data2) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/jet/lang/psi/JetTypeReference", "accept"));
        }
        return visitor.visitTypeReference(this, data2);
    }

    public List<JetAnnotation> getAttributeAnnotations() {
        return this.findChildrenByType(JetNodeTypes.ANNOTATION);
    }

    @Nullable
    public JetTypeElement getTypeElement() {
        return this.findChildByClass(JetTypeElement.class);
    }

    public List<JetAnnotationEntry> getAnnotations() {
        List<JetAnnotationEntry> answer = null;
        for (JetAnnotation annotation : this.getAttributeAnnotations()) {
            if (answer == null) {
                answer = new ArrayList<JetAnnotationEntry>();
            }
            answer.addAll(annotation.getEntries());
        }
        return answer != null ? answer : Collections.emptyList();
    }
}

