/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.operation;

import com.google.common.collect.ImmutableCollection;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.operation.IntrinsicAssignmentTranslator;
import org.jetbrains.k2js.translate.operation.OverloadedAssignmentTranslator;
import org.jetbrains.k2js.translate.reference.AccessTranslationUtils;
import org.jetbrains.k2js.translate.reference.AccessTranslator;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public abstract class AssignmentTranslator
extends AbstractTranslator {
    @NotNull
    protected final JetBinaryExpression expression;
    protected final AccessTranslator accessTranslator;
    protected final boolean isVariableReassignment;
    @NotNull
    protected final JsExpression right;

    public static boolean isAssignmentOperator(JetBinaryExpression expression) {
        JetToken operationToken = PsiUtils.getOperationToken(expression);
        return ((ImmutableCollection)((Object)OperatorConventions.ASSIGNMENT_OPERATIONS.keySet())).contains(operationToken) || PsiUtils.isAssignment(operationToken);
    }

    @NotNull
    public static JsExpression translate(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/AssignmentTranslator", "translate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/AssignmentTranslator", "translate"));
        }
        if (TranslationUtils.hasCorrespondingFunctionIntrinsic(context, expression)) {
            JsExpression jsExpression = IntrinsicAssignmentTranslator.doTranslate(expression, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/AssignmentTranslator", "translate"));
            }
            return jsExpression;
        }
        JsExpression jsExpression = OverloadedAssignmentTranslator.doTranslate(expression, context);
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/k2js/translate/operation/AssignmentTranslator", "translate"));
        }
        return jsExpression;
    }

    protected AssignmentTranslator(@NotNull JetBinaryExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/k2js/translate/operation/AssignmentTranslator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/k2js/translate/operation/AssignmentTranslator", "<init>"));
        }
        super(context);
        this.expression = expression;
        this.isVariableReassignment = BindingUtils.isVariableReassignment(context.bindingContext(), expression);
        JetExpression left = expression.getLeft();
        assert (left != null) : "No left-hand side: " + expression.getText();
        this.accessTranslator = AccessTranslationUtils.getAccessTranslator(left, this.context());
        this.right = TranslationUtils.translateRightExpression(this.context(), expression);
    }
}

