/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterListStub;
import com.intellij.psi.impl.java.stubs.PsiTypeParameterStub;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterListStubImpl;
import com.intellij.psi.impl.java.stubs.impl.PsiTypeParameterStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.StringRef;
import java.text.CharacterIterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SignatureParsing {
    private SignatureParsing() {
    }

    public static PsiTypeParameterListStub parseTypeParametersDeclaration(CharacterIterator signatureIterator, StubElement parentStub) throws ClsFormatException {
        PsiTypeParameterListStubImpl list = new PsiTypeParameterListStubImpl(parentStub);
        if (signatureIterator.current() == '<') {
            signatureIterator.next();
            while (signatureIterator.current() != '>') {
                SignatureParsing.parseTypeParameter(signatureIterator, list);
            }
            signatureIterator.next();
        }
        return list;
    }

    private static PsiTypeParameterStub parseTypeParameter(CharacterIterator iterator2, PsiTypeParameterListStub parent) throws ClsFormatException {
        StringBuilder name = new StringBuilder();
        while (iterator2.current() != ':' && iterator2.current() != '\uffff') {
            name.append(iterator2.current());
            iterator2.next();
        }
        if (iterator2.current() == '\uffff') {
            throw new ClsFormatException();
        }
        PsiTypeParameterStubImpl parameterStub = new PsiTypeParameterStubImpl((StubElement)parent, StringRef.fromString(name.toString()));
        List<Object> bounds = ContainerUtil.newSmartList(new Object[0]);
        while (iterator2.current() == ':') {
            iterator2.next();
            String bound = SignatureParsing.parseTopLevelClassRefSignature(iterator2);
            if (bound == null) continue;
            bounds.add(bound);
        }
        int size = bounds.size();
        if (size > 0 && "java.lang.Object".equals(bounds.get(size - 1))) {
            bounds.remove(size - 1);
        }
        StubBuildingVisitor.newReferenceList(JavaStubElementTypes.EXTENDS_BOUND_LIST, parameterStub, ArrayUtil.toStringArray(bounds));
        return parameterStub;
    }

    @Nullable
    public static String parseTopLevelClassRefSignature(CharacterIterator signature) throws ClsFormatException {
        if (signature.current() == 'L') {
            return SignatureParsing.parseParameterizedClassRefSignature(signature);
        }
        if (signature.current() == 'T') {
            return SignatureParsing.parseTypeVariableRefSignature(signature);
        }
        return null;
    }

    private static String parseTypeVariableRefSignature(CharacterIterator signature) {
        signature.next();
        StringBuilder id = new StringBuilder();
        while (signature.current() != ';' && signature.current() != '>') {
            id.append(signature.current());
            signature.next();
        }
        if (signature.current() == ';') {
            signature.next();
        }
        return id.toString();
    }

    private static String parseParameterizedClassRefSignature(CharacterIterator signature) throws ClsFormatException {
        assert (signature.current() == 'L');
        signature.next();
        StringBuffer canonicalText = new StringBuffer();
        while (signature.current() != ';' && signature.current() != '\uffff') {
            switch (signature.current()) {
                case '$': {
                    if (signature.getIndex() > 0) {
                        boolean standAlone$;
                        char previous = signature.previous();
                        signature.next();
                        boolean bl = standAlone$ = !StringUtil.isJavaIdentifierPart(previous);
                        if (standAlone$) {
                            canonicalText.append('$');
                            break;
                        }
                        if (signature.getIndex() + 1 < signature.getEndIndex()) {
                            char next = signature.next();
                            signature.previous();
                            boolean bl2 = standAlone$ = !StringUtil.isJavaIdentifierPart(next);
                            if (standAlone$) {
                                canonicalText.append('$');
                                break;
                            }
                        }
                    }
                }
                case '.': 
                case '/': {
                    canonicalText.append('.');
                    break;
                }
                case '<': {
                    canonicalText.append('<');
                    signature.next();
                    do {
                        SignatureParsing.processTypeArgument(signature, canonicalText);
                    } while (signature.current() != '>');
                    canonicalText.append('>');
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    canonicalText.append(signature.current());
                }
            }
            signature.next();
        }
        if (signature.current() == '\uffff') {
            throw new ClsFormatException();
        }
        for (int index = 0; index < canonicalText.length(); ++index) {
            char c = canonicalText.charAt(index);
            if ('0' > c || c > '1' || index <= 0 || canonicalText.charAt(index - 1) != '.') continue;
            canonicalText.setCharAt(index - 1, '$');
        }
        signature.next();
        return canonicalText.toString();
    }

    private static void processTypeArgument(CharacterIterator signature, StringBuffer canonicalText) throws ClsFormatException {
        String typeArgument = SignatureParsing.parseClassOrTypeVariableElement(signature);
        canonicalText.append(typeArgument);
        if (signature.current() != '>') {
            canonicalText.append(',');
        }
    }

    public static String parseClassOrTypeVariableElement(CharacterIterator signature) throws ClsFormatException {
        char variance = SignatureParsing.parseVariance(signature);
        if (variance == '*') {
            return SignatureParsing.decorateTypeText("*", variance);
        }
        int arrayCount = 0;
        while (signature.current() == '[') {
            ++arrayCount;
            signature.next();
        }
        String type = SignatureParsing.parseTypeWithoutVariance(signature);
        if (type != null) {
            String ref = type;
            while (arrayCount > 0) {
                ref = ref + "[]";
                --arrayCount;
            }
            return SignatureParsing.decorateTypeText(ref, variance);
        }
        throw new ClsFormatException();
    }

    private static String decorateTypeText(String canonical, char variance) {
        switch (variance) {
            case '\u0000': {
                return canonical;
            }
            case '+': {
                return "? extends " + canonical;
            }
            case '-': {
                return "? super " + canonical;
            }
            case '*': {
                return "?";
            }
        }
        assert (false) : "unknown variance";
        return null;
    }

    private static char parseVariance(CharacterIterator signature) {
        char variance;
        switch (signature.current()) {
            case '*': 
            case '+': 
            case '-': {
                variance = signature.current();
                signature.next();
                break;
            }
            case '.': 
            case '=': {
                signature.next();
            }
            default: {
                variance = '\u0000';
            }
        }
        return variance;
    }

    public static String parseTypeString(CharacterIterator signature) throws ClsFormatException {
        int arrayDimensions = 0;
        while (signature.current() == '[') {
            ++arrayDimensions;
            signature.next();
        }
        char variance = SignatureParsing.parseVariance(signature);
        String text = SignatureParsing.parseTypeWithoutVariance(signature);
        if (text == null) {
            throw new ClsFormatException();
        }
        for (int i = 0; i < arrayDimensions; ++i) {
            text = text + "[]";
        }
        if (variance != '\u0000') {
            text = variance + text;
        }
        return text;
    }

    @Nullable
    private static String parseTypeWithoutVariance(CharacterIterator signature) throws ClsFormatException {
        String text;
        switch (signature.current()) {
            case 'L': {
                text = SignatureParsing.parseParameterizedClassRefSignature(signature);
                break;
            }
            case 'T': {
                text = SignatureParsing.parseTypeVariableRefSignature(signature);
                break;
            }
            case 'B': {
                text = "byte";
                signature.next();
                break;
            }
            case 'C': {
                text = "char";
                signature.next();
                break;
            }
            case 'D': {
                text = "double";
                signature.next();
                break;
            }
            case 'F': {
                text = "float";
                signature.next();
                break;
            }
            case 'I': {
                text = "int";
                signature.next();
                break;
            }
            case 'J': {
                text = "long";
                signature.next();
                break;
            }
            case 'S': {
                text = "short";
                signature.next();
                break;
            }
            case 'Z': {
                text = "boolean";
                signature.next();
                break;
            }
            case 'V': {
                text = "void";
                signature.next();
                break;
            }
            default: {
                return null;
            }
        }
        return text;
    }
}

